<?php 

use Illuminate\Support\Facades\File;
use App\Models\Currencies;


if(!function_exists('getEcommerceThemes'))
{
    function getEcommerceThemes()
    {
        $publicPath = public_path('user_ecommerce'); // Get the public folder path
        $directories = scandir($publicPath); // Get all the files and directories in the public folder

        $folders = array_filter($directories, function ($dir) use ($publicPath) {
            // Exclude '.', '..', and numeric folder names
            return is_dir($publicPath . '/' . $dir) 
                && !in_array($dir, ['.', '..']) 
                && !is_numeric($dir);
        });
        
        $screenshotsAndThemes = [];
        foreach ($folders as $folder) {
            $screenshotPath = $publicPath . '/' . $folder . '/screenshot.png'; // Absolute path to the screenshot
            $screenshotsAndThemes[] = [
                'screenshot' => file_exists($screenshotPath) 
                    ? asset('user_ecommerce/' . $folder . '/screenshot.png') 
                    : 'https://placehold.co/600x400', // Use placeholder image if screenshot does not exist
                'theme' => $folder
            ];
        }

        return response()->json($screenshotsAndThemes);
    }

}

if (!function_exists('currency_symbol')) {
    function currency_symbol()
    {
        $activeCurrency = Currencies::where('status', 'active')->first();
    
        if (!empty($activeCurrency)) {
            return $activeCurrency->symbol.' '; // Return the symbol of the active currency
        }
        return "$ "; // Default fallback symbol
    }
}


if(!function_exists('currency_converter'))
{
    function currency_converter($amount)
    {
        $activeCurrency = Currencies::where('status', 'active')->first();
        if(empty($activeCurrency))
        {
            return $amount;
        }

        $convertedCurrency = $amount * $activeCurrency->conversion_rate;
        return $convertedCurrency;

    }
}

if(!function_exists('getUserFooter'))
{
    function getUserFooter($subscriptionId)
    {
        if($subscriptionId)
        {
            $folderPath = public_path("user_ecommerce/{$subscriptionId}");
            $filePath = "{$folderPath}/footer.php";

            if(File::exists($filePath))
            {
                $content = File::get(public_path("user_ecommerce/{$subscriptionId}/footer.php"));
                if($content)
                {
                    return $content;
                }
            }
        }

        return false;
    }
}

if(!function_exists('getUserHeader'))
{
    function getUserHeader($subscriptionId)
    {
        if($subscriptionId)
        {
            $folderPath = public_path("user_ecommerce/{$subscriptionId}");
            $filePath = "{$folderPath}/header.php";

            if(File::exists($filePath))
            {
                $content = File::get(public_path("user_ecommerce/{$subscriptionId}/header.php"));
                if($content)
                {
                    return $content;
                }
            }
        }

        return false;
    }
}

if (!function_exists('getHtmlPages')) {
    function getHtmlPages($subscription, $pageName, $active = "default")
    {
        if (empty($subscription) || empty($pageName)) {
            return false; // Ensure valid input
        }

        $filePath = $folderPath = $defaultPath = $defaultHeader = $defaultFooter = null;
        
        
        if (is_numeric($subscription)) {
            \Log::info("Is Numberic");
            $folderPath = public_path("user_ecommerce/{$subscription}");
            $filePath = "{$folderPath}/{$pageName}.php";

            if(!File::exists($filePath))
            {
                $defaultPath = public_path("user_ecommerce/{$active}/{$pageName}.php");
                $defaultHeader = public_path("user_ecommerce/{$active}/header.php");
                $defaultFooter = public_path("user_ecommerce/{$active}/footer.php");
            }

        } else {
            \Log::info("Not Numeric");
            $defaultPath = public_path("user_ecommerce/{$subscription}/{$pageName}.php");
            $defaultHeader = public_path("user_ecommerce/{$subscription}/header.php");
            $defaultFooter = public_path("user_ecommerce/{$subscription}/footer.php");
        }
        $pathToUse = File::exists($filePath) ? $filePath : (File::exists($defaultPath) ? $defaultPath : false);
        
        \Log::info("File path being used: " . ($pathToUse ?: 'None'));

        if (!$pathToUse) {
            return false; // If no valid file path, exit
        }

        try {
            if ($pathToUse === $defaultPath) {
                $header = File::get($defaultHeader);
                $bodyContent = File::get($pathToUse);
                $footer = File::get($defaultFooter);
                $content = $header . $bodyContent . $footer;
            } else {
                $content = File::get($pathToUse);
            }
        } catch (\Exception $e) {
            \Log::error("Failed to read file content: " . $e->getMessage());
            return false;
        }

        // Replace asset placeholders
        $content = str_replace('__asset_url', asset('assets/ecommerce/'), $content);
        $content = str_replace('v2_assets_url__', asset('assets/v2_ecommerce'), $content);

        return $content;
    }


}
