<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Ecommerce\Products;

class ProductsController extends Controller
{
    public function getProducts(Request $request)
    {
        $user_id = $request->api_user_id;
        $products = Products::where('user_id', $user_id)->get();
        if($products->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No Product Found'], 200);
        }

        return response()->json(['result'=>true, 'products'=>$products]);

    }

    public function productsByCategories(Request $request)
    {
        $user_id = $request->api_user_id;
        $category_id = $request->category_id;
        $products = Products::where('category_id', $category_id)->where('user_id', $user_id)->get();
        if($products->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No product found'], 422);
        }

        return response()->json(['result'=>true, 'products'=>$products], 200, $headers);

    }

    
    public function featuredProducts(Request $request)
    {
        $user_id = $request->api_user_id;
        $products = Products::where('is_featured', 1)->where('user_id', $user_id)->get();
        if($products->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No product found'], 422);
        }

        return response()->json(['result'=>true, 'products'=>$products], 200);
    }

    public function latestProducts(Request $request)
    {
        $user_id = $request->api_user_id;
        $products = Products::where('is_latest', 1)->where('user_id', $user_id)->get();
        if($products->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No product found'], 422);
        }

        return response()->json(['result'=>true, 'products'=>$products], 200);
    }

    public function bestSellerProducts(Request $request)
    {
        $user_id = $request->api_user_id;
        $products = Products::where('isBestSeller', 1)->where('user_id', $user_id)->get();
        if($products->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No product found'], 422);
        }

        return response()->json(['result'=>true, 'products'=>$products], 200);
    }

    public function trendingProducts(Request $request)
    {
        $user_id = $request->api_user_id;
        $products = Products::where('is_trending', 1)->where('user_id', $user_id)->get();
        if($products->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No product found'], 422);
        }

        return response()->json(['result'=>true, 'products'=>$products], 200);
    }

    public function getProductById(Request $request)
    {
        $user_id = $request->api_user_id;
        $id = $request->product_id;
        $productInfo = Products::where('id', $id)->where('user_id', $user_id)->first();
        if(empty($productInfo))
        {
            return response()->json(['result'=>false, 'error'=>'Product Not Found'], 422);
        }

        return response()->json(['result'=>true, 'product'=>$productInfo], 200);
    }

    public function getProductBySlug(Request $request)
    {
        $user_id = $request->api_user_id;
        $slug = $request->slug;
        $productInfo = Products::where('slug', $slug)->where('user_id', $user_id)->first();
        if(empty($productInfo))
        {
            return response()->json(['result'=>false, 'error'=>'Product Not Found'], 422);
        }

        return response()->json(['result'=>true, 'product'=>$productInfo], 200);
    }


}
