<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use App\Models\Ecommerce\EcommerceProjects;
use Log;

class UiController extends Controller
{
    public function getTheme(Request $request)
    {
         $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;

        $theme = $subscriptionId;
        $theme = (int)$theme;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = $ecommerceSubscription->theme ?? "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
          
            $activeTheme = $theme;
        }
        
        $page = getHtmlPages($theme, 'homepage', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Product Detail page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['result'=>true, 'content'=>$page]);
    
    }

    
    function replaceDivContent($page, $newContent, $divId = "ecommerceHeader") {
        $dom = new \DOMDocument();
        libxml_use_internal_errors(true); // Prevent warnings from malformed HTML
        $dom->loadHTML(mb_convert_encoding($page, 'HTML-ENTITIES', 'UTF-8'), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD); // Load the HTML content
        libxml_clear_errors();

        // Use XPath to find the div by ID
        $xpath = new \DOMXPath($dom);
        $nodes = $xpath->query("//*[@id='{$divId}']");

        if ($nodes->length > 0) {
            $oldNode = $nodes[0]; // Get the target div

            // Create a temporary DOM to parse the new content
            $tempDom = new \DOMDocument();
            $tempDom->loadHTML(mb_convert_encoding($newContent, 'HTML-ENTITIES', 'UTF-8'));
            $newNode = $tempDom->getElementsByTagName('body')->item(0)->firstChild;

            if ($newNode) {
                $importedNode = $dom->importNode($newNode, true);
                $oldNode->parentNode->replaceChild($importedNode, $oldNode); // Replace the entire div
            }
        }

        return $dom->saveHTML(); // Convert DOM back to HTML and return
    }



    public function getProductPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        

        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        
        if($checkIfFolderExists)
        {
            $theme = $subscriptionId;
        }

        $page = getHtmlPages($theme, 'product_detail', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Product Detail page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['result'=>true, 'content'=>$page]);
    }

    public function getCartPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
       
        $theme = $subscriptionId;
       
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        $page = getHtmlPages($theme, 'cart', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Cart page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['result'=>true, 'content'=>$page]);
    }

    public function getCheckoutPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;

        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
          $theme = $subscriptionId;
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        
        $page = getHtmlPages($theme, 'checkout', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Checkout page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['result'=>true, 'content'=>$page]);
    }

    public function getThankYouPage(Request $request)
    {
         $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;

          $theme = $subscriptionId;

        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        if(!$checkIfFolderExists)
        {
            $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
            if(!empty($ecommerceSubscription)){
                $theme = $ecommerceSubscription->theme;
            }else{
                $theme = "default";
            }
        }


        $page = getHtmlPages($theme, 'thankyou');
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Login page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['result'=>true, 'content'=>$page]);
    }

    public function getProductsPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;

        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }

        if($checkIfFolderExists)
        {
            $theme = $subscriptionId;
        }

        
        $page = getHtmlPages($theme, 'products', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Products page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

        $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function searchPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }

        if($checkIfFolderExists)
        {
            $theme = $subscriptionId;
        }

        

        $page = getHtmlPages($theme, 'search', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Register page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function getRegisterPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }

        if($checkIfFolderExists)
        {
            $theme = $subscriptionId;
        }        

        $page = getHtmlPages($theme, 'register', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Register page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function getPrivacyPolicy(Request $request)
    {
         $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'privacy-policy', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Privacy Policy page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function getDashboard(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        $page = getHtmlPages($theme, 'user_dashboard', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'User Dashboard Page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function getEditProfile(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'user_edit_profile', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'User Dashboard Page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);

    }

    public function getProfile(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'user_profile', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'User Dashboard Page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function getWishlistPage(Request $request)
    {
         $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }

        

        $page = getHtmlPages($theme, 'wishlist', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Contact uspage not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function getLoginPage(Request $request)
    {
         $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
       
        $theme = $subscriptionId;
       
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('ecommerce_subscription_id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        $page = getHtmlPages($theme, 'login', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Cart page not found'],422);
        }

        $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['result'=>true, 'content'=>$page]);

    }

    public function termsAndConditions(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'terms-and-conditions', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Terms And Conditions    page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function contactUs(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'contact-us', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Contact uspage not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function aboutUs(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'about-us', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Terms And Conditions    page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }

    public function faqs(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'faqs', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Terms And Conditions    page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }


    public function getOrderDetailPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'orders_details', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Terms And Conditions    page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }


    public function getOrdersPage(Request $request)
    {
        $user_id = $request->api_user_id;
        $api_key = $request->api_key;
        $subscriptionId = $request->ecommerce_subscription_id;
        
        $theme = $subscriptionId;
        $checkIfFolderExists = File::exists(public_path('user_ecommerce/'.$subscriptionId));
        $ecommerceSubscription = EcommerceProjects::where('id', $subscriptionId)->first();
        if(!$checkIfFolderExists)
        {
            $theme = "default";
        }
        $activeTheme = "default";
        if(!empty($ecommerceSubscription)){
            $theme = $ecommerceSubscription->theme;
            $activeTheme = $theme;
        }
        

        $page = getHtmlPages($theme, 'orders', $activeTheme);
        if(!$page)
        {
             return response()->json(['result'=>false, 'error'=>'Terms And Conditions    page not found'],422);
        }

         $header = getUserHeader($subscriptionId);
        
        if($header)
        {
            $page = $this->replaceDivContent($page, $header);
        }

         $footer = getUserFooter($subscriptionId);
        if($footer)
        {
            $page = $this->replaceDivContent($page, $footer, 'footerSection');
        }

        return response()->json(['hit'=>true, 'result'=>true, 'content'=>$page]);
    }
    

}


