<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;
use DB;
use App\Models\Language;
use App\Models\Seo;
use Session;
class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        
        return view('auth.login');
    }


    public function showLoginForm2($id)
    {
        
        
      session()->put('pid', $id);  
      if (session()->has('lang')) {
            $currentLang = Language::where('code', session()->get('lang'))->first();
        } else {
            $currentLang = Language::where('is_default', 1)->first();
        }
        $data['seo'] = Seo::where('language_id', $currentLang->id)->first();
        return view('front.login', $data);
      
    }

    public function login(Request $request)
    {
        // Validation rules
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
    
        // Attempt to log the user in
        if (Auth::guard('web')->attempt(['email' => $request->email, 'password' => $request->password])) {
            // Redirect to the "services" page upon successful login
            return redirect()->route('services');
        }
    
        // Redirect back with error message if login fails
        return back()->with('err', __("Credentials don't match!"))->withInput();
    }

    public function store(LoginRequest $request): RedirectResponse
    {
        
        $request->authenticate();
        $request->session()->regenerate();

        if(Auth::user()->role == 2)
        {
             return redirect('/dashboard');
        }
        return redirect()->intended('service');
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
       
        Auth::logout();
       
        return redirect('/');
    }
}
