<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\View\View;
use Illuminate\Support\Facades\Validator;


class PasswordResetLinkController extends Controller
{
    /**
     * Display the password reset link request view.
     */
    public function create(): View
    {
        return view('auth.forgot-password');
    }



    public function store(Request $request)
    {
        // Validate the email
        $validator = Validator::make($request->all(), [
            'email' => ['required', 'email', 'exists:users,email'], // Check if the email exists in the users table
        ]);

        if ($validator->fails()) {
            $errorMessages = $validator->errors()->all();
            return response()->json(['errors' => $errorMessages], 422);
        }

        // Send the password reset link
        $status = Password::sendResetLink(
            $request->only('email')
        );

        if ($status === Password::RESET_LINK_SENT) {
            return response()->json(['message' => __($status)], 200);
        } else {
            return response()->json(['message' => __($status)], 500);
        }
    }

}
