<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;
use App\Models\Seo;
use App\Models\Package;
use App\Models\Cart;
use App\Models\Language;
use App\Models\BasicSetting;
use App\Models\BasicExtended;
use App\Models\PaymentGateway;
use App\Models\BasicSetting as BS;
use App\Models\BasicExtended as BE;
use App\Models\User\Language as UserLanguage;
use App\Models\OfflineGateway;
use App\Models\UserDomain;
use App\Models\UserBillingAddress;
use App\Models\UserSsl;
use Illuminate\Support\Facades\Session;
use DB;
use App\Models\Bcategory;
use App\Models\Blog;
use App\Models\User;
use Carbon\Carbon;
use App\Models\User\UserPermission;



class FrontController extends Controller
{
 public function cart(Request $request) {
        if (session()->has('lang')) {
            $currentLang = Language::where('code', session()->get('lang'))->first();
        } else {
            $currentLang = Language::where('is_default', 1)->first();
        }
        $data['seo'] = Seo::where('language_id', $currentLang->id)->first();

        $terms = [];
        if (Package::query()->where('status', '1')->where('term', 'monthly')->count() > 0) {
            $terms[] = 'Monthly';
        }
        if (Package::query()->where('status', '1')->where('term', 'yearly')->count() > 0) {
            $terms[] = 'Yearly';
        }
        if (Package::query()->where('status', '1')->where('term', 'lifetime')->count() > 0) {
            $terms[] = 'Lifetime';
        }
        $data['terms'] = $terms;

        $be = BasicExtended::select('package_features')->firstOrFail();
        $allPfeatures = $be->package_features ? $be->package_features : "[]";
        $data['allPfeatures'] = json_decode($allPfeatures, true);
  
        $online = PaymentGateway::query()->where('status', 1)->get();
        $offline = OfflineGateway::where('status', 1)->get();
        $data['offline'] = $offline;
        $data['payment_methods'] = $online->merge($offline);
        
        $addonidsar = array();
        $pkg_list = array();
        $data['package_item'] = "";
        $data['package_name'] = "";
        $data['package_amount'] = 0;
        $data['addons_amount'] = 0;
        $data['domains_amount'] = 0;
        $data['ssls_amount'] = 0;
        $data['myplan']="";
        $data['newdomain']="";
      
        $data['plan'] = 0;
     
        $item = DB::table('carts')->where('user_id', Auth::id())->where('type', NULL)->get();
        $iteem = DB::table('carts')->where('user_id', Auth::id())->where('type', 1)->get();
        
        //dd($item,$iteem);
        
        foreach($iteem as $itee){
              array_push($addonidsar, $itee->item_id);
              $padd = DB::table('package_addons')->find($itee->item_id);
              $padto = 0;
              $quantity = 1;
              if(isset($padd->id)){
                  if($padd->term == 'monthly' || $padd->term == 'yearly'){
                      $quantity = $itee->cycle;
                  }
                  $padto = $padd->price * $quantity;
              }
              $data['addons_amount'] += $padto;
        }
        
        $data['item'] = $item;
        $data['addonids'] = $addonidsar;
      
        $data['count'] = count($item);
        
        foreach($item as $ite){
          if($ite->plan !=  NULL){
               $data['plan'] = '1';
               $data['myplan'] = $ite->plan;  
          } 
          $pkg = DB::table('blogs')->where('id', $ite->item_id)->first();
          if($pkg){
              $data['package_item'] = $pkg->id;
              $data['package_name'] = $pkg->title;
          }  
        }
        
        $domains = UserDomain::where('user_id',Auth::id())->where('is_paid',0)->get();
        foreach($domains as $dmn){
            $data['domains_amount'] += $dmn->price;
            $data['newdomain'] = $dmn->name;
        }
        $data['domains'] = $domains;
        
        $data['addresses'] = UserBillingAddress::where('user_id',Auth::id())->get();
        
        $data['ssls'] = $this->suggestedssls();
        
        foreach($data['ssls'] as $sslitm){
            if($sslitm['CartId'] && $sslitm['CartId']>0){
                $data['ssls_amount'] += $sslitm['Cost'];
            }
        }
        
        $data['package_type'] = "";
        $data['package_term'] = "";
        $data['v'] = "";
        if($data['myplan'] != ''){
            $ite = DB::table('packages')->where('id', $data['myplan'] )->first(); 
            $data['package_type'] = $ite->package_type;
            $data['package_amount'] = $ite->price;
            $data['package_term'] = $ite->term;
            $data['v'] =  $ite->term;
        }
        $data['package_addons'] = DB::table('package_addons')->where('isdelete', NULL)
                ->where(function($q) use ($data) {
                          $q->where('package_type',$data['package_type'])
                            ->orWhere('package_type', 'all');
                      })
                ->get();
        $data['selected_addons'] = DB::table('package_addons')->whereIn('id', $addonidsar)->get();
        if(count($data['selected_addons'])){
            foreach($data['selected_addons'] as $add){
                $crt = DB::table('carts')->where('user_id', Auth::id())->where('item_id', $add->id)->where('type', 1)->first();
                if(isset($crt->id)){
                    $add->quantity = 1;
                    if($add->term == 'monthly' || $add->term == 'yearly'){
                      $add->quantity = $crt->cycle;
                    }
                }
            }
        } 
        
        $data['total_amount'] = $data['package_amount'] + $data['addons_amount'] + $data['domains_amount'] + $data['ssls_amount'];
        if ($request->has('step')) {
           $data['plan'] = 2;
        }
        //dd($data);
        return view('front.cart', $data);
    }
    
     public function welcome()
    {
  
       $data = array();
 
        return view('welcome', $data);
    }
    
public function getcsrf(){
//echo    csrf_token();
    
}  


public function pages($id){
 
    $pages = DB::table('project_pages')->where('pid',$id)->get();
	$array = array();$c=0;
    foreach($pages as $page){
        $array[$c]['page'] = $page->page;
        $array[$c]['slug'] = $page->slug;
        $c++;
    }
    return response()->json($array);
}
public function pagesections(){
 
    $pages = DB::table('sections')->get();
	$array = array();$c=0;
foreach($pages as $page){
	$array[$c]['name'] = $page->name;
	$array[$c]['idd'] = $page->idd;
	$c++;
}

return response()->json($array);


} 
  public function pricing(Request $request)
    {
        return view('homepage.index');     
    }
 
     
    private function suggestedssls() {
        $ssls = [];
        if(env('NAMECHEAP_API') == 'sandbox'){
            $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&Command=namecheap.users.getPricing&ProductType=SSLCERTIFICATE&ActionName=PURCHASE&ProductCategory=COMODO';
        }else{
            $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&Command=namecheap.users.getPricing&ProductType=SSLCERTIFICATE&ActionName=PURCHASE&ProductCategory=COMODO';
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $myXMLData = curl_exec($ch);
        curl_close($ch);  
        
        $array =  json_decode(json_encode((array)simplexml_load_string($myXMLData)),true);
        if(isset($array['@attributes'])){
            $status = $array['@attributes'];
            $resdata = $array['CommandResponse']['UserGetPricingResult']['ProductType']['ProductCategory']['Product'];
            if($status['Status'] == 'OK' && is_array($resdata)){
                $only = ['essentialssl','instantssl','positivessl'];
                // $only = ['essentialssl','instantssl','positivessl','premiumssl','comodossl'];
                foreach($resdata as $res){
                    $name = $res['@attributes']['Name'];
                    if (in_array($name, $only)){
                        $prices = $res['Price'];
                        foreach($prices as $price){
                            $arr = $price['@attributes'];
                            if($arr['Duration'] == 1){
                                $sslname  = strtoupper($name);
                                $arr['Name'] = $sslname;
                                $inr = $arr['YourPrice'] * env('USD_TO_INR');
                                $arr['Cost'] = round($inr,2);
                                $regularInr = $arr['RegularPrice'] * env('USD_TO_INR');
                                $arr['RegularCost'] = round($regularInr,2);
                                
                                $cartssl = UserSsl::where('user_id',Auth::id())->where('name',$sslname)->where('is_paid',0)->first();
                                if(isset($cartssl->id)){
                                    $arr['CartId'] = $cartssl->id;
                                }else{
                                    $arr['CartId'] = '';
                                }
                                array_push($ssls,$arr);
                            }
                        }
                    }
                }
            }
        }
        return $ssls;
    }
     public function registrationspricing($id)
    {
        session()->put('pricing', $id);
        if(!Session::has('product')){
            return redirect('services');
        }
        return redirect('registrationstopurchase/'.$id);
    }   
       public function blogs(Request $request)
    {
        if (session()->has('lang')) {
            $currentLang = Language::where('code', session()->get('lang'))->first();
        } else {
            $currentLang = Language::where('is_default', 1)->first();
        }
        $data['seo'] = Seo::where('language_id', $currentLang->id)->first();

        $data['currentLang'] = $currentLang;

        $lang_id = $currentLang->id;

        $category = $request->category;
        if (!empty($category)) {
            $data['category'] = Bcategory::findOrFail($category);
        }
        $term = $request->term;

        $data['bcats'] = Bcategory::where('language_id', $lang_id)->where('status', 1)->orderBy('serial_number', 'ASC')->get();


        $data['blogs'] = Blog::when($category, function ($query, $category) {
            return $query->where('bcategory_id', $category);
        })
            ->when($term, function ($query, $term) {
                return $query->where('title', 'like', '%' . $term . '%');
            })
            ->when($currentLang, function ($query, $currentLang) {
                return $query->where('language_id', $currentLang->id);
            })->where('isdelete', NULL)->orderBy('serial_number', 'ASC')->paginate(3);
        return view('front.blogs', $data);
    }
      public function registrationsproduct($id)
    {
        session()->put('product', $id);
        if(!Session::has('pricing')){
            return redirect('pricing');
        }
        return redirect('registrationstopurchase/'.$id);
    }
     public function registrations2($id)
    {   
        if(Session::has('pricing') && Session::has('product')){
            $data = [];
            $data['id'] = session()->get('product');
            return view('front.registrations', $data);
            
        }else if(Session::has('pricing') && !Session::has('product')){
            return redirect('services');
            
        }else if(!Session::has('pricing') && Session::has('product')){
            return redirect('pricing');
            
        } 
    }
     public function registrationsprocess(Request $request)
    {   
        $productId = session()->get('product');
        $pricingId = session()->get('pricing');
        $this->validate($request, [
            'username' => 'required|alpha_num|unique:users',
             'phone' => 'required|alpha_num|unique:users',
          //  'email' => 'required|email|unique:users',
            'password' => 'required|min:8|confirmed'
        ]); 
     
        if($request['email'] == ''){
             $request['email'] = $request['username']."@goafli.in";
        }
        $code = '+91';
        if($request->has('code')){
            $code = $request['code'];
        }
        $request['email_verified'] = 1;
      
        $token = md5(time() . $request['username'] . $request['email']);
        $verification_link = "<a href='" . url('register/mode/'.$request['mode'].'/verify/' . $token) . "'>" . "<button type=\"button\" class=\"btn btn-primary\">Click Here</button>" . "</a>";
        $user = User::create([
           'first_name' => $request['first_name'],
            'last_name' => $request['last_name'],
            'email' => $request['email'],
            'refid' => $request['refid'],
            'code' => $code,
            'phone' => $request['phone'],
            'username' => $request['username'],
            'password' => bcrypt($request['password']),
            'status' => '1',
            'email_verified' => '1',
            'verification_link' => $token,
            //     'address' => $request["address"] ? $request["address"] : null,
            //     'city' => $request["city"] ? $request["city"] : null,
            //      'state' => $request["district"] ? $request["district"] : null,
            //       'country' => $request["country"] ? $request["country"] : null,
            //     'verification_link' => $token,
        ]);
            
        if(!$user){
            Session::flash('error', 'Unable to create your account!');
            return back();
        }   
        
        Auth::loginUsingId($user->id);            
            
         /*   
        $mailer = new MegaMailer();
            $data = [
                'toMail' => $user->email,
                'toName' => $user->first_name,
                'customer_name' => $user->first_name,
                'verification_link' => $verification_link,
                'website_title' => '',
                'templateType' => 'email_verification',
                'type' => 'emailVerification'
            ];
            $mailer->mailFromAdmin($data);
            */
            //   $package = Package::findOrFail($request['package_id']);
            $package = Package::findOrFail($pricingId);
            //      $package = 13;
            $startDate = Carbon::today()->format('Y-m-d');
            if ($package->term === "monthly") {
                $endDate = Carbon::today()->addMonth()->format('Y-m-d');
            } elseif ($package->term === "yearly") {
                $endDate = Carbon::today()->addYear()->format('Y-m-d');
            } elseif ($package->term === "lifetime") {
                $endDate = Carbon::maxValue()->format('d-m-Y');
            }

            // Membership::create([
            //     'package_price' => $package->price,
            //     'discount' => session()->has('coupon_amount') ? session()->get('coupon_amount') : 0,
            //     'coupon_code' => session()->has('coupon') ? session()->get('coupon') : NULL,
            //     'price' => 1,
            //     'currency' => "USD",
            //     'currency_symbol' => '',
            //     'payment_method' => '',
            //     'transaction_id' => '',
            //     'status' => $request["status"] ? $request["status"] : 0,
            //     'is_trial' => $request["package_type"] == "regular" ? 0 : 1,
            //     'trial_days' => '14',
            //     'receipt' => '',
            //     'transaction_details' => '',
            //     'settings' => '',
            //     'package_id' => $productId,
            //     'user_id' => $user->id,
            //     'start_date' => Carbon::parse($startDate),
            //     'expire_date' =>  Carbon::parse($endDate),
            // ]);
            
            $features = json_decode($package->features, true);
            $features[] = "Contact";
            UserPermission::create([
                'package_id' => $productId,
                'user_id' => $user->id,
                'permissions' => json_encode($features)
            ]);   
            
            Cart::create([
                'user_id' => $user->id,
                'item_id' => $productId,
                'plan' => $pricingId,
                'status' => 0,
            ]);
            
            session()->forget('product');
            session()->forget('pricing');
            
            Session::flash('success', 'Your account has been created successfully!');
            return redirect()->route('user.plan.cart');
    }
}
