<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;
use App\Models\Seo;
use App\Models\Package;
use App\Models\Cart;
use App\Models\BasicSetting;
use App\Models\BasicExtended;
use App\Models\PaymentGateway;
use App\Models\BasicSetting as BS;
use App\Models\BasicExtended as BE;
use App\Models\User\Language as UserLanguage;
use App\Models\OfflineGateway;
use App\Models\UserDomain;
use App\Models\UserBillingAddress;
use App\Models\UserSsl;
use Illuminate\Support\Facades\Session;
use DB;
use App\Models\User\Language;
use App\Models\User\UserService;
use App\Models\User;
use App\Models\UserSubscriptions;
use App\Models\Ecommerce\UserEcommerceSubscriptions;
use App\Models\Cgi\CgiOrders;

class ServicesController extends Controller
{
 
  /**
     * Display a listing of the resource.
     *
     * @return
     */
    public function index(Request $request)
    {
        $data = null;
        if ($request->has('language')) {
            
            Session::put('currentLangCode','en');
        } else {
            
            Session::put('currentLangCode', 'en');
        }

        $data['services'] = UserService::where([
            ['lang_id', '=', 176],
            ['user_id', '=', Auth::id()],
        ])
            ->orderBy('id', 'DESC')
            ->get();
        return view('user.service.index', $data);
    }
    
    
    public function domains(Request $request)
    {
        $data = [];
        $data['domains'] = UserDomain::where('user_id',Auth::id())->get();
        
        return view('user.service.domains', $data);
    }
    
    public function removedomaincart($id){
        $domain = UserDomain::where('id',$id)->where('user_id',Auth::id())->first();
        $domain->delete();
        Session::flash('success', 'Domain has been deleted successfully!');
        return back();
    }
    
    public function domainmanage($domain){
        $data = [];
        $EmailType = '';
        $IsUsingOurDNS = '';
        $IsPremiumDNS = '';
        $IsUsingFreeDNS = '';
        $host_records = [];
        $nameservers = [];
        $pos = strpos($domain, '.');
        $sld = substr($domain, 0, $pos);
        $tld = pathinfo($domain, PATHINFO_EXTENSION); 
        
        if(env('NAMECHEAP_API') == 'sandbox'){
            $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.domains.dns.getHosts&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld;
        }else{
            $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.domains.dns.getHosts&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld;
        }
        //dd($url);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $myXMLData = curl_exec($ch);
        curl_close($ch);  
        
        $array =  json_decode(json_encode((array)simplexml_load_string($myXMLData)),true);
        if(isset($array['@attributes'])){
            $status = $array['@attributes'];
            $attributes = $array['CommandResponse']['DomainDNSGetHostsResult']['@attributes'];
            if($status['Status'] == 'OK' && is_array($attributes)){
                $EmailType = $attributes['EmailType'];
                $IsUsingOurDNS = $attributes['IsUsingOurDNS'];
            }
            $hosts = $array['CommandResponse']['DomainDNSGetHostsResult']['host'];
            if($status['Status'] == 'OK' && is_array($hosts) && count($hosts)){
                foreach($hosts as $host){
                    array_push($host_records,$host['@attributes']);
                }
                //dd($status,$hosts,$host_records);
            }
        }
        $data['EmailType '] = $EmailType;
        $data['IsUsingOurDNS '] = $IsUsingOurDNS;
        $data['domain_name'] = $domain;
        $data['host_records'] = $host_records;
        
        // if(env('NAMECHEAP_API') == 'sandbox'){
        //     $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.domains.dns.getList&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld;
        // }else{
        //     $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.domains.dns.getList&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld;
        // }
        
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // $myXMLData = curl_exec($ch);
        // curl_close($ch); 
        
        // $array =  json_decode(json_encode((array)simplexml_load_string($myXMLData)),true);
        // if(isset($array['@attributes'])){
        //     $status = $array['@attributes'];
        //     $attributes = $array['CommandResponse']['DomainDNSGetListResult']['@attributes'];
        //     if($status['Status'] == 'OK' && is_array($attributes)){
        //         $IsPremiumDNS = $attributes['IsPremiumDNS'];
        //         $IsUsingFreeDNS = $attributes['IsUsingFreeDNS'];
        //     }
        //     $nameserver = $array['CommandResponse']['DomainDNSGetListResult']['Nameserver'];
        //     if($status['Status'] == 'OK' && is_array($nameserver) && count($nameserver)){
        //         $nameservers = $nameserver;
        //     }
        // }
        // $data['IsPremiumDNS '] = $IsPremiumDNS;
        // $data['IsUsingFreeDNS '] = $IsUsingFreeDNS;
        // $data['nameservers '] = $nameservers;
        
        // if(env('NAMECHEAP_API') == 'sandbox'){
        //     $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.domains.ns.getInfo&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld.'&Nameserver=ns1.'.$sld.'.'.$tld;
        // }else{
        //     $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.domains.ns.getInfo&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld.'&Nameserver=ns1.'.$sld.'.'.$tld;
        // }
        
        //dd($data);
        return view('user.service.manage-domain', $data);
    }
    
    public function updatehostrecords(Request $request)
    {
        $pos = strpos($request->domain, '.');
        $sld = substr($request->domain, 0, $pos);
        $tld = pathinfo($request->domain, PATHINFO_EXTENSION); 
        
        if(env('NAMECHEAP_API') == 'sandbox'){
            $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.domains.dns.setHosts&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld.$request->records;
        }else{
            $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.domains.dns.setHosts&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&SLD='.$sld.'&TLD='.$tld.$request->records;
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $myXMLData = curl_exec($ch);
        curl_close($ch);  
        dd($myXMLData);
        $array =  json_decode(json_encode((array)simplexml_load_string($myXMLData)),true);
        //dd($array);
        if(isset($array['@attributes'])){
            $status = $array['@attributes'];
            $res = $array['CommandResponse']['DomainDNSSetHostsResult']['@attributes'];
            if($status['Status'] == 'OK' && $res && is_array($res)){
                if($res['IsSuccess'] == 'true'){
                    Session::flash('success', 'Domain records updatrd successfully!');
                    return back();
                }
            }
        }
        Session::flash('warning', 'Domain records updatrd successfully!');
        return back();
        //dd($url);
    }
    
    public function ssls(Request $request)
    {
        $data = [];
        $data['ssls'] = UserSsl::where('user_id',Auth::id())->get();
        
        return view('user.service.ssls', $data);
    }
    
    public function sslactivate(Request $request,$id)
    {
        $data = [];
        $data['info'] = UserSsl::where('user_id',Auth::id())->where('certificateID',$id)->first();
     
        
        return view('user.service.ssl-activate', $data);
    }
    
    public function sslactivaterequest(Request $request,$id)
    {
        $password = substr(md5(mt_rand()), 0, 12);
        
        $data = [];
        
        $subject = array(
            "commonName" => $request->commonName,
            "organizationName" => $request->organizationName,
            "organizationalUnitName" => $request->organizationalUnitName,
            "localityName" => $request->localityName,
            "stateOrProvinceName" => $request->stateOrProvinceName,
            "countryName" => 'IN',
            "emailAddress" => $request->emailAddress
        );
         
        // Generate a new private (and public) key pair
        $private_key = openssl_pkey_new( array('private_key_type'=>OPENSSL_KEYTYPE_RSA,'private_key_bits'=>2048) );
        $csr_resource = openssl_csr_new($subject, $private_key, array('digest_alg'=>'sha256') );
         
        openssl_csr_export($csr_resource, $csr_string);
        openssl_pkey_export($private_key, $private_key_string, $password);
        
        $ssl = UserSsl::where('user_id',Auth::id())->where('certificateID',$id)->first();
        $ssl->update([
            'status' => 1,
            'dns_names' => $request->dnsNames,
            'csr_string' => $csr_string,
            'private_key' => $private_key_string,
            'private_key_pass' => $password,
        ]);
        $csr_string = urlencode(trim(str_replace("\n","",$csr_string)));
        // echo $csr_string;
        // echo '<br>';
        // echo $private_key_string;
        
        //dd(trim(str_replace("\n","",$csr_string)));
        
        // if(env('NAMECHEAP_API') == 'sandbox'){
        //     $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.ssl.editdcvmethod&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&CertificateID='.$id.'&DCVMethod='.$request->emailAddress;
        // }else{
        //     $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.ssl.editdcvmethod&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&CertificateID='.$id.'&DCVMethod='.$request->emailAddress;
        // }
        
        // if(env('NAMECHEAP_API') == 'sandbox'){
        //     $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.ssl.resendfulfillmentemail&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&CertificateID='.$id;
        // }else{
        //     $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.ssl.resendfulfillmentemail&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&CertificateID='.$id;
        // }
        
        // if(env('NAMECHEAP_API') == 'sandbox'){
        //     $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.ssl.getApproverEmailList&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&domainname=goafli.io&CertificateType=PositiveSSL';
        // }else{
        //     $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.ssl.getApproverEmailList&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&domainname=goafli.io&CertificateType=PositiveSSL';
        // }
        
        // if(env('NAMECHEAP_API') == 'sandbox'){
        //     $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.ssl.reissue&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&certificateID='.$id.'&CSR='.$csr_string.'&AdminEmailAddress=dev.giridhari@gmail.com&WebServerType=apacheopenssl&ApproverEmail=dev.giridhari@gmail.com&DNSNames='.$request->dnsNames.'&DNSApproverEmails=dev.giridhari@gmail.com';
        // }else{
        //     $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.ssl.reissue&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&certificateID='.$id.'&CSR='.$csr_string.'&AdminEmailAddress=dev.giridhari@gmail.com&WebServerType=apacheopenssl&ApproverEmail=dev.giridhari@gmail.com&DNSNames='.$request->dnsNames.'&DNSApproverEmails=dev.giridhari@gmail.com';
        // }
        
        if(env('NAMECHEAP_API') == 'sandbox'){
            $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.ssl.activate&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&certificateID='.$id.'&CSR='.$csr_string.'&AdminEmailAddress='.$request->emailAddress.'&WebServerType=apacheopenssl&ApproverEmail='.$request->emailAddress.'&DNSNames='.$request->dnsNames.'&DNSApproverEmails='.$request->emailAddress;
        }else{
            $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.ssl.activate&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&certificateID='.$id.'&CSR='.$csr_string.'&AdminEmailAddress='.$request->emailAddress.'&WebServerType=apacheopenssl&ApproverEmail='.$request->emailAddress.'&DNSNames='.$request->dnsNames.'&DNSApproverEmails='.$request->emailAddress;
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $myXMLData = curl_exec($ch);
        curl_close($ch);  
        
        $array =  json_decode(json_encode((array)simplexml_load_string($myXMLData)),true);
        
        dd($myXMLData,$array,$url);
        //return view('user.service.ssl-activate', $data);
    }
    
    public function sslview(Request $request,$id)
    {
        $data = [];
        $ssl = UserSsl::where('user_id',Auth::id())->where('certificateID',$id)->first();
        if(isset($ssl->id)){
            if(env('NAMECHEAP_API') == 'sandbox'){
                $url = 'https://api.sandbox.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_SANDBOX_API_USER').'&ApiKey='.env('NAMECHEAP_SANDBOX_API_KEY').'&UserName='.env('NAMECHEAP_SANDBOX_API_USER').'&Command=namecheap.ssl.getinfo&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&certificateID='.$id.'&Returncertificate=true&Returntype=individual';
            }else{
                $url = 'https://api.namecheap.com/xml.response?ApiUser='.env('NAMECHEAP_LIVE_API_USER').'&ApiKey='.env('NAMECHEAP_LIVE_API_KEY').'&UserName='.env('NAMECHEAP_LIVE_API_USER').'&Command=namecheap.ssl.getinfo&ClientIp='.env('NAMECHEAP_CLIENT_IP').'&certificateID='.$id.'&Returncertificate=true&Returntype=individual';
            }
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $myXMLData = curl_exec($ch);
            curl_close($ch);  
            
            $array =  json_decode(json_encode((array)simplexml_load_string($myXMLData)),true);
            dd($array);
        }
        //$data['ssls'] = UserSsl::where('user_id',Auth::id())->get();
        dd($id,$ssl);
        return view('user.service.ssls', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return
     */
    public function store(Request $request)
    {
        $img = $request->file('image');
        $allowedExts = array('jpg', 'png', 'jpeg');
        $messages = [
            'name.required' => 'The title field is required',
            'user_language_id.required' => 'The Language field is required',
            'serial_number.required' => 'The serial number field is required',
            'image.required' => 'The image field is required',
            'detail_page.required' => 'The detail page field is required',
        ];


        $rules = [
            'name' => 'required|max:255',
            'user_language_id' => 'required',
            'detail_page' => 'required',
            'serial_number' => 'required|integer',
            'image' => [
                'required',
                function ($attribute, $value, $fail) use ($img, $allowedExts) {
                    if (!empty($img)) {
                        $ext = $img->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail("Only png, jpg, jpeg image is allowed");
                        }
                    }
                },
            ],
        ];

        $userBs = BasicSetting::where('user_id', Auth::guard('web')->id())->select('theme')->first();
        if ($userBs->theme == 'home_seven') {
            $rules['icon'] = 'required';
        }

        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            $errmsgs = $validator->getMessageBag()->add('error', 'true');
            return response()->json($validator->errors());
        }
        if (!isset($request->featured)) $request["featured"] = "0";
        $input = $request->all();
        $slug = make_slug($request->name);
        $input['slug'] = $slug;
        $input['user_id'] = Auth::id();
        $input['lang_id'] = $request->user_language_id;
        $input['icon'] = $request->icon;

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $img->getClientOriginalExtension();
            $directory = 'assets/front/img/user/services/';
            if (!file_exists($directory)) mkdir($directory, 0775, true);
            $request->file('image')->move($directory, $filename);
            $input['image'] = $filename;
        }
        $input['content'] = Purifier::clean($request->content);
        $blog = new UserService();
        $blog->create($input);

        Session::flash('success', 'Service added successfully!');
        return "success";
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return
     */
    public function edit($id)
    {
        $data['service'] = UserService::where('user_id', Auth::user()->id)->where('id', $id)->firstOrFail();
        return view('user.service.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $img = $request->file('image');
        $allowedExts = array('jpg', 'png', 'jpeg');

        $messages = [
            'name.required' => 'The title field is required',
            'serial_number.required' => 'The serial number field is required',
            'image.required' => 'The image field is required',
            'detail_page.required' => 'The detail page field is required',
        ];

        $rules = [
            'name' => 'required|max:255',
            'detail_page' => 'required',
            'serial_number' => 'required|integer',
            'image' => [
                function ($attribute, $value, $fail) use ($img, $allowedExts) {
                    if (!empty($img)) {
                        $ext = $img->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail("Only png, jpg, jpeg image is allowed");
                        }
                    }
                },
            ],
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            $errmsgs = $validator->getMessageBag()->add('error', 'true');
            return response()->json($validator->errors());
        }
        if (!isset($request->featured)) $request["featured"] = "0";
        $service = UserService::where('user_id', Auth::user()->id)->where('id', $request->id)->firstOrFail();
        $input = $request->all();
        $slug = make_slug($request->name);
        $input['slug'] = $slug;
        $input['user_id'] = Auth::id();
        $input['icon'] = $request->icon;

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $img->getClientOriginalExtension();
            $request->file('image')->move('assets/front/img/user/services/', $filename);
            if (file_exists('assets/front/img/user/services/' . $service->image)) {
                @unlink('assets/front/img/user/services/' . $service->image);
            }

            $input['image'] = $filename;
        }
        $input['content'] = Purifier::clean($request->content);
        $service->update($input);
        Session::flash('success', 'Service updated successfully!');
        return "success";
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $service = UserService::where('user_id', Auth::user()->id)->where('id', $request->id)->firstOrFail();
        if (file_exists('assets/front/img/user/services/' . $service->image)) {
            @unlink('assets/front/img/user/services/' . $service->image);
        }
        $service->delete();
        Session::flash('success', 'Service deleted successfully!');
        return back();
    }

    public function bulkDelete(Request $request)
    {
        $ids = $request->ids;
        foreach ($ids as $id) {
            $service = UserService::where('user_id', Auth::user()->id)->where('id', $id)->firstOrFail();
            if (file_exists('assets/front/img/user/services/' . $service->image)) {
                @unlink('assets/front/img/user/services/' . $service->image);
            }
            $service->delete();
        }
        Session::flash('success', 'Service deleted successfully!');
        return "success";
    }
    
    public function services()
    {
        if (Auth::check()) {
            $wallet_balance = Auth::user()->walletbalance;
            $user_subscriptions_count = UserSubscriptions::where('user_id', Auth::user()->id)
                ->where('expires_on', '>', now())
                ->count();
            $user_ecommerce_count = UserEcommerceSubscriptions::where('user_id', Auth::user()->id)
                ->where('expires_on', '>', now())
                ->count();
            $cgiOrders = CgiOrders::where('user_id', Auth::user()->id)->count();

        } else {
            $wallet_balance = 0;
            $user_subscriptions_count = 0; // Missing in your original code
            $user_ecommerce_count = 0; // Fixed duplicate assignment
            $cgiOrders = 0;
        }

        return view('services.services', compact('wallet_balance', 'user_subscriptions_count', 'user_ecommerce_count', 'cgiOrders'));
    }

}
