<?php

namespace App\Http\Middleware;

use Closure;
use Auth;
use App\Models\User;

class ModifyAdminLteConfig
{
    public function handle($request, Closure $next)
    {
        // Retrieve the authenticated user's role from the request
        $userRole = $request->user() ? $request->user()->role : null;

        // Modify the AdminLTE configuration based on the user's role
        config([
            'adminlte.menu' => $this->customizeMenu($userRole),
            // Add other configuration modifications here if needed
        ]);

        return $next($request);
    }

    protected function customizeMenu($userRole)
    {
         
        
$role = 1;
        

        $adminMenu = [
            // Navbar items
            [
                'type' => 'navbar-search',
                'text' => 'search',
                'topnav_right' => true,
            ],
            [
                'type' => 'fullscreen-widget',
                'topnav_right' => true,
            ],

            // Sidebar items
            [
                'type' => 'sidebar-menu-search',
                'text' => 'search',
            ],
               
            
			[
                'text' => 'Projects',
                'icon' => 'nav-icon fas fa-user',
                'url'=>'projects/list'
            ], 
[
                'text' => 'Add Projects',
                'icon' => 'nav-icon fas fa-user',
                'url'=>'projects/add'
            ], 	
 [
                'text' => 'Change Password',
                'icon' => 'nav-icon fas fa-user',
                'url'=>'profile'
            ], 			
            
        ];

        $customerMenu = [
             
        ];

        $menu = [];

        // Add role-specific menu items
        if ($role == 1) {
            $menu = $adminMenu;
        } elseif ($userRole == 2) {
            $menu = $customerMenu;
            $menu[] = [
                'text' => 'User Profile',
                'url' => '/profile',
                'icon' => 'nav-icon fas fa-fw fa-user',
            ];
        }

        return $menu;
    }
}
