<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Cgi\CgiVideoTemplates;

class ImageLibrary extends Model
{
    use HasFactory;

    protected $table = 'image_library';
    protected $fillable = [
        'template_type',
        'cgi_template',
        'image_template',
        'canvas_data',
        'width',
        'height',
        'image_path',
        'template_name'
    ];


    public function template()
    {
        return $this->belongsTo(CgiVideoTemplates::class, 'cgi_template');
    }
}
