<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\UserSubscriptions;

class PublishedWebsites extends Model
{
    use HasFactory;
    protected $table = 'published_websites';
    protected $fillable = ['project_id', 'subscription_id', 'zip_path', 'project_id', 'status'];

    /**
     * Get the user that owns the PublishedWebsites
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function subscription()
    {
        return $this->belongsTo(UserSubscriptions::class, 'subscription_id');
    }
}
