<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class SocialiteServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $socialite = $this->app->make(\Laravel\Socialite\Contracts\Factory::class);
        $socialite->extend('tiktok', function ($app) use ($socialite) {
            $config = $app['config']['services.tiktok'];
            return $socialite->buildProvider(\SocialiteProviders\TikTok\Provider::class, $config);
        });
    }
}
