<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ecommerce_projects', function (Blueprint $table) {
            $table->string('company_email')->after('longitude')->nullable(); // Add company_email after longitude
            $table->string('company_phone')->after('company_email')->nullable(); // Add company_phone after company_email
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ecommerce_projects', function (Blueprint $table) {
            $table->dropColumn(['company_email', 'company_phone']);
        });
    }
};
