<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cpanel', function (Blueprint $table) {
            $table->id();
            $table->string('domain')->unique();
            $table->string('user');
            $table->string('password');
            $table->string('api_token')->nullable();
            $table->unsignedBigInteger('whm_id');
            $table->timestamps();
            // Foreign key constraint
            $table->foreign('whm_id')->references('id')->on('whm')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cpanel');
    }
};