<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_emails', function (Blueprint $table) {
            $table->id();
            $table->string('email');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('mailbox_id')->constrained('mailboxes')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_emails');
    }
};
