<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('mailboxes', function (Blueprint $table) {
            $table->string('organization')->nullable()->after('google_id');
            $table->string('signature')->nullable()->after('organization');
            $table->boolean('is_loggedin')->default(1)->after('signature');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mailboxes', function (Blueprint $table) {
            $table->dropColumn(['organization', 'is_loggedin', 'signature']);
        });
    }
};
