<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        
        Schema::create('user_invoices', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('invoice_id')->unique();
            $table->string('transaction_id')->nullable();
            $table->string('stripe_payment_id')->nullable();
            $table->decimal('amount', 10, 2); // better for money
            $table->string('plan_name');
            $table->date('invoice_date'); // use proper date type
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_invoices');
    }
};
