<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_ecommerce_subscriptions', function (Blueprint $table) {
            $table->enum('status', ['active', 'cancelled', 'expired'])->after('transaction_id')->default('active');
            $table->json('renew_transaction_ids')->after('status')->nullable();
            $table->date('cancellation_date')->after('renew_transaction_ids')->nullable();
            $table->longText('cancel_reason')->after('cancellation_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_ecommerce_subscriptions', function (Blueprint $table) {
            $table->dropColumn(['status', 'renew_transaction_ids', 'cancellation_date', 'cancel_reason']);
        });
    }
};
