<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use Illuminate\Support\Facades\Http; 
use Illuminate\Support\Facades\Log;


class CrmController extends Controller
{
    public function dashboard()
    {
        return view('crm.dashboard');
    }

    public function projectsList()
    {
        $data['projects'] = DB::table('projects')->where('uid', Auth::user()->id)->get();
        $data['project_categories'] = DB::table('web_categories')->get();
        return view('crm.projects', $data);
    }

    public function crmConnect(Request $request)
    {
        $project_id = $request->project_id;
        $project = DB::table('projects')->where('id', $project_id)->first();
        if(empty($project))
        {
            return response()->json(['result'=>false, 'msg'=>'Project not found']);
        }

        $api_key = $request->api_key;
        $web_url = $request->web_url;
        if (!preg_match("/^https?:\/\//", $web_url)) {
            $web_url = 'https://' . $web_url;
        }
        $originalUrl = $web_url;
        $web_url .= '/api/connect';
        $data['api_key'] = $api_key;
        
        // Use the Http facade here to send a POST request
        $response = Http::withHeaders([
            'api_key' => $api_key,
        ])->post($web_url, $data);

        if ($response->successful()) {

            $apiResult = json_decode($response->body(), true);
            if(empty($apiResult))
            {
                return response()->json(['result'=>false, 'msg'=>'Api key not found']);
            }

            if(!$apiResult['result'])
            {
                return response()->json(['result'=>false, 'msg'=>'Api key not found']);    
            }

            $pCrm = DB::table('project_crm')->where('project_id', $project_id)->first();
            if(empty($pCrm))
            {
                DB::table('project_crm')->insert([
                    'project_id'=>$project_id,
                    'web_url'=>$originalUrl,
                    'api_key'=>$api_key
                ]);
            }else{
                DB::table('project_crm')->where('project_id', $project_id)->update(['web_url'=>$originalUrl,'api_key'=>$api_key]);
            }

            return response()->json(['result'=>true]);

        }else{
            return response()->json(['result'=>false, 'code'=>$response->status(), 'body'=>$response->body()]);
        }
    }

    public function viewProject(Request $request)
    {
        $data = [];
        $id = $request->id;
        $project = DB::table('projects')->where('id', $id)->where('uid', Auth::user()->id)->first();
        if(empty($project))
        {
            return redirect()->back()->with(['error'=>'Project not found']);
        }

        $key_and_url = $this->api_key_and_url($id);
        if(!$key_and_url)
        {
            return redirect()->back()->with(['error'=>'Project not connected with any website']); 
        }

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $users = $this->crm_users($key, $url);
        Log::info($users);
        $usersCount = 0;
        if($users)
        {
            $users = json_decode($users, true);
            if(!empty($users) && is_array($users))
            {
                $usersCount = $users['users_count'];        
            }
        }

        $data['project_info'] = $project;
        $data['users_count'] = $usersCount;
        return view('crm.project_dashboard', $data);
    }

    public function projectUsers(Request $request)
    {
        $data = [];
        $project_info = $this->project_info($request->id);
        $id = $request->id;
        if(!$project_info)
        {
            return redirect()->back()->with(['error'=>'Project not found']);
        }

        $key_and_url = $this->api_key_and_url($id);
        if(!$key_and_url)
        {
            return redirect()->back()->with(['error'=>'Project not connected with any website']); 
        }
        $data['project_info'] = $project_info;

        $users = $this->crm_users($key_and_url->api_key, $key_and_url->web_url);

        $crmUsers = [];
        if($users)
        {
            $users = json_decode($users, true);
            if(is_array($users))
            {
                $crmUsers = $users['users'];
            }
        }
        $data['users'] = $crmUsers;
        return view('crm.project_users', $data);
    }

    public function userDelete(Request $request)
    {
        $user_id = $request->user_id;
        $project_id = $request->project_id;
        $project_info = $this->project_info($project_id);
        if(!$project_info)
        {
            return response()->json(['result'=>false, 'msg'=>'Project not found']);
        }

        $key_and_url = $this->api_key_and_url($project_id);
        if(!$key_and_url)
        {
            return response()->json(['result'=>false, 'msg'=>'Project not connected with any website']); 
        }

        $key = $key_and_url->api_key;
        $url = $key_and_url->web_url;

        $user_delete = $this->delete_crm_user($user_id, $key, $url);
        if(!$user_delete)
        {
            return response()->json(['result'=>false, 'msg'=>'Some error occured']);
        }


        $user_delete = json_decode($user_delete, true);
        if(is_array($user_delete))
        {
            if($user_delete['result'])
            {
                return response()->json(['result'=>true]);
            }
        }

    }

    public function delete_crm_user($user_id, $key, $url)
    {
        $url .= '/api/user/delete';
        $data['user_id'] = $user_id;
         try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

    public function project_info($id)
    {
        $project =  DB::table('projects')->where('id', $id)->first();
        if(empty($project))
        {
            return false;
        }

        return $project;
    }

    public function api_key_and_url($project_id)
    {
        $project = DB::table('project_crm')->where('project_id', $project_id)->first();
        if(empty($project))
        {
            return false;
        }

        return $project;
    }

    public function crm_users($key, $url)
    {
        $url .= '/api/users';
        $data = [];

        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

    public function getPackages(Request $request)
    {
        $project_id = $request->projectId;
        $data = [];
        $project_info = $this->project_info($project_id);
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $subscriptionList = $this->getSubscriptions($url, $key);
        $subscriptions = [];
        if($subscriptionList)
        {
            $subscriptionList = json_decode($subscriptionList, true);
            if(is_array($subscriptionList) && !empty($subscriptionList))
            {
                foreach ($subscriptionList as $list) {
                   $buyNowLink = $url."/subscription/".$list['id'].'/buy';
                   $subscriptions[] = ['name'=>$list['name'], 'link'=>$buyNowLink, 'price'=>'$'.$list['price']];
                }
            }

            return response()->json(['result'=>true, 'subscriptions'=>$subscriptions]);
        }

        return response()->json(['result'=>false]);
    }

    public function subscriptions(Request $request)
    {
        $data = [];
        $project_info = $this->project_info($request->id);
        
        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $subscriptionList = $this->getSubscriptions($url, $key);
        $data['subscriptions'] = [];
        if($subscriptionList)
        {
            $data['subscriptions'] =json_decode($subscriptionList, true);
        }
        $data['web_url'] = $url;
        return view('crm.subscriptions', $data);
    }

    public function deleteSubscription(Request $request)
    {
        $project_id = $request->project_id;
        $id = $request->id;
        $project_info = $this->project_info($project_id);
        
        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $delete = $this->deleteSub($url, $key, $id);
        if(!$delete)
        {
            return response()->json(['result'=>false, 'msg'=>'Some error occured']);
        }

        $delete = json_decode($delete, true);
        if(is_array($delete))
        {
            if($delete['result'])
            {
                return response()->json(['result'=>true]);
            }
        }

        return response()->json(['result'=>false]);


    }

    public function deleteSub($url, $key, $id)
    {
        $data['id'] = $id;
        $url .= "/api/subscription/delete";
        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            echo $e->getMessage();
            return false;
        }
    }

    public function getSubscriptions($url, $key)
    {
        $data = [];
        $url .= '/api/subscription/list';
        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

     public function getTransactions($url, $key)
    {
        $data = [];
        $url .= '/api/transactions/list';
        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            echo $e->getMessage();
            return false;
        }
    }

    public function subscriptionAdd(Request $request)
    {
        $name = $request->name;
        $duration = $request->duration;
        $durationType = $request->durationType;
        $price = $request->price;
        $features = $request->features;

        if ($durationType == 'months') {
            $durationInDays = $duration * 30;
        } else if ($durationType == 'years') {
            $durationInDays = $duration * 365;
        } else {
            $durationInDays = $duration;
        }

        $project_id = $request->projectId;
        $project_info = $this->project_info($project_id);
        if(!$project_info)
        {
            return response()->json(['result'=>false, 'msg'=>'Project not found']);
        }

        $key_and_url = $this->api_key_and_url($project_id);
        if(!$key_and_url)
        {
            return response()->json(['result'=>false, 'msg'=>'Project not connected with any website']); 
        }

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $subscription_data = ['name'=>$name, 'duration'=>$durationInDays, 'features'=>$features, 'price'=>$price];

        $data = $this->add_subscriptions($key, $url, $subscription_data);
        if(!$data)
        {
            return response()->json(['result'=>false, 'msg'=>'Some error occured']);
        }
        return response()->json(['result'=>true]);

    }

    public function add_subscriptions($key, $url, $data)
    {
        $url .= '/api/subscription/add';
        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

    public function transactions(Request $request)
    {
        $data = [];
        $project_id = $request->id;
        $project_info = $this->project_info($project_id);

        if(!$project_info)
        {
            return redirect()->back()->with(['error'=>'No Project Found']);
        }

        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $transactions = $this->getTransactions($url, $key);
       
        if($transactions)
        {
            $transactions = json_decode($transactions, true);
            if($transactions['result'])
            {
                $transactions = $transactions['transactions'];
            }
            $data['transactions'] = $transactions;
        
        }else{

            $data['transactions'] = false;
        }
        
        return view('crm.transactions', $data);
    }

    public function activeSubscriptions(Request $request)
    {
        $data = [];
        $project_id = $request->id;
        $project_info = $this->project_info($project_id);

        if(!$project_info)
        {
            return redirect()->back()->with(['error'=>'No Project Found']);
        }

        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $subscriptions = [];

        $activeSubscriptions = $this->getActiveSubscription($url, $key);
        if($activeSubscriptions)
        {
            $activeSubscriptions = json_decode($activeSubscriptions, true);
            if(!empty($activeSubscriptions))
            {
                if($activeSubscriptions['result'])
                {
                    $subscriptions = $activeSubscriptions['subscriptions'];
                    
                }
            }
        }

        $data['subscriptions'] = $subscriptions;

        return view('crm.active_subscriptions', $data);
    }

    public function getActiveSubscription($url, $key)
    {
        $url .= '/api/subscription/active';
        try {
            $data = [];
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }
    public function create_form(Request $request)
    {
        $data = [];
        $project_id = $request->id;
        $project_info = $this->project_info($project_id);

        if(!$project_info)
        {
            return redirect()->back()->with(['error'=>'No Project Found']);
        }

        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $forms = $this->getform($url, $key);
        $includedform = [];
        if($forms)
        {
            $forms = json_decode($forms, true);
            if(is_array($forms) && $forms['result'])
            {
                $includedform = $forms['form'];
                $field_names = $includedform['fields_name'];
                $field_values = $includedform['fields_type'];
                if($field_names && $field_values)
                {
                    $field_names = json_decode($field_names, true);
                    $field_values = json_decode($field_values, true);
                    $includedform['fields'] = $field_names;
                    $includedform['types'] = $field_values; 
                }
            }
        }
        $data['included_form'] = $includedform;
        return view('crm.create_form', $data);
    }

    public function getform($url, $key)
    {
        $url .= '/api/get_form';
        $data = [];
        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
               
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

    public function createForm(Request $request)
    {
        $field_name = $request->field_name;
        $field_type = $request->field_type; 
        
        $data = [];
        $project_id = $request->id;
        $project_info = $this->project_info($project_id);

        if(!$project_info)
        {
            return redirect()->back()->with(['error'=>'No Project Found']);
        }

        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;
        $data['field_name'] = $field_name;
        $data['field_type'] = $field_type;
        $form = $this->create_active_form($url, $key, $data);
        return $form;
    }

    public function create_active_form($url, $key, $data)
    {
        $url .= '/api/create_form';
       
        try {
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
               
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

    public function inquiries(Request $request)
    {
        $data = [];
        $project_id = $request->id;
        $project_info = $this->project_info($project_id);

        if(!$project_info)
        {
            return redirect()->back()->with(['error'=>'No Project Found']);
        }

        $data['project_info'] = $project_info;
        $project_id = $project_info->id;
        $key_and_url = $this->api_key_and_url($project_id);

        $url = $key_and_url->web_url;
        $key = $key_and_url->api_key;

        $inquiries = $this->getInquries($url, $key);
        $data['inquiries'] = false;
        if($inquiries)
        {
            $data['inquiries'] = $inquiries;
        }
        return view('crm.inquiries', $data);
    }

     public function getInquries($url, $key)
    {
        $url .= '/api/inquiries';
       
        try {
            $data = [];
            $response = Http::withHeaders([
                'api_key' => $key,
            ])->post($url, $data);

            if ($response->successful()) {
               
                return $response->body();
            }
            return false;
            
        } catch (\Exception $e) {
            return false;
        }
    }

    public function createPosts(Request $request)
    {
        $data = [];
        return view('crm.create_posts', $data);
    }
}
