<?php

namespace ShortLink\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class ShortLinkSetting extends Model
{
    protected $table = 'short_link_setting';

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'int';

    protected $fillable = [
        'id',
        'allow_guest_shortening',
        'allow_password_protection',
        'blocklisted_domains',
    ];

    protected $casts = [
        'allow_guest_shortening' => 'boolean',
        'allow_password_protection' => 'boolean',
    ];

    public static function getOrCreateDefault(): self
    {
        // If table is missing (e.g., live server without migration), return an unsaved default model
        if (!Schema::hasTable('short_link_setting')) {
            $m = new static();
            $m->id = 1;
            $m->allow_guest_shortening = false;
            $m->allow_password_protection = true;
            $m->blocklisted_domains = '';
            return $m;
        }

        $model = static::firstOrNew(['id' => 1]);
        if (!$model->exists) {
            $model->allow_guest_shortening = false;
            $model->allow_password_protection = true;
            $model->blocklisted_domains = '';
        }
        return $model;
    }

    public static function ensureTable(): void
    {
        if (!Schema::hasTable('short_link_setting')) {
            Schema::create('short_link_setting', function (Blueprint $table) {
                $table->unsignedInteger('id')->primary();
                $table->boolean('allow_guest_shortening')->default(false);
                $table->boolean('allow_password_protection')->default(true);
                $table->text('blocklisted_domains')->nullable();
                $table->timestamps();
            });
        }
    }
}
