<?php

namespace ShortLink\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShortLinks extends Model
{
    use HasFactory;

    protected $table = 'short_links';

    protected $fillable = [
        'domain',
        'long_link',
        'short_link',
        'title',
        'backhalf',
        'user_id',
        'expires_at',
        'password',
        'original_password',
        'is_paused',
        'generate_qr',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'is_paused' => 'boolean',
        'generate_qr' => 'boolean',
    ];
}
