<?php

namespace ShortLink\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Routing\Router;
use App\Http\Middleware\Authenticate;
use App\Http\Middleware\RoleMiddleware;

class ShortLinkProvider extends ServiceProvider
{
    public function register()
    {
    }

    public function boot(Router $router)
    {
        $helperFile = __DIR__ . '/../Helpers/functions.php';
        if (file_exists($helperFile)) {
            require_once $helperFile;
        }

        $this->loadRoutesFrom(__DIR__ . '/../routes/web.php');

        // ✅ FIXED PATH
        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'shortlink');
        
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');
        $router->aliasMiddleware('auth', Authenticate::class);
        $router->aliasMiddleware('role', RoleMiddleware::class);
    }
}
