<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('short_link_setting')) {
            Schema::create('short_link_setting', function (Blueprint $table) {
                $table->unsignedInteger('id')->primary();
                $table->boolean('allow_guest_shortening')->default(false);
                $table->boolean('allow_password_protection')->default(true);
                $table->text('blocklisted_domains')->nullable();
                $table->timestamp('created_at')->nullable();
                $table->timestamp('updated_at')->nullable();
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('short_link_setting');
    }
};
