@extends('shortlink::app')

@section('css')
<style>
 .glass-card{background:rgba(255,255,255,.15);backdrop-filter:blur(10px);border-radius:14px;border:1px solid rgba(255,255,255,.2)}
 .form-label{color:#fff}
</style>
@endsection

@section('content')
<div class="container py-4">
  <div class="betweenflex mt-3">
    <h4 class="text-white">{{ isset($link) ? 'Edit Short Link' : 'Create Short Link' }}</h4>
    <a href="{{ url('crm/projects/short-links') }}" class="btn btn-dark transparent-btn fs-6">Back</a>
  </div>

  <div class="glass-card p-4 mt-3">
    <form method="post" action="{{ isset($link) ? route('shortlinks.update',$link->id) : route('shortlinks.store') }}">
      @csrf
      @if(isset($link))
        @method('PUT')
      @endif
      <div class="row g-3">
        <div class="col-12">
          <label class="form-label">Long URL</label>
          <input type="url" name="long_url" class="form-control" placeholder="https://example.com/very/long/url" value="{{ old('long_url', $link->long_link ?? '') }}" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Custom Slug (optional)</label>
          <input type="text" name="slug" class="form-control @error('slug') is-invalid @enderror" 
                 placeholder="Enter custom slug (e.g., my-offer)" 
                 value="{{ old('slug', $link->backhalf ?? '') }}"
                 pattern="[a-zA-Z0-9_-]+"
                 title="Only letters, numbers, hyphens and underscores are allowed">
          @error('slug')
            <div class="invalid-feedback d-block">
              {{ $message }}
            </div>
          @enderror
        </div>
        <div class="col-md-6">
          <label class="form-label">Expiry (optional)</label>
          <input type="datetime-local" name="expires_at" class="form-control" value="{{ isset($link->expires_at) && $link->expires_at ? $link->expires_at->format('Y-m-d\\TH:i') : '' }}">
        </div>
        @php
            $isPasswordEnabled = $settings->allow_password_protection ?? false;
            $hasPassword = isset($link) && !empty($link->password);
        @endphp
        <div class="col-md-6">
          <label class="form-label">Password {{ $isPasswordEnabled ? '(optional)' : '(disabled)' }}</label>
          <input type="text" name="password" id="password" class="form-control" 
                placeholder="{{ $hasPassword ? 'Enter new password (leave blank to keep)' : 'Enter password' }}"
                {{ !$isPasswordEnabled ? 'disabled' : '' }}>
          @error('password')
            <div class="text-danger small mt-1">{{ $message }}</div>
          @enderror
          @if($hasPassword)
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" value="1" id="password_off" name="password_off" 
                    {{ !$isPasswordEnabled ? 'disabled' : '' }}>
              <label class="form-check-label text-white" for="password_off">Remove password</label>
            </div>
          @endif
        </div>
        <div class="col-md-6 d-flex align-items-end">
          <div class="form-check">
            <input type="hidden" name="generate_qr" value="0">
            <input class="form-check-input" type="checkbox" value="1" id="generate_qr" name="generate_qr" {{ old('generate_qr', isset($link) ? ($link->generate_qr ?? true) : true) ? 'checked' : '' }}>
            <label class="form-check-label text-white" for="generate_qr">Generate QR</label>
          </div>
        </div>
      </div>
      <div class="text-end mt-3">
        <button class="btn btn-primary">{{ isset($link) ? 'Update' : 'Create' }}</button>
      </div>
    </form>
  </div>
  @if(isset($link))
    <div class="glass-card p-3 mt-3">
      <div class="text-white-50">Current short link:</div>
      <a href="{{ $link->short_link }}" target="_blank">{{ $link->short_link }}</a>
    </div>
  @endif
</div>
@endsection
