@extends('shortlink::app')

@section('css')
<style>
 .glass-card{background:rgba(255,255,255,.15);backdrop-filter:blur(10px);border-radius:14px;border:1px solid rgba(255,255,255,.2)}
 .form-label{color:#fff}
 .short-url{font-size:1.1rem}
</style>
@endsection

@section('content')
<div class="container py-4">
  <div class="betweenflex mt-3">
    <h4 class="text-white">Short Link Created</h4>
    <a href="{{ url('crm/projects/short-links') }}" class="btn btn-dark transparent-btn fs-6">Back to list</a>
  </div>

  <div class="glass-card p-4 mt-3">
    <div class="row g-3 align-items-center">
      <div class="col-lg-7">
        <div class="text-white mb-2">Your short link</div>
        <div class="d-flex align-items-center gap-2">
          <a class="short-url" href="{{ $link->short_link }}" target="_blank">{{ $link->short_link }}</a>
          <button class="btn btn-sm btn-primary" id="copyBtn" data-link="{{ $link->short_link }}">Copy</button>
        </div>
      </div>
      <div class="col-lg-5 text-center">
        @if(!empty($qr))
          <img src="{{ $qr }}" alt="QR" class="img-fluid rounded" width="220" height="220">
          <div class="mt-2">
            <a href="{{ $qr }}" download="qr-{{ $link->backhalf }}.png" class="btn btn-outline-light btn-sm">Download QR</a>
          </div>
        @endif
      </div>
    </div>
  </div>
</div>
@endsection

@section('scripts')
<script>
  document.getElementById('copyBtn')?.addEventListener('click', function(){
    const link = this.getAttribute('data-link');
    navigator.clipboard.writeText(link).then(()=>{
      const prev = this.innerHTML; this.innerHTML='Copied'; setTimeout(()=>{this.innerHTML=prev},1200);
    });
  });
</script>
@endsection
