<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://kit.fontawesome.com/768b80f5c3.js" crossorigin="anonymous"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('assets/cgi_video/editor_style.css') }}" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
    <link href="https://cdn.jsdelivr.net/npm/nouislider@15.6.0/dist/nouislider.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-minicolors/2.3.6/jquery.minicolors.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        @font-face {
            font-family: 'Exo';
            src: url('/public/fonts/Exo-Bold.ttf') format('truetype');
            font-weight: bold;
            font-style: normal;
        }

        @font-face {
            font-family: 'Exo';
            src: url('/public/fonts/Exo-Italic.ttf') format('truetype');
            font-weight: normal;
            font-style: italic;
        }

        @font-face {
            font-family: 'Exo';
            src: url('/public/fonts/Exo-Light.ttf') format('truetype');
            font-weight: 300;
            font-style: normal;
        }

        /* Use classes for different styles */
        .font-exo-bold {
            font-family: 'Exo', sans-serif;
            font-weight: bold;
            font-style: normal;
        }

        .font-exo-italic {
            font-family: 'Exo', sans-serif;
            font-weight: normal;
            font-style: italic;
        }

        .font-exo {
            font-family: 'Exo', sans-serif;
            font-weight: 300;
            font-style: normal;
        }
    </style>

</head>

<body>
    <div class="container-fluid p-0">



        <!-- Menu Bar -->
        <div class="menu-bar d-flex justify-content-between align-items-start">
            <div class="d-flex menu-bar-container align-items-center gap-3">
                <div class="d-flex menu-bar-container-div align-items-center">
                    <div style="display:none">
                        <input type="file" name="media_image" id="media_image">
                    </div>
                    <button class="d-flex flex-column tool-button" id="addImage">
                        <i class="fas fa-photo-video"></i> Media
                    </button>
                    <button class="d-flex flex-column tool-button" id="addTitle">
                        <i class="fas fa-text-height"></i> Titles
                    </button>
                    <button class="d-flex flex-column tool-button" id="showTemplates">
                        <i class="fas fa-th-large"></i> Templates
                    </button>
                    <button class="d-flex flex-column tool-button" id="trimVideo">
                        <i class="fas fa-cut"></i>
                        Trim
                    </button>
                    <button class="d-flex flex-column tool-button" id="importAndMerge">
                        <i class="fas fa-download"></i>
                        Import And Merge
                    </button>
                    <button class="d-flex flex-column tool-button" id="openUploads">
                        <i class="fas fa-upload"></i>
                        Uploads
                    </button>
                     <button class="d-flex flex-column tool-button" id="publishTemplate">
                        <i class="fas fa-save"></i>
                        Publish
                    </button>
                   
                    <button class="d-flex flex-column tool-button" id="exportVideo">
                        <i class="fas fa-file-export"></i>
                        Export
                    </button>

                </div>
            </div>
        </div>


        <!-- Main Content Area -->
        <div class="main-content">
            <div style="display: none">
                <input type="file" name="video" id="video_file">
            </div>
            <div class="side_bar">
                <div style="text-align: right">
                    <i class="fa fa-times" style="font-size:22px;" id="closeSideBar"></i>
                </div>
                <div class="form-group imageOption">
                    <label for="">Width (<span id="showImageWidth">0px</span>)</label>
                    <div class="row">
                        <div class="col-md-8">
                            <input type="range" name="textshow" id="imageWidth" value="1" min="1"
                                max="1000" class="custom-range">
                        </div>
                        <div class="col-md-4">
                            <input type="number" name="imageWidthNumber" id="imageWidthNumber" class="form-control">
                        </div>
                    </div>

                </div>
                <div class="form-group imageOption mt-3">
                    <label for="">Height (<span id="showImageHeight">0px</span>)</label>
                    <div class="row">
                        <div class="col-md-8">
                            <input type="range" name="textshow" id="imageHeight" value="1" min="1"
                                max="1000" class="custom-range">
                        </div>
                        <div class="col-md-4">
                            <input type="number" name="imageHeightNumber" id="imageHeightNumber" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="form-group textOption">
                    <label for="">Text</label>
                    <input type="text" name="textshow" id="textshow" class="form-control input-control">
                </div>
                <div class="form-group textOption mt-3">
                    <label for="">Font Family</label>
                    <select name="font_family" id="font_family" class="form-control">
                        <option value="">Select Font</option>
                        <option value="font-exo">Exo</option>
                        <option value="font-exo-bold">Exo Bold</option>
                        <option value="font-exo-italic">Exo Italic</option>
                    </select>
                </div>
                <div class="form-group mt-3 textOption">
                    <label for="">Font Size (<span id="showFontSize">0px</span>)</label>
                    <div class="row">
                        <div class="col-md-8">
                            <input type="range" name="textshow" id="fontSize" value="1" min="1"
                                max="128" class="custom-range">
                        </div>
                        <div class="col-md-4">
                            <input type="number" name="fontSizeNumber" id="fontSizeNumber" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="form-group mt-3 textOption">
                    <label for="">Font Color</label>
                    <input type="text" name="fontColor" id="changeTextColor" class="form-control">
                </div>
                 <div class="form-group mt-3 textOption">
                    <label for="">Animations</label>
                    <select name="animations" id="animations" class="form-control">
                        <option value="0">Select Animation</option>
                        <option value="fade_in">Fade In</option>
                        <option value="fade_in_left">Fade In Left</option>
                        <option value="fade_in_right">Fade In Right</option>
                        <option value="fade_in_top">Fade In Top</option>
                        <option value="fade_in_bottom">Fade In Bottom</option>
                        <option value="bounce">Bounce</option>
                        <option value="rubber_band">Rubber Band</option>
                        <option value="wooble">Wooble</option>
                    </select>
                </div>
            </div>

            <div id="imagePreviewRow" style="position: relative; text-align: center;">
                <video id="videoPreview" src="#" controls style="display: none;" height="500"></video>
            </div>

            <div id="spinnerDiv">
                <i class="fa fa-spinner fa-spin"></i>
            </div>
            <div class="drop-zone" id="uploadVideo">
                <div class="drop-zone-icon">
                    <i class="fas fa-folder fa-2x"></i>
                </div>
                <p>Click or drop videos, images, or audio here.</p>
                <a href="#" class="main-content-caption text-primary text-decoration-none">Use sample
                    media</a>
            </div>




        </div>



        <div class="timeline-container" id="timelineTrack">
            <div class="timeline-header">
                <div class="timeline-header-btns d-flex align-items-center justify-content-center gap-1">
                    <button class="header-button">
                        <i class="fas fa-expand"></i>
                    </button>
                    <button class="header-button" id="playVideo">
                        <i class="fas fa-play"></i>
                    </button>
                </div>
                <div class="timeline-ruler">
                    <div class="time-markers" id="timeMarkers">
                        <span class="time-marker" style="left: 0px">00:00:00</span>
                    </div>
                    <div class="ruler-ticks"></div>
                </div>
            </div>

            <div class="timeline-tracks">
                <div class="track-numbers">
                    <div class="track-number">1</div>
                </div>
                <div class="track-controls">
                    <div class="track">
                        <div class="track-row">
                            <i class="fas fa-video track-icon"></i>
                            <i class="fas fa-volume-up track-icon"></i>
                            <i class="fas fa-lock-open track-icon"></i>
                        </div>
                    </div>
                </div>
                <div class="track-content" id="dropZoneContent">
                    <div class="video-content" id="videoContent">
                        <div class="snapshots d-flex">

                            @if (!empty($snapshotUrls))
                                @foreach ($snapshotUrls as $snapshot)
                                    <img src="{{ $snapshot }}" alt="">
                                @endforeach
                            @endif

                        </div>
                        <div class="sliderText">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="trimVideoModal" tabindex="-1" aria-labelledby="darkModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">Trim Video</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Start</label>
                                <input type="text" name="start_time_video" id="start_time_video"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">End</label>
                                <input type="text" name="start_time_video" id="end_time_video"
                                    class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-outline-light" id="trim_video">Trim</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="importVideo" tabindex="-1" aria-labelledby="darkModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">Import And Merge Video</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- Video Upload -->
                            <div class="form-group">
                                <label for="merge_video">Upload Video</label>
                                <input type="file" name="merge_video" id="merge_video" class="form-control">
                            </div>
                        </div>

                        <div class="col-md-12 mt-3">
                            <!-- Merge Position Option -->
                            <div class="form-group">
                                <label for="merge_position">Merge Position</label>
                                <select name="merge_position" id="merge_position" class="form-control">
                                    <option value="start">At the Beginning</option>
                                    <option value="end" selected>At the End</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-outline-light" id="merge_video_btn">Merge Video</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="draftVideoModal" tabindex="-1" aria-labelledby="darkModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">Draft Video</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- Video Upload -->
                            <div class="form-group">
                                <label for="merge_video">Template Name</label>
                                <input type="text" name="merge_video" id="template_name" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-outline-light" id="saveTemplateVideo">Save
                        Template</button>
                </div>
            </div>
        </div>
    </div>


        <div class="modal fade" id="publishModal" tabindex="-1" aria-labelledby="darkModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">Template Name</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- Video Upload -->
                            <div class="form-group">
                                <label for="merge_video">Template Name</label>
                                <input type="text" name="merge_video" id="publish_template_name" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-outline-light" id="publishTemplateBtn">Publish
                        Template</button>
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="showVideoTemplates" tabindex="-1" aria-labelledby="darkModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content modal-lg bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">Video Templates</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row" id="video_template">

                    </div>
                </div>

                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-outline-light" id="updateTemplateVideo">Update
                        Template</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="cgiVideos" tabindex="-1" aria-labelledby="darkModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">My Cgi Videos</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Merge Position</label>
                                 <select name="merge_position" id="video_merge_position" class="form-control">
                                    <option value="start">At the Beginning</option>
                                    <option value="end" selected>At the End</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="videosRow"></div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editorImagesModal" tabindex="-1" aria-labelledby="darkModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="darkModalLabel">My Images</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row" id="imagesLibraryModal"></div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/nouislider@15.6.0/dist/nouislider.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-minicolors/2.3.6/jquery.minicolors.min.js"></script>
    <script src="{{ asset('assets/cgi_video/js/video_editor.js') }}"></script>
    <script>
        $("#uploadVideo").on('click', function() {
            $("#video_file").click();
        });

        $("#video_file").on('change', function() {
            $("#spinnerDiv").show();

            $("#uploadVideo").hide();
            let formData = new FormData();
            formData.append('_token', "{{ csrf_token() }}");
            formData.append('video', $('#video_file')[0].files[0]);
            $.ajax({
                url: "{{ route('video.upload') }}",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                beforeSend: function() {},
                success: function(response) {
                    $("#spinnerDiv").hide();
                    if (response.result) {
                        $("#videoPreview").show();
                        $("#imagePreviewRow").show();
                        var url = response.url;
                        $("#videoPreview").attr('src', url);

                        $("#staticView").hide();
                        if (response.snapshots.length > 0) {
                            var snapshots = response.snapshots;
                            $("#videoContent").show();
                            $(".snapshots").html("");
                            snapshots.forEach(snapshot => {
                                $(".snapshots").append('<img src="' + snapshot + '" />')
                            });
                        }
                        var durations = response.duration;


                        if (durations && durations > 0) {
                            let container = $('#timeMarkers');
                            container.html(''); // clear existing

                            let interval = 5; // seconds
                            let totalMarkers = Math.floor(durations / interval);

                            for (let i = 0; i <= totalMarkers; i++) {
                                let seconds = i * interval;

                                // Convert seconds to HH:MM:SS
                                let hrs = Math.floor(seconds / 3600).toString().padStart(2, '0');
                                let mins = Math.floor((seconds % 3600) / 60).toString().padStart(2,
                                    '0');
                                let secs = (seconds % 60).toString().padStart(2, '0');
                                let timeLabel = `${hrs}:${mins}:${secs}`;
                                let leftPos = (i * 187) +
                                    'px'; // Adjust this scale to match your video timeline width

                                container.append(
                                    `<span class="time-marker" style="left: ${leftPos}">${timeLabel}</span>`
                                );
                            }

                            // Add final marker at duration if not already included
                            if (durations % interval !== 0 || durations < interval) {
                                let seconds = Math.floor(durations);
                                let hrs = Math.floor(seconds / 3600).toString().padStart(2, '0');
                                let mins = Math.floor((seconds % 3600) / 60).toString().padStart(2,
                                    '0');
                                let secs = (seconds % 60).toString().padStart(2, '0');
                                let timeLabel = `${hrs}:${mins}:${secs}`;
                                let leftPos = (durations / interval * 187) +
                                    'px'; // or scale it however you need

                                container.append(
                                    `<span class="time-marker" style="left: ${leftPos}">${timeLabel}</span>`
                                );
                            }
                        }



                    }
                },
                error: function(xhr) {
                    alert("Some error occured");
                }
            });
        });
    </script>
     <script>
        let textIdCounter = 0;
        let sliderCount = 0;
        let counterPosition = 0;

        $("#addTitle").on('click', function() {
            let maxZIndex = 0;

            // Check z-index of all text overlays
            $(".textPreview").each(function () {
                const z = parseInt($(this).css("z-index")) || 0;
                if (z > maxZIndex) maxZIndex = z;
            });

            // Check z-index of all image overlays
            $(".overlay-image").each(function () {
                const z = parseInt($(this).css("z-index")) || 0;
                if (z > maxZIndex) maxZIndex = z;
            });

            var newZIndex = maxZIndex + 1;

            const newText = $(`
                <p data-id="${textIdCounter}" style="z-index:${newZIndex}" class="editable textPreview" contenteditable="true">Text</p>
            `).draggable({
                containment: "#imagePreviewRow"
            });

            $("#videoPreview").after(newText);
            addTextControl(textIdCounter);
            textIdCounter++;
            counterPosition++;
        });

        function addTextControl(textId) {
            const stringText = `
                <div class="timeline-tracks" data-id="${textId}">
                    <div class="track-numbers">
                        <div class="track-number">${textId + 1}</div>
                    </div>
                    <div class="track-controls">
                        <div class="track">
                            <div class="track-row">
                                <i class="fas fa-font track-icon"></i>
                                <i class="fas fa-arrow-up track-icon moveElementUp"></i>
                                <i class="fas fa-arrow-down track-icon moveElementDown"></i>
                                <i class="fas fa-trash text-danger track-icon removeTextElement" data-id="${textId}"></i>
                            </div>
                        </div>
                    </div>
                    <div class="track-content" id="dropZoneContent">
                        <div class="video-content" id="videoContent">
                            <div class="sliderText"></div>
                        </div>
                    </div>
                </div>
            `;

            $("#timelineTrack").append(stringText);
            addNoUiSlider(sliderCount++, textId);
        }

        function addNoUiSlider(id, textId) {
            const totalPixel = $(".snapshots img").length * 37;

            const sliderWrapper = $(`
                <div id="slider-wrapper-${id}" style="position: relative; width: ${totalPixel}px;"></div>
            `);

            const label = $(`
                <span class="slider-label" style="
                    position: absolute;
                    top: 13px;
                    left: 50%;
                    transform: translateX(-50%);
                    font-size: 22px;
                    color: #333;
                    z-index: 9999;
                    font-weight: 700;
                ">Text</span>
            `);

            const sliderDiv = $(`<div id="slider-${textId}"></div>`);

            sliderWrapper.append(label, sliderDiv);
            $(".sliderText").last().append(sliderWrapper);

            const videoEl = $('#videoPreview')[0];

            function createSlider(duration) {
                noUiSlider.create(sliderDiv[0], {
                    start: [0, duration],
                    connect: true,
                    range: {
                        min: 0,
                        max: duration
                    },
                    tooltips: true,
                    format: {
                        to: value => Math.round(value),
                        from: value => Number(value)
                    }
                });

                sliderDiv[0].noUiSlider.on('update', () => {
                    label.text(`Text`);
                });
            }

            // Load duration
            if (videoEl && videoEl.readyState >= 1) {
                createSlider(videoEl.duration);
            } else if (videoEl) {
                $('#videoPreview').one('loadedmetadata', function() {
                    createSlider(this.duration);
                });
            }
        }
    </script>
     <script>
        $("#exportVideo").on('click', function() {

            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>")

            var src = $("#videoPreview").attr('src');

            const videoElement = document.getElementById('videoPreview');
            const displayWidth = videoElement.offsetWidth;
            const displayHeight = videoElement.offsetHeight;




            const overlays = [];
            $(".textPreview").each(function() {
                var sliderId = $(this).attr('data-id');
                const $el = $(this);
                const text = $el.text();
                const fontSize = parseInt($el.css("font-size"));
                const color = $el.css("color");
                const zIndex = parseInt($el.css("z-index")) || 0;
                const position = $el.position();
                var sliderValues = getSliderValues(sliderId);
                var fontUrl = $(this).attr('data-font');
                var animation = $(this).attr('data-animation');
                overlays.push({
                    text: text,
                    x: Math.round(position.left),
                    y: Math.round(position.top + fontSize), // baseline adjustment
                    fontSize: fontSize,
                    color: color,
                    zIndex: zIndex,
                    start: sliderValues.start,
                    end: sliderValues.end,
                    font: fontUrl,
                    animation:animation
                });
            });

            const imageOverlays = [];
            $(".overlay-image").each(function() {
                var sliderId = $(this).attr('data-id');
                var sliderValues = getSliderValues(sliderId);
                const $img = $(this);
                const position = $img.position();
                const width = $img.width();
                const height = $img.height();
                const zIndex = parseInt($img.css("z-index")) || 0;

                imageOverlays.push({
                    src: $img.attr("src"),
                    x: Math.round(position.left),
                    y: Math.round(position.top),
                    width: width,
                    height: height,
                    zIndex: zIndex,
                    start: sliderValues.start,
                    end: sliderValues.end
                });
            });



            var url = "{{ route('video.export') }}";

            $.ajax({
                url: url,
                method: 'POST',
                data: {
                    video: src,
                    overlays: JSON.stringify(overlays),
                    _token: "{{ csrf_token() }}",
                    video_width: displayWidth,
                    video_height: displayHeight,
                    image_overlays: JSON.stringify(imageOverlays),
                },
                success: function(res) {
                    alert("Exported: " + res.url);
                    btn.html(btn_html);
                    window.open(res.url, "_blank");
                },
                error: function() {
                    btn.html(btn_html);
                    alert("Failed to export video.");
                }
            });
        });

        function getSliderValues(id) {
            const sliderElement = document.getElementById(`slider-${id}`);
            if (sliderElement && sliderElement.noUiSlider) {
                const values = sliderElement.noUiSlider.get();
                const start = parseFloat(values[0]);
                const end = parseFloat(values[1]);
                return {
                    start,
                    end
                };
            } else {
                return {
                    start: 0,
                    end: 0
                };
            }
        }
    </script>
    <script>
        $("#addImage").on('click', function() {
            $("#media_image").click();
        });

        let counterImageSlider = 99;

        $("#media_image").on('change', function() {
            let fileInput = this;
            if (fileInput.files.length === 0) return;

            let formData = new FormData();
            formData.append('image', fileInput.files[0]);
            formData.append('_token', '{{ csrf_token() }}');

            $.ajax({
                url: "{{ route('video.upload.image') }}", // define this route in web.php
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $("#media_image").val("");
                    if (response.url) {
                        
                        let maxZIndex = 0;

                        // Check z-index of all text overlays
                        $(".textPreview").each(function () {
                            const z = parseInt($(this).css("z-index")) || 0;
                            if (z > maxZIndex) maxZIndex = z;
                        });

                        // Check z-index of all image overlays
                        $(".overlay-image").each(function () {
                            const z = parseInt($(this).css("z-index")) || 0;
                            if (z > maxZIndex) maxZIndex = z;
                        });

                        var newZIndex = maxZIndex + 1;

                        const img = $('<img src="' + response.url + '" data-id="' + counterImageSlider +
                            '" class="overlay-image editable">');
                        img.css({
                            position: 'absolute',
                            top: '50px',
                            left: '50px',
                            width: '100px',
                            height: '100px',
                            'z-index':newZIndex
                        });
                        $('#imagePreviewRow').append(img);

                        img.draggable({
                            containment: "#imagePreviewRow"
                        });

                        addImageControl(counterImageSlider);
                        counterImageSlider++;

                    }
                },
                error: function() {
                    $("#media_image").val("");
                    alert("Image upload failed.");
                }
            });
        });

        function addImageControl(imgId) {
            const trackHTML = `
                <div class="timeline-tracks" data-id="${imgId}">
                    <div class="track-numbers">
                        <div class="track-number">${sliderCount + 1}</div>
                    </div>
                    <div class="track-controls">
                        <div class="track" data-trackOf="${sliderCount}">
                            <div class="track-row">
                                <i class="fas fa-image track-icon"></i>
                                <i class="fas fa-arrow-up track-icon moveElementUp"></i>
                                <i class="fas fa-arrow-down track-icon moveElementDown"></i>
                                <i data-id="${imgId}" class="fas fa-trash text-danger removeImageElement track-icon"></i>
                            </div>
                        </div>
                    </div>
                    <div class="track-content">
                        <div class="video-content">
                            <div class="sliderText"></div>
                        </div>
                    </div>
                </div>
            `;

            $("#timelineTrack").append(trackHTML);
            addImageSlider(sliderCount++, imgId);
        }


        function addImageSlider(id, imgId) {
            var totalPixel = 0;
            $(".snapshots img").each(function() {
                totalPixel += 37;
            });

            // Create slider wrapper
            const sliderWrapper = $(`
                <div id="slider-wrapper-${id}" style="position: relative; width: ${totalPixel}px;"></div>
            `);

            // Center the label inside the wrapper
            const label = $(`
                <span class="slider-label" style="
                    position: absolute;
                    top: 13px;
                    left: 50%;
                    transform: translateX(-50%);
                    font-size: 22px;
                    color: #333;
                    z-index: 9999;
                    font-weight: 700;
                ">
                    Image
                </span>
            `);

            const sliderDiv = $(`<div id="slider-${imgId}"></div>`);

            // Append to wrapper
            sliderWrapper.append(label);
            sliderWrapper.append(sliderDiv);
            $(".sliderText").last().append(sliderWrapper);

            const videoEl = $('#videoPreview')[0];
            if (videoEl.readyState >= 1) {
                // Metadata is already loaded
                createImageSlider(videoEl.duration);
            } else {
                // Wait for it to load
                $('#videoPreview').one('loadedmetadata', function() {
                    createImageSlider(this.duration, imgId);
                });
            }

            function createImageSlider(videoSeconds) {
                noUiSlider.create(sliderDiv[0], {
                    start: [0, videoSeconds],
                    connect: true,
                    range: {
                        min: 0,
                        max: videoSeconds
                    },
                    tooltips: true,
                    format: {
                        to: value => Math.round(value),
                        from: value => Number(value)
                    }
                });

                // Optional: Update label dynamically
                sliderDiv[0].noUiSlider.on('update', function(values) {
                    label.text(`Image`);
                });
            }

        }


        function isLabelInView(label, container) {
            const labelRect = label.getBoundingClientRect();
            const containerRect = container.getBoundingClientRect();
            return (
                labelRect.left >= containerRect.left &&
                labelRect.right <= containerRect.right
            );
        }
    </script>
    <script>
        $("#publishTemplate").on('click', function(){
            $("#publishModal").modal('show');
        });
        $("#publishTemplateBtn").on('click', function(){
            var url = "{{ route('publishVideo') }}";
            var videoUrl = $("#videoPreview").attr('src');
            var templateName = $("#publish_template_name").val();
           
            var overlays = [];
            $(".textPreview").each(function() {
                var sliderId = $(this).attr('data-id');
                const $el = $(this);
                const text = $el.text();
                const fontSize = parseInt($el.css("font-size"));
                const color = $el.css("color");
                const position = $el.position();
                var sliderValues = getSliderValues(sliderId);
                var animation = $el.attr('data-animation');
                var classList = $el.attr("class");
                var font = $el.attr('data-font');
                var zIndex = parseInt($el.css("z-index")) || 0;
                overlays.push({
                    text: text,
                    x: Math.round(position.left),
                    y: Math.round(position.top + fontSize), // baseline adjustment
                    fontSize: fontSize,
                    color: color,
                    start: sliderValues.start,
                    end: sliderValues.end,
                    animation:animation,
                    classes:classList,
                    font:font,
                    z_index:zIndex
                });
            });

            overlays = JSON.stringify(overlays);

            var imageOverlays = [];
            $(".overlay-image").each(function() {
                var sliderId = $(this).attr('data-id');
                var sliderValues = getSliderValues(sliderId);
                const $img = $(this);
                const position = $img.position();
                const width = $img.width();
                const height = $img.height();
                var zIndex = parseInt($img.css("z-index")) || 0;
                imageOverlays.push({
                    src: $img.attr("src"),
                    x: Math.round(position.left),
                    y: Math.round(position.top),
                    width: width,
                    height: height,
                    start: sliderValues.start,
                    end: sliderValues.end,
                    zIndex:zIndex
                });
            });

            imageOverlays = JSON.stringify(imageOverlays);

            var snapshots = [];
            $(".snapshots img").each(function() {
                snapshots.push($(this).attr('src'));
            });
           

            snapshots = JSON.stringify(snapshots);

            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");

            $.post(url, {templateName:templateName, url:videoUrl, _token:"{{csrf_token()}}", texts:overlays, images:imageOverlays, snapshots:snapshots}, function(data){
                btn.html(btn_html);
                $("#publishModal").modal('hide');
            })
        });
    </script>
    <script>
         $("#merge_video_btn").on('click', function() {
            var btn = $(this);
            var btn_html = btn.html();
            btn.prop('disabled', true);
            btn.html("<i class='fa fa-spinner fa-spin ml-2'></i>");
            
            // ✅ Correct way to get file from input[type=file]
            var videoFile = $("#merge_video")[0].files[0];
            var position = $("#merge_position").val(); // 'start' or 'end'
            var originalVideoSrc = $("#videoPreview").attr('src'); // Base video src

            if (!videoFile || !originalVideoSrc) {
                alert("Please select a video and ensure base video is loaded.");
                btn.prop('disabled', false);
                btn.html(btn_html);
                return;
            }

            var formData = new FormData();
            formData.append("merge_video", videoFile);
            formData.append("merge_position", position);
            formData.append("original_video", originalVideoSrc);
            formData.append('_token', "{{ csrf_token() }}"); // CSRF from meta tag

            var url = "{{ route('mergeVideo') }}"; // Laravel route

            $.ajax({
                url: url,
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    

                    if (response.merged_video_url) {
                        $("#videoPreview").attr('src', response.merged_video_url);

                        if(response.snapshots)
                        {
                            var snapshots = response.snapshots;
                            var completeSnapshots = snapshots.merged;
                            if(completeSnapshots.length > 0)
                            {
                                updateSnapshots(completeSnapshots);
                            }
                            var mergeVideoSnapshots = snapshots.merge;
                            if(mergeVideoSnapshots.length > 0)
                            {
                                var mergeStart = response.merge_start;
                                var mergeEnd = response.merge_end;

                                var snapShotString = '';
                                mergeVideoSnapshots.forEach(snapshot => {
                                    snapShotString += '<img style="height:60px;width:37px;border:1px solid #fff;" src="' + snapshot +
                                        '" />';
                                });

                                var stringMerged = `
                                    <div class="timeline-tracks" data-start="${mergeStart}" data-end="${mergeEnd}" data-position="${position}">
                                        <div class="track-numbers">
                                            <div class="track-number">1</div>
                                        </div>
                                        <div class="track-controls">
                                            <div class="track">
                                                <div class="track-row">
                                                    <i class="fas fa-video track-icon"></i>
                                                    <i class="fas fa-trash removeMergeVideo track-icon"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="track-content" id="dropZoneContent">
                                            <div class="video-content">
                                                <div class="d-flex">
                                                    ${snapShotString}    
                                                </div>
                                                <div class="sliderText">
                                                </div>
                                            </div>
                                        </div>
                                    </div>`;
                                $("#timelineTrack").append(stringMerged);
                            }
                        }
                        var durations = response.duration; // in seconds
                        if (durations && durations > 0) {
                            let container = $('#timeMarkers');
                            container.html(''); // clear existing

                            let interval = 10; // seconds
                            let totalMarkers = Math.floor(durations / interval);

                            if ((totalMarkers <= 0) && (durations > 0)) {

                            }

                            for (let i = 0; i <= totalMarkers; i++) {
                                let seconds = i * interval;

                                // Convert seconds to HH:MM:SS
                                let hrs = Math.floor(seconds / 3600).toString().padStart(2, '0');
                                let mins = Math.floor((seconds % 3600) / 60).toString().padStart(2,
                                    '0');
                                let secs = (seconds % 60).toString().padStart(2, '0');
                                let timeLabel = `${hrs}:${mins}:${secs}`;
                                let leftPos = (i * 110) +
                                    'px'; // Adjust this scale to match your video timeline width

                                container.append(
                                    `<span class="time-marker" style="left: ${leftPos}">${timeLabel}</span>`
                                );
                            }
                        }
                    }
                },
                error: function(xhr) {
                    console.error("Merge failed:", xhr.responseText);
                    alert("Failed to merge video.");
                },
                complete: function() {
                    btn.prop('disabled', false);
                    btn.html(btn_html);
                    $("#importVideo").modal('hide');
                }
            });
        });

        function updateSnapshots(snapshots) {
            const container = $(".snapshots");
            container.empty();
            snapshots.forEach(snapshot => {
                container.append(
                    `<img style="height:60px !important;width:37px;border:1px solid #fff;" src="${snapshot}" />`
                    );
            });
        }
    </script>
    <script>
        $(function() {
            $("#timelineTrack").sortable({
                items: ".timeline-tracks",
                handle: ".track-numbers, .track-controls", // allow dragging by these areas
                placeholder: "sortable-placeholder", // optional: for visual feedback
                tolerance: "pointer",
                axis: "y", // restrict to vertical movement
                cursor: "move",
                update: function(event, ui) {
                    const newOrder = [];

                    $(".timeline-tracks").each(function() {
                        const id = $(this).attr("data-id");
                        newOrder.push(id);
                    });
                    newOrder.forEach(function(id, index) {
                        const $el = $(`#imagePreviewRow [data-id="${id}"]`);
                        if ($el.length) {
                            // Higher index = lower in stacking order
                            $el.css("z-index", newOrder.length - index);
                        }
                    });

                }
            });
        });
        $(document).on('click', '.moveElementUp', function () {
            const $current = $(this).closest('.timeline-tracks');
            const $prev = $current.prev('.timeline-tracks');
            if ($prev.length) {
                $current.insertBefore($prev);
                updateZIndex();
            }
        });

        $(document).on('click', '.moveElementDown', function () {
            const $current = $(this).closest('.timeline-tracks');
            const $next = $current.next('.timeline-tracks');
            if ($next.length) {
                $current.insertAfter($next);
                updateZIndex();
            }
        });

        function updateZIndex() {
            const newOrder = [];
            $('.timeline-tracks').each(function () {
                const id = $(this).attr('data-id');
                newOrder.push(id);
            });

            newOrder.forEach(function (id, index) {
                const $el = $(`#imagePreviewRow [data-id="${id}"]`);
                if ($el.length) {
                    $el.css('z-index', newOrder.length - index);
                }
            });
        }
    </script>
</body>

</html>
