@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Cgi Categories') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Cgi Categories List') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <button class="btn bt-sm btn-primary" id="addCategoryBtn">Add</button>
                        </div>

                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Category</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$categories->isEmpty())
                                            @foreach ($categories as $category)
                                                <tr>
                                                    <td>
                                                        {{$category->category}}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary edit" data-category="{{$category->category}}" data-id="{{$category->id}}">Edit</button>
                                                        <button class="btn btn-sm btn-danger delete" data-id="{{$category->id}}">Danger</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Category</label>
                                <input type="text" name="category" id="category" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="addCat">Add Category</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="editCateoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <input type="hidden" id="edit_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Category</label>
                                <input type="text" name="category" id="edit_category" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="updateCat">Update Category</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });

        $(document).on('click', '#addCategoryBtn', function(){
            $("#addCategoryModal").modal('show');
        });

        $(document).on('click', '.delete', function() {
            var id = $(this).attr('data-id');
            var url = "{{ route('admin.cgi.categories.delete') }}";

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this template?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post(url, {
                        _token: "{{ csrf_token() }}",
                        id: id
                    }, function(response) {

                        if (response.result) {
                            Swal.fire(
                                'Deleted!',
                                'Templated deleted successfully.',
                                'success'
                            ).then(function() {
                                location.reload();
                            });
                        } else {
                            Swal.fire(
                                'Failed!',
                                response.msg || 'Failed to delete template.',
                                'error'
                            );
                        }
                    }).fail(function() {
                        // Handle any AJAX errors
                        Swal.fire(
                            'Error!',
                            'An error occurred while processing your request.',
                            'error'
                        );
                    });
                }
            });
        });
    </script>
    <script>
        $("#addCat").on('click', function(){

            var category = $("#category").val();
            if(!category)
            {
                Swal.fire({
                    title:"Error",
                    text:"Please enter category",
                    icon:"error"
                });
                return;   
            }

            var data = {category:category, _token:"{{csrf_token()}}"};
            var url = "{{route('admin.cgi.categories.store')}}";
            $.post(url, data, function(data){
                if(!data.result)
                {
                    var msg = "Some error occured";
                    if(data.msg)
                    {
                        msg = data.msg;   
                    }
                    error(msg);
                    return;
                }

                Swal.fire({
                    title:"Category Added",
                    text:"Category added successfully",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })

            }); 

        });


        $("#updateCat").on('click', function(){

            var id = $("#edit_id").val();
            var category = $("#edit_category").val();
            var data = {_token:"{{csrf_token()}}", category:category, id:id};
            var url = "{{route('admin.cgi.categories.update')}}";
            $.post(url, data, function(data){
                if(data.result)
                {
                    Swal.fire({
                        title:"Updated",
                        text:"Category Updated Successfully",
                        icon:"success"
                    }).then(function(){
                        location.reload();
                    })

                    return;
                }

                error("Some error occured");
            }).fail(function(){
                error("Some error occured");
            });

        });

        function error(msg)
        {
            Swal.fire({
                title:"Error",
                text:msg,
                icon:"error"
            });
        }

        $(document).on('click', '.edit', function(){
            var category = $(this).attr('data-category');
            var id = $(this).attr('data-id');
            $("#edit_id").val(id);
            $("#edit_category").val(category);
            $("#editCateoryModal").modal('show');
        });

    </script>
@endsection
