@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Add 3d Modal') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Add 3d Modal') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">3d Modal Name</label>
                                <input type="text" name="modal_name" id="modal_name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">3d Modal Object File</label>
                                <input type="file" name="object_file" id="object_file" class="form-control">
                            </div>
                        </div>
                       
                    </div>
                </div>
                <div class="card-footer" style="text-align: right;">
                    <button class="btn btn-md btn-primary" id="addModal">Add 3d Modal</button>
                </div>
            </div>
        </div>
    </div>


@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();
        });
    </script>
    <script>
    $(document).ready(function () {
        $("#addModal").click(function (e) {
            e.preventDefault(); // Prevent default button behavior

            let formData = new FormData();
            formData.append("modal_name", $("#modal_name").val());
            formData.append("object_file", $("#object_file")[0].files[0]); // File input
            var url = "{{route('cgi.add-modal')}}";
            
            $.ajax({
                url: url,  // Update this with your Laravel route
                type: "POST",
                data: formData,
                processData: false, // Prevent jQuery from processing data
                contentType: false, // Prevent jQuery from setting contentType
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") // Ensure CSRF protection
                },
                beforeSend: function () {
                    $("#addModal").prop("disabled", true).text("Uploading...");
                },
                success: function (response) {
                    alert(response.message);
                    $("#addModal").prop("disabled", false).text("Add 3D Model");
                    // Clear the form
                    $("#modal_name").val("");
                    $("#object_file").val("");
                },
                error: function (xhr) {
                    alert("Error uploading model: " + xhr.responseText);
                    $("#addModal").prop("disabled", false).text("Add 3D Model");
                }
            });
        });
    });
</script>
   
@endsection
