@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
   
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Video Templates') }}</div>
                        </div>
                       <div class="col-md-8" style="text-align: right">
                            <a href="{{route('video_template.add')}}" class="btn btn-md btn-primary">Add Video Template</a>
                       </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped">
                                    <thead>
                                        <th>
                                            Template
                                        </th>
                                        <th>
                                            Name
                                        </th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$templates->isEmpty())
                                            @foreach ($templates as $template)
                                                @php
                                                    
                                                    $images = $template->snapshots;
                                                    $imageUrl = "";
                                                    if($images)
                                                    {
                                                        $images = json_decode($images, true);
                                                        if(!empty($images))
                                                        {
                                                            $imageUrl = $images[0];
                                                        }
                                                    }
                                                @endphp
                                                <tr>
                                                    <td>
                                                        @if ($imageUrl)
                                                            <img src="{{$imageUrl}}" style="width:50px;">
                                                        @endif
                                                    </td>
                                                    <td>
                                                        {{$template->video_template}}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-md btn-danger removeTemplate" data-id="{{$template->id}}">Remove</button>
                                                    </td>
                                                </tr>                                                
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @if (!$templates->isEmpty())
                        
                    @endif
                    
                </div>
            </div>
        </div>
    </div>




@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
           var table = $("#dataTable").DataTable({
                order: [[0, "desc"]]
            });

        });

      
    </script>
    <script>
         $(document).on('click', '.removeTemplate', function() {
            var id = $(this).attr('data-id');
            var url = "{{ route('admin.cgi.removeVideoTemplate') }}";

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this template?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post(url, {
                        _token: "{{ csrf_token() }}",
                        id: id
                    }, function(response) {

                        if (response.result) {
                            Swal.fire(
                                'Deleted!',
                                'Templated deleted successfully.',
                                'success'
                            ).then(function() {
                                location.reload();
                            });
                        } else {
                            Swal.fire(
                                'Failed!',
                                response.msg || 'Failed to delete template.',
                                'error'
                            );
                        }
                    }).fail(function() {
                        // Handle any AJAX errors
                        Swal.fire(
                            'Error!',
                            'An error occurred while processing your request.',
                            'error'
                        );
                    });
                }
            });
        });
    </script>
  
@endsection
