@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Contact us') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Contact us') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Type</th>
                                        <th>Messages</th>
                                    </thead>
                                    <tbody>
                                        @if (!$messages->isEmpty())
                                            @foreach ($messages as $message)
                                                <tr>
                                                    <td>
                                                        {{$message->name}}
                                                    </td>
                                                    <td>
                                                        {{$message->email}}
                                                    </td>
                                                    <td>
                                                        @php
                                                            $type = str_replace('_', ' ', $message->type);
                                                            $type = ucfirst($type);
                                                        @endphp
                                                        {{$type}}
                                                    </td>
                                                    <td>
                                                        {{$message->message}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>


@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
  
@endsection
