@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Currency Setting') }}</div>
                        </div>
                        <div class="col-lg-8" style="text-align:right;">
                            <button class="btn btn-md btn-primary" id="addCurrencyBtn">Add Currency</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Currency</th>
                                        <th>Symbol</th>
                                        <th>ISO</th>
                                        <th>Conversion Rate</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$currencies->isEmpty())
                                            @foreach ($currencies as $currency)
                                                <tr>
                                                    <td>
                                                        {{ $currency->name }}
                                                    </td>
                                                    <td>
                                                        {{ $currency->symbol }}
                                                    </td>
                                                    <td>
                                                        {{ $currency->iso }}
                                                    </td>
                                                    <td>
                                                        1$ ~ {{ $currency->iso }}{{ $currency->conversion_rate }}
                                                    </td>
                                                    <td>
                                                        @php
                                                            $statusText = "Active";
                                                            $statusClass = "success";
                                                            if($currency->status != "active")
                                                            {
                                                                $statusText = "Inactive";
                                                                $statusClass = "danger";
                                                            }
                                                        @endphp
                                                        <button data-id="{{$currency->id}}" data-status="{{$currency->status}}" class="btn btn-sm change_status btn-{{$statusClass}}">
                                                            {{$statusText}}
                                                        </button>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary edit"
                                                            data-id="{{ $currency->id }}" data-iso="{{ $currency->iso }}"
                                                            data-conversion="{{ $currency->conversion_rate }}"
                                                            data-name="{{ $currency->name }}"
                                                            data-symbol="{{ $currency->symbol }}">
                                                            Edit
                                                        </button>
                                                        <button class="btn btn-sm btn-danger remove"
                                                            data-id="{{ $currency->id }}">
                                                            Delete
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="currencyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Currency</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Currency Name</label>
                                <input type="text" name="currency_name" id="currency_name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Currency ISO</label>
                                <input type="text" name="iso" id="iso" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Currency Symbol</label>
                                <input type="text" name="symbol" id="symbol" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Conversion Rate ($)</label>
                                <input type="text" name="conversion_rate" id="conversion_rate" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="addBtn">Add Currency</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="currencyEditModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Currency</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Currency Name</label>
                                <input type="text" name="currency_name" id="edit_currency_name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Currency ISO</label>
                                <input type="text" name="iso" id="edit_iso" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Currency Symbol</label>
                                <input type="text" name="symbol" id="edit_symbol" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Conversion Rate ($)</label>
                                <input type="text" name="conversion_rate" id="edit_conversion_rate"
                                    class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="update_id" id="update_id">
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updateBtn">Update</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addCurrencyBtn").on('click', function() {
            $("#currencyModal").modal('show');
        });
    </script>
    <script>
        $("#addBtn").on('click', function() {
            var currencyName = $("#currency_name").val();
            var iso = $("#iso").val();
            var symbol = $("#symbol").val();
            var conversionRate = $("#conversion_rate").val();

            if (!currencyName) {
                error("Please enter currency name");
                return;
            }

            if (!iso) {
                error("Please enter iso for your currency");
                return;
            }
            if (!symbol) {
                error("Please enter symbol for your currency");
                return;
            }

            if (!conversionRate) {
                error("Please enter conversion rate")
                return;
            }

            var data = {
                name: currencyName,
                iso: iso,
                symbol: symbol,
                rate: conversionRate,
                _token: "{{ csrf_token() }}"
            };
            var url = "{{ route('admin.currency.add') }}";
            $.post(url, data, function(data) {
                if (data.result) {
                    Swal.fire({
                        title: "Success",
                        text: "Currency added successfully",
                        icon: "success"
                    }).then(function() {
                        location.reload();
                    })

                    return;
                }
                Swal.fire({
                    title: "Error",
                    text: "Some error occured",
                    icon: "error"
                })


            }).fail(function() {
                Swal.fire({
                    title: "Error",
                    text: "Some error occured",
                    icon: "error"
                })

                return;
            })
        });

        function error(msg) {
            Swal.fire({
                title: "Error",
                text: msg,
                icon: "error"
            })
        }
    </script>
    <script>

        $(document).on('click', '.change_status', function(){
            var id = $(this).attr('data-id');
            var status = $(this).attr('data-status');
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            var changeStatus = "inactive";
            if(status == "inactive")
            {
                changeStatus = "active";
            }

            var newStatus = changeStatus.charAt(0).toUpperCase() + changeStatus.slice(1);

            var url = "{{route('admin.currency.update_status')}}";
            var data = {id:id, status:changeStatus, _token:"{{csrf_token()}}"}
            $.post(url, data, function(data){
                location.reload();
            }).fail(function(){
                btn.html(btn_html);
                error("Some erro occured");
            });

        });

        $(document).on('click', '.remove', function() {
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to remove this currency',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, remove it!',
                cancelButtonText: 'No, keep it',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = "{{ route('admin.currency.delete') }}";
                    var data = {
                        id: id,
                        _token: '<?= csrf_token() ?>'
                    };
                    $.post(url, data, function(data) {
                        if (data.result) {
                            Swal.fire({
                                title: "Deleted Successfully",
                                text: "Currency Deleted Successfully",
                                icon: "success"
                            }).then(function() {
                                location.reload();
                            })
                        } else {
                            error("Some error occured");
                        }
                    }).fail(function() {
                        error("Some error occured");
                        return;
                    })
                }
            })
        });
    </script>
    <script>
        $(document).on('click', '.edit', function() {
            var id = $(this).attr('data-id');
            var iso = $(this).attr('data-iso');
            var symbol = $(this).attr('data-symbol');
            var conversion = $(this).attr('data-conversion');
            var name = $(this).attr('data-name');
            $("#edit_currency_name").val(name);
            $("#edit_iso").val(iso);
            $("#edit_symbol").val(symbol);
            $("#edit_conversion_rate").val(conversion);
            $("#update_id").val(id);
            $("#currencyEditModal").modal('show');


        });
        $("#updateBtn").on('click', function() {
            var currencyName = $("#edit_currency_name").val();
            var iso = $("#edit_iso").val();
            var symbol = $("#edit_symbol").val();
            var conversionRate = $("#edit_conversion_rate").val();
            var id = $("#update_id").val();
            if (!currencyName) {
                error("Please enter currency name");
                return;
            }

            if (!iso) {
                error("Please enter iso for your currency");
                return;
            }
            if (!symbol) {
                error("Please enter symbol for your currency");
                return;
            }

            if (!conversionRate) {
                error("Please enter conversion rate")
                return;
            }

            var data = {
                name: currencyName,
                iso: iso,
                symbol: symbol,
                rate: conversionRate,
                _token: "{{ csrf_token() }}",
                id: id
            };
            var url = "{{ route('admin.currency.update') }}";
            $.post(url, data, function(data) {
                if (data.result) {
                    Swal.fire({
                        title: "Success",
                        text: "Currency added successfully",
                        icon: "success"
                    }).then(function() {
                        location.reload();
                    })

                    return;
                }
                Swal.fire({
                    title: "Error",
                    text: "Some error occured",
                    icon: "error"
                })


            }).fail(function() {
                Swal.fire({
                    title: "Error",
                    text: "Some error occured",
                    icon: "error"
                })

                return;
            })
        });
    </script>
@endsection
