@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Domains List') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="">{{ __('Domains List') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Domains Lists') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if ($domains->isEmpty())
                        <div class="alert alert-danger">
                            You dont have any domain active
                        </div>
                    @else
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover table-stripped" id="dataTable">
                                        <thead>
                                            <th>Domain</th>
                                            <th>Purchased On</th>
                                            <th>Expires</th>
                                            <th>User</th>
                                            <th>Price</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($domains as $domain)
                                            @php
                                                $user = "<span class='badge bg-danger text-white'>Not Found</span>";
                                                $gUser = DB::table('users')->where('id', $domain->user_id)->first();
                                                if(!empty($gUser))
                                                {
                                                    $user = $gUser->email;
                                                }

                                            @endphp
                                                <tr>
                                                    <td data-domain="{{ $domain->domain }}" data-id="{{ $domain->id }}">
                                                        {{ $domain->domain }}
                                                    </td>
                                                    <td id="purchased_<?= $domain->id ?>"></td>
                                                    <td id="expired_<?= $domain->id ?>"></td>
                                                    <td>
                                                        {!! $user !!}
                                                    </td>
                                                    <td>
                                                        {{currency_symbol()}}{{$domain->price}}
                                                    </td>
                                                    <td>
                                                        <a href="<?=url('domains/dns/'.$domain->id); ?>" class="btn btn-sm btn-primary">Change DNS</a>
                                                        <button class="btn btn-sm btn-secondary getNameServers"
                                                            data-domain="{{ $domain->domain }}">Change Nameservers</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif


                </div>
            </div>
        </div>
    </div>

    <div id="errorbox"
        style="text-shadow: 1px 1px #999;border-radius:10px;position:fixed;top:80px;right:10px;width:300px;background-color:red;padding:20px; opacity: 0.8;color:#FFF;display:none;">
    </div>


    <div class="modal fade" id="nameServerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Name Servers</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">NS1</label>
                                <input type="text" name="ns1" id="ns1" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">NS2</label>
                                <input type="text" name="ns1" id="ns2" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updateNameServers">Update</button>
                </div>
            </div>
        </div>
    </div>

    <input type="hidden" name="domain" id="nsdomain">
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();

            // Loop over each row in the DataTable
            table.rows().every(function() {
                var row = this.node(); // Get the DOM node for the row
                var firstTd = $(row).find('td:first');
                var id = firstTd.attr('data-id');
                var domain = firstTd.attr('data-domain');
                var getDomainInfo = '<?= url('domains/info') ?>';
                var data = {
                    _token: '<?= csrf_token() ?>',
                    domain: domain
                };
                $.post(getDomainInfo, data, function(data) {

                    if (!data.result) {
                        $("#purchased_" + id).html(
                            '<span class="badge bg-danger text-white">Error</span>');
                        $("#expired_" + id).html(
                            '<span class="badge bg-danger text-white">Error</span>');
                        return;
                    }

                    $("#purchased_" + id).html(data.created);
                    $("#expired_" + id).html(data.expires);


                })

            });
        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
@endsection
