@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Ecommerce Extra Sections') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="">
                    <i class="flaticon-home"></i>
                </a>
            </li>
        </ul>
    </div>
     <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="">Section</label>
                                <select name="sections" id="extraSection" class="form-control">
                                    <option value="0">Select Section</option>
                                    @if (!empty($extraSections))
                                        @foreach ($extraSections as $section)
                                            <option value="{{$section}}">
                                                {{ucfirst(str_replace('_', ' ', $section))}}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="">Best For</label>
                                <select name="sections" id="best_for" class="form-control">
                                    <option value="0">Select...</option>
                                    <option value="featured_products">Featured Products</option>
                                    <option value="latest_products">Latest Products</option>
                                    <option value="trending_products">Trending Products</option>
                                    <option value="product_details_page">Product Details Page</option>
                                    <option value="widgets">Widgets</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-md btn-primary" id="addExtraSection" style="margin-top:35px;">Add Section</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
     </div>
    

  
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
   <script>
    $("#addExtraSection").on('click', function(){
        var section = $("#extraSection").val();
        var bestFor = $("#best_for").val();

        if(section == "0")
        {
            Swal.fire({
                title:"Error",
                text:"Please select section",
                icon:"error"
            })   
            return;
        }

        if(bestFor == "0")
        {
            Swal.fire({
                title:"Error",
                text:"Please select best for",
                icon:"error"
            })   
            return;
        }

        var data = {_token:"{{csrf_token()}}", section:section, best_for:bestFor};
      
        var url = "{{route('ecommerce.addExtraSection')}}";
        $.post(url, data, function(data){

            if(!data.result)
            {
                var msg = data.msg;
                if(!msg)
                {
                    msg = "Some error occured";
                }   
                Swal.fire({
                    title:"Error",
                    text:msg,
                    icon:"error"
                })
                return;   
            }

            Swal.fire({
                title:"Success",
                text:"Section added successfully",
                icon:"success"
            }).then(function(){
                location.reload();
            })


        }).fail(function(){
            Swal.fire({
                title:"Error",
                text:"Some error occured",
                icon:"error"
            })
        })
    });
   </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    
   
@endsection
