@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        .svg_img_tag {
            height: 100px;
        }

        #appendShapes {
            height: 500px;
            overflow: scroll;
            overflow-x: hidden;
        }

        #backgroundOptions {
            height: 500px;
            overflow: scroll;
            overflow-x: hidden;
        }

        td {
            white-space: nowrap;
        }

        #templateOptions {
            min-height: 700px;
            border-radius: 5px;
        }

        #leftOptionEditor {
            width: 100%;
            list-style-type: none;
            text-align: center;
        }

        #leftOptionEditor li {
            list-style-type: none;
        }

        .options:hover {
            background-color: azure;
        }

        .options {
            padding-top: 20px;
        }

        #appendOptions .card {
            min-height: 400px;
            max-width: 350px;
        }

        #appendOptions {
            position: absolute;
            top: 140px;
            left: 170px;
            width: 350px;
        }

        #appendOptions .card {
            border-radius: 20px;
        }

        #addTextBtn {
            width: 100%;
        }

        .hide {
            display: none;
        }

        .closeOption {
            text-align: right;
            float: right;
            border-radius: 100px;
            width: 25px;
            height: 25px;
            text-align: center;
            background-color: transparent !important;
            color: black;
            margin-bottom: 10px;
        }

        #addHeading,
        #addSubHeading,
        #addParagraph {
            text-align: center;
            border: 1px solid #999;
            margin-top: 10px;
            padding-top: 10px;
            padding-bottom: 10px;
            cursor: pointer;
        }

        .svg_background {
            cursor: pointer;
        }

        .svg_background:hover {
            border: 1px solid #999;
        }
        .template_image
        {
            height: 50px;object-fit: cover
        }
    </style>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:wght@400&family=Open+Sans:wght@400&family=Lato:wght@400&display=swap"
        rel="stylesheet">
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Image Template') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="">{{ __('Image Template') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-stripped" style="width:100%;">
                            <thead>
                                <th>
                                    Template
                                </th>
                                <th>
                                    Template Type
                                </th>
                                <th>
                                    Template
                                </th>
                                <th>
                                    Image
                                </th>
                                <th>
                                    Size
                                </th>
                                <th>
                                    Action
                                </th>
                            </thead>
                            <tbody>
                                @if (!$templates->isEmpty())
                                    @foreach ($templates as $template)
                                        <tr>
                                            <td>
                                                <img class="template_image" src="{{asset($template->image_path)}}" alt="" srcset="">
                                            </td>
                                            <td>
                                                {{ucfirst($template->template_type)}}
                                            </td>
                                            <td>
                                                {{$template->template->template_name}}
                                            </td>
                                            <td>
                                                {{$template->image_template}}
                                            </td>
                                            <td>
                                                {{$template->width}}px x {{$template->height}}px
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-danger delete" data-id="{{$template->id}}">Delete</button>
                                                <button class="btn btn-sm btn-warning edit" data-id="{{$template->id}}">Edit</button>
                                    
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
         $(document).on('click', '.delete', function(){
            var id = $(this).attr('data-id');
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'><i>");
             Swal.fire({
                title: "Are you sure?",
                text: "Do you want to delete this template?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = "{{route('admin.image_template.delete')}}";
                    var data = {_token:'{{csrf_token()}}', id:id};
                    $.post(url, data, function(data){
                        if(data.result)
                        {
                            Swal.fire({
                                title:"Template Deleted",
                                text:"Template Deleted Successfully",
                                icon:"success"
                            }).then(function(){

                                   btn.closest('tr').remove();

                            })   

                            return;
                        }
                    });
                }else{

                    btn.html(btn_html);
                }
            });
        })
    </script>
    <script>
        $(document).on('click', '.edit', function(){
            var id = $(this).attr('data-id');
            var url = "{{route('admin.image_template.edit', ['id'=>'__ID__'])}}".replace('__ID__', id);
            location.href = url;
        });
    </script>
@endsection