<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<title>Invoice - {{$data['be']->from_name}}</title>

		<style>
			.invoice-box {
				max-width: 800px;
				margin: auto;
				padding: 20px;
				/*border: 1px solid #eee;*/
				box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
				font-size: 16px;
				line-height: 24px;
				font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
				color: #555;
			}

			.invoice-box table {
				width: 100%;
				line-height: inherit;
				text-align: left;
			}

			.invoice-box table td {
				padding: 5px;
				vertical-align: top;
			}

			.invoice-box table tr td:nth-child(2) {
				text-align: right;
			}

			.invoice-box table tr.top table td {
				padding-bottom: 10px;
			}

			.invoice-box table tr.top table td.title {
				font-size: 45px;
				line-height: 45px;
				color: #333;
			}

			.invoice-box table tr.information table td {
				padding-bottom: 10px;
			}

			.invoice-box table tr.heading td {
				background: #eee;
				border-bottom: 1px solid #ddd;
				font-weight: bold;
			}

			.invoice-box table tr.details td {
				padding-bottom: 10px;
			}

			.invoice-box table tr.item td {
				border-bottom: 1px solid #eee;
			}

			.invoice-box table tr.item.last td {
				border-bottom: none;
			}

			.invoice-box table tr.total td:nth-child(5) {
				/*border-top: 2px solid #eee;*/
				text-align: right;
				/*font-weight: bold;*/
			}
			.product td:nth-child(4) { 
				text-align: right !important; 
			}
			.invoice-box table tr.total td:nth-child(2) {
				text-align: left !important;
			}

			@media only screen and (max-width: 600px) {
				.invoice-box table tr.top table td {
					width: 100%;
					display: block;
					text-align: center;
				}

				.invoice-box table tr.information table td {
					width: 100%;
					display: block;
					text-align: center;
				}
			}

			/** RTL **/
			.invoice-box.rtl {
				direction: rtl;
				font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
			}

			.invoice-box.rtl table {
				text-align: right;
			}

			.invoice-box.rtl table tr td:nth-child(2) {
				text-align: left;
			}
			.bottom-bar { 
                display: flex;
                justify-content: space-between;
            } 
            .inv-itm-lst tr td:nth-child(3) {
				text-align: right;
			}
			.inv-itm-lst tr td:nth-child(2) {
				text-align: left !important;
			}
			.total-amount {
			    text-align: right;
			    font-weight: bold;
			    border-bottom: 1px solid #eee;
			}
			.total-amount-left {
			    border-left: 1px solid #eee;
			}
			.total-amount-right {
			    border-right: 1px solid #eee;
			}
			.domain td:nth-child(3) {
				text-align: right;
			}
    </style>
	</head>

	<body>
		<div class="invoice-box">
			<table cellpadding="0" cellspacing="0">
				<tr class="top">
					<td colspan="2">
						<table>
							<tr>
								<td class="title">
									<img src="https://goafli.in/assets/front/img/62eade4b17326.png" style="width: 80px; max-width: 80px" />
								</td>

								<td>
									Invoice ID#: {{$data['order_id']}}<br />
									Transaction ID #: {{$data['trans']}}<br />
									Payment Date: {{$data['date']}} {{$data['time']}}<br /> 
								</td>
							</tr>
						</table>
					</td>
				</tr>
                
                <tr class="total">
					<td colspan="2">
						<div style="border-top: dotted 1px; margin-top: 5px;  "> </div>
					</td>
				</tr>
				
				<tr class="information">
					<td colspan="2" class="item-table">
						<table >
							<tr>
								<td style="width:33%;">
									<b>{{$data['bs']->website_title}}, Inc.</b><br />
									{{$data['bs']->address}}, {{$data['bs']->city}},
									{{$data['bs']->state}}, {{$data['bs']->country}}, {{$data['bs']->zip}}.<br />
									{{$data['bs']->email}}
								</td>

								<td>
								    @if(isset($data['address']) && $data['address']->id)
								        <b>{{$data['address']->first_name}} {{$data['address']->last_name}}.</b><br />
								        {{$data['address']->address}}, {{$data['address']->city}},<br />
								        {{$data['address']->state}}, {{$data['address']->country}}, {{$data['address']->zip}}.<br />
								        +91-{{$data['address']->phone}}<br />
    									{{$data['address']->email}}
								    @else
    									<b>{{$data['user']->first_name}} {{$data['user']->last_name}}.</b><br />
    									{{$data['user']->phone}}<br />
    									{{$data['user']->email}}<br />
    									KOLKATA700017, West Bengal,<br /> India
    							    @endif
								</td>
							</tr>
						</table>
					</td>
				</tr>
                
                <tr class="total">
					<td colspan="2">
					    @if(isset($data['package']) && isset($data['package']->id))
					    <table class="">
							<tr class="heading product">
								<td>Product</td> 
								<td>Package</td>
								<td>Term</td>
            					<td>Amount</td>
							</tr>
							<tr class="item product">
            					<td>{{$data['item']->title}}</td> 
            					<td>@if(isset($data['package']->title)){{$data['package']->title}}@endif</td>
								<td>@if(isset($data['package']->term))
								          @if($data['package']->term == 'monthly')
                                            Monthly
                                          @elseif($data['package']->term == 'yearly')
                                            Yearly
                                          @elseif($data['package']->term == 'lifetime')
                                            Onetime
                                          @endif
								    @endif
								</td>
            					<td>@if(isset($data['package']->price))<span style="font-family: DejaVu Sans; sans-serif;">&#8377;</span>{{$data['package']->price}}@endif </td>
            				</tr>
            			</table>
            			@endif
            			@if(isset($data['domains']) && isset($data['domains']->id))
            			<table>
                            <tr class="heading domain">
                                <td>Domain</td>
                                <td>Term</td>
                                <td>Amount</td>
                            </tr>
                            <tr class="item domain">
                                <td>{{$data['domains']->name}}</td>
                                <td>{{$data['domains']->years}} year</td>
                                <td><span style="font-family: DejaVu Sans; sans-serif;">&#8377;</span>{{$data['domains']->price}}</td>
                            </tr> 
                        </table>
            			@endif
            			@if(isset($data['ssls']) && count($data['ssls']))
            			<table>
                            <tr class="heading domain">
                                <td>SSL</td>
                                <td>Term</td>
                                <td>Amount</td>
                            </tr>
                            @foreach ($data['ssls'] as $key => $ssl)
                            <tr class="item domain">
                                <td>{{$ssl->name}}</td>
                                <td>{{$ssl->years}} year</td>
                                <td><span style="font-family: DejaVu Sans; sans-serif;">&#8377;</span>{{$ssl->price}}</td>
                            </tr>
                            @endforeach
                        </table>
            			@endif
            			@if(isset($data['addons']) && count($data['addons']))
            			<table>
                            <tr class="heading">
                                <td>Addon</td>
                                <td>Term</td>
                                <td>Amount</td>
                                <td>Quantity</td>
                                <td>Amount</td>
                            </tr>
                            @foreach ($data['addons'] as $key => $addon)
                            <tr class="item">
                                <td>{{$addon->title}}</td>
                                <td>
                                      @if($addon->term == 'monthly')
                                        Monthly
                                      @elseif($addon->term == 'yearly')
                                        Yearly
                                      @elseif($addon->term == 'lifetime')
                                        Onetime
                                      @endif
                                </td>
                                <td><span style="font-family: DejaVu Sans; sans-serif;">&#8377;</span>{{$addon->price}}</td>
                                <td>{{$addon->quantity}}</td>
                                <td><span style="font-family: DejaVu Sans; sans-serif;">&#8377;</span>{{$addon->price*$addon->quantity}}</td>
                            </tr> 
                            @endforeach
                        </table>
                        @endif 
            			<table>
            				<tr class="total">
            					<td></td> 
            					<td></td> 
            					<td></td> 
            					<td class="total-amount total-amount-left">Total:</td> 
            					<td class="total-amount total-amount-right"><span style="font-family: DejaVu Sans; sans-serif;">&#8377;</span>{{$data['order_price']}}</td>
            				</tr>
						</table>	  
					</td>
				</tr> 
				 
				<tr class="total">
					<td colspan="2">
						<p><b>NOTE: </b>Your transaction was successful! We advise to keep this invoice for future reference.</p><br>
					</td>
				</tr>
				 
				<tr class="total">
					<td colspan="2">
						 <br>
					</td>
				</tr>
				
				<tr class="total">
					<td colspan="2">
						<div style="border-top: dotted 1px; margin-top: 5px;  "> </div><br>
					</td>
				</tr>
				
				<tr class="top">
					<td colspan="2">
					   <table>
                        <tr>
                            <td>
                                <center>www.goafli.in</center>
                            </td>
                            <td>
                                <center>{{$data['be']->contact_numbers}}</center>
                            </td>
                            <td>
                                <center>{{$data['be']->contact_mails}}</center>
                            </td>
                        </tr>
                    </table>
				    </td>
				</tr>    
			</table>
		</div>
	</body>
</html>