@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Transactions') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Transactions') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Transaction ID</th>
                                        <th>User</th>
                                        <th>Description</th>
                                        <th>Amount</th>
                                        <th>Invoice</th>
                                    </thead>
                                    @if (!$transactions->isEmpty())
                                        @foreach ($transactions as $transaction)
                                            <tr>
                                                <td>
                                                    {{$transaction->transaction_id}}
                                                </td>
                                                <td>
                                                    {{$transaction->user}}
                                                </td>
                                                <td>
                                                    {{$transaction->description}}
                                                </td>
                                                <td>
                                                    ${{$transaction->amount}}
                                                </td>
                                                <td>
                                                    <a target="_blank" href="{{$transaction->invoice_url}}">
                                                        <i class="fa fa-file" style="font-size:22px;"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addFbAccountBtn").on('click', function() {
            $("#ftpModal").modal('show');
        });
    </script>
    <script>
        $(document).on('click', '.assign_project', function(){
            var id = $(this).attr('data-id');
            $("#ftp_id").val(id);
            $("#ftpAssignProject").modal('show')
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#add_ftp_btn').on('click', function() {
                // Get values of all input fields
                let host = $('#host').val().trim();
                let username = $('#username').val().trim();
                let ftpPassword = $('#ftp_password').val().trim();
                let port = $('#port').val().trim();
                if (!host || !username || !ftpPassword || !port) {
                    // Show error message using Swal
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Please fill out all fields.',
                        confirmButtonText: 'OK'
                    });
                } else {
                    var btn = $(this);
                    var btn_html = btn.html();
                    btn.html("<i class='fa fa-spinner fa-spin'></i>");
                    var data = {
                        host: host,
                        username: username,
                        password: ftpPassword,
                        port: port,
                        _token: '<?= csrf_token() ?>'
                    };

                    var url = '<?= url('admin/ftp/add') ?>';
                    $.post(url, data)
                        .done(function(response) {
                            console.log(response);
                            btn.html(btn_html);
                            Swal.fire({
                                icon: 'success',
                                title: 'Success',
                                text: response.message,
                                confirmButtonText: 'OK'
                            }).then(function(){
                                location.reload()
                            });
                        })
                        .fail(function(jqXHR) {
                            // Show the error message returned from the server
                            let errorMessage = jqXHR.responseJSON && jqXHR.responseJSON.message ?
                                jqXHR.responseJSON.message :
                                'An unexpected error occurred. Please try again later.';
                            btn.html(btn_html);
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: errorMessage,
                                confirmButtonText: 'OK'
                            });
                        });

                }
            });
        });
    </script>
    <script>
        $(document).on('click', '.remove_ftp', function() {
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to remove this FTP credential!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, remove it!',
                cancelButtonText: 'No, keep it',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = '<?=url('admin/ftp/remove'); ?>';
                    var data = {id:id, _token:'<?=csrf_token(); ?>'};
                    $.post(url, data, function(data){
                        if(data.result)
                        {
                            Swal.fire({
                                title:"Deleted Successfully",
                                text:"Ftp Account Deleted Successfully",
                                icon:"success"
                            }).then(function(){
                                location.reload();
                            })
                        }
                    })
                }
            })
        });
    </script>
    <script>
        $("#assign_project").on('click', function(){
            var ftpId = $("#ftp_id").val();
            var project = $("#project").find(':selected').val();
            var data = {id:ftpId, _token:'<?=csrf_token(); ?>', project:project};
            var url = '<?=url('admin/ftp/assign'); ?>';
            $.post(url, data, function(data){
                Swal.fire({
                    title:"Ftp Assigned",
                    text:"Ftp Assigned To project successfully",
                    icon:"success"
                }).then(function(){
                    location.reload()
                })
            })
        });
    </script>
@endsection
