@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('User List') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('domain.index') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('domain.index') }}">{{ __('User List') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('User Lists') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                 
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover table-stripped" id="dataTable">
                                        <thead>
                                            <th>Email</th>
                                            <th>Wallet</th>
                                            <th>Add Balance</th>
                                            <th>Whatsapp</th>
                                            <th>Last Login Ip</th>
                                            <th>Last Login Time</th>
                                            <th>Account Creation Date</th>
                                            <th>Last Login Agent</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($users as $user)
                                                <tr>
                                                    <td>
                                                        {{$user->email}}
                                                    </td>
                                                    <td>
                                                        AED {{$user->walletbalance}}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary add_balance" data-id="{{$user->id}}">Add Balance</button>
                                                    </td>
                                                    <td>
                                                        @if ($user->whatsapp)
                                                            {{$user->whatsapp}}
                                                        @else
                                                            No Whatsapp Added
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if ($user->lastLogin && $user->lastLogin->ip_address)
                                                            {{$user->lastLogin->ip_address}}
                                                        @else
                                                            Not Found
                                                        @endif
                                                    </td>
                                                    <td data-order="{{ $user->lastLogin && $user->lastLogin->login_at ? strtotime($user->lastLogin->login_at) : strtotime($user->created_at) }}">
                                                        @if ($user->lastLogin && $user->lastLogin->login_at)
                                                            {{ date('d F Y H:i', strtotime($user->lastLogin->login_at)) }}
                                                        @else
                                                            Not Found
                                                        @endif
                                                    </td>

                                                    <td data-order="{{ strtotime($user->created_at) }}">
                                                        {{date('d F Y H:i', strtotime($user->created_at))}}
                                                    </td>
                                                    <td style="width:50px;">
                                                        
                                                        @if ($user->lastLogin && $user->lastLogin->user_agent)
                                                            {{$user->lastLogin->user_agent}}
                                                        @else
                                                            Not Found
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
      


                </div>
            </div>
        </div>
    </div>

    <div id="errorbox"
        style="text-shadow: 1px 1px #999;border-radius:10px;position:fixed;top:80px;right:10px;width:300px;background-color:red;padding:20px; opacity: 0.8;color:#FFF;display:none;">
    </div>


    <div class="modal fade" id="nameServerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Name Servers</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">NS1</label>
                                <input type="text" name="ns1" id="ns1" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">NS2</label>
                                <input type="text" name="ns1" id="ns2" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updateNameServers">Update</button>
                </div>
            </div>
        </div>
    </div>

     <div class="modal fade" id="userBalanceModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update User Balance</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Amount</label>
                                <input type="text" name="amount" id="balanceAmount" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updateUserBalance">Update</button>
                </div>
            </div>
        </div>
    </div>

    <input type="hidden" name="domain" id="nsdomain">
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable({
                order: [[3, "asc"]], 
            });
        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $(document).on('click', '.add_balance', function(){
            var userId = $(this).attr('data-id');
            $("#updateUserBalance").attr('data-id', userId);
            $("#userBalanceModal").modal('show');
        });

        $("#updateUserBalance").on('click', function(){
            var userId = $(this).attr('data-id');
            var amount = $("#balanceAmount").val();
            if(!userId)
            {
                Swal.fire({
                    title:"Error",
                    text:"Please select user",
                    icon:"error"
                })
                return;
            }

            if(!amount)
            {
                Swal.fire({
                    title:"Error",
                    text:"Please select amount",
                    icon:"error"
                })
                return;
            }
            var data = {userId:userId, amount:amount, _token:"{{csrf_token()}}"};
            var url = "{{route('admin.addBalance')}}";
            $.post(url, data, function(data){
                console.log(data);
                if(!data.result)
                {
                    Swal.fire({
                        title:"Error",
                        text:"Some error occured",
                        icon:"error"
                    })
                    return;
                } 
                Swal.fire({
                    title:"Success",
                    text:"Balance added",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })
            });
        });

    </script>
@endsection
