@extends('user.layout2')



@section('title', 'Dashboard')

@section('content_header')
    <h1>
        Dashboard</h1>
@stop

@section('content')
    <style>
        h3 {

            font-size: 24px;

            line-height: 34px;

        }

        .content-between {

            display: flex;

            justify-content: space-between;

        }



        .content-between div {}

        .addon-price {

            display: inline-flex;

        }

        .addon-price h1 {

            color: #000;

            font-size: 26px;

        }

        .addon-price span {

            margin-top: 15px
        }



        .container .card-title {

            color: #000;

            font-size: 16px;

            font-weight: revert;

        }

        .container .card-footer {

            text-align: center;

        }

        .feature svg {

            height: 15px;

            opacity: .5;

        }

        .feature-active svg {

            height: 15px;

            opacity: 1;



        }

        .feature-active {

            color: #000;

        }

        @media (min-width: 768px) {

            .container {

                max-width: unset;

            }

        }





        @media (min-width: 576px) {

            .container {

                max-width: unset;

            }

        }

        .container .col-sm-3 {

            display: flex;

            margin-bottom: 20px;

        }

        .container .card {

            width: 100%;

        }

        @media (min-width: 576px) {

            .container {

                max-width: 840px;

            }

        }





        @media (min-width: 768px) {

            .container {

                max-width: 950px;

            }

        }

        @media only screen and (min-width: 1200px) and (max-width: 1873px) {

            .container {

                max-width: 1200px;

            }

        }

        .saas-pricing .pricing-item .pricing-button {

            display: flex;

            justify-content: center;

        }

        .saas-pricing .pricing-item .pricing-button form {

            margin: 5px;

        }

        .saas-pricing .pricing-item .pricing-button form .trial {

            background: #28a745;

        }



        .new_domai_buy {

            display: flex;

            justify-content: space-between;

            margin-top: 10px;

        }

        #domainAvailable {

            display: unset;

        }

        #modaladdbillinginfo label {

            margin-bottom: 0;

        }

        .card {

            box-shadow: 0 0 8px 0 rgb(0 0 0 / 10%);



        }

        .card-header {

            background-color: #fff;

        }

        #order-details .card {

            border: unset;

        }

        .nav-link {

            padding: 0.5rem 0.5rem;

        }

        #order-details table {

            width: 100%;

        }

        #order-details .max-tbl-wth {

            max-width: 200px;

        }

        .border-bottom {

            border-bottom: 1px solid rgba(0, 0, 0, .125);

        }

        .new_domai_buy .right {

            text-align: right;

        }

        .sugg-ssl-name {

            font-size: x-large;

            color: #495057;

        }

        .ssl-regular-price {

            color: #000;

            font-size: small;

        }

        .ssl-regular-paice-amount {

            text-decoration: line-through;

        }

        @media only screen and (max-width: 600px) {

            .sugg-ssl-name {

                font-size: inherit;

            }

            .ssl-regular-paice-refix {

                display: none;

            }

        }



        .right {

            width: 100%;

        }

        .suggested-ssl-list {

            padding: 0.5rem;

        }

        .card-footer {

            background-color: unset;

        }
    </style>

    @if ($count > 0)



        <!--====== Start saas-pricing section ======-->

        <section class="saas-pricing pricing-page pt-110 pb-120" id=

    "pricing" style="display:none;">

            <div class="container">



                @if (count($terms) > 1)

                    <div class="row justify-content-center">

                        <div class="col-lg-4 text-center">

                            <div class="pricing-tabs text-center">

                                <ul class="nav nav-tabs">

                                    @foreach ($terms as $term)
                                        <li class="nav-item mr-1">

                                            <a class="nav-link {{ $loop->first ? 'active' : '' }}" data-toggle="tab"
                                                href="#{{ strtolower($term) }}">{{ __("$term") }}</a>

                                        </li>
                                    @endforeach

                                </ul>

                            </div>

                        </div>

                    </div>

                @endif



                <div class="pricing-wrapper tab-content">

                    @foreach ($terms as $term)
                        <div id="{{ strtolower($term) }}" class="tab-pane {{ $loop->first ? 'show active' : '' }} fade">

                            <div class="row no-gutters ">

                                @php

                                    $packages = \App\Models\Package::where('status', '1')
                                        ->where('term', strtolower($term))
                                        ->get();

                                @endphp

                                @foreach ($packages as $package)
                                    @php

                                        $pFeatures = json_decode($package->features);

                                    @endphp

                                    <div class="col-lg-4 col-md-6 col-sm-12">

                                        <div class="pricing-item">

                                            <div class="title">

                                                <h3>{{ $package->title }}</h3>

                                                <h2 class="price">
                                                    {{ $package->price != 0 && $be->base_currency_symbol_position == 'left' ? $be->base_currency_symbol : '' }}{{ $package->price == 0 ? 'Free' : $package->price }}{{ $package->price != 0 && $be->base_currency_symbol_position == 'right' ? $be->base_currency_symbol : '' }}<span
                                                        class="month">/ {{ __("$package->term") }}</span>

                                                </h2>

                                            </div>

                                            <div class="pricing-body">

                                                <ul class="list">

                                                    @foreach ($allPfeatures as $feature)
                                                        <li
                                                            class="{{ is_array($pFeatures) && in_array($feature, $pFeatures) ? 'checked' : 'unchecked' }}">

                                                            {{ __("$feature") }}

                                                            @if ($feature == 'Plugins')
                                                                ({{ __('Google Analytics, Disqus, WhatsApp, Facebook Pixel, Tawk.to') }})
                                                            @endif

                                                        </li>
                                                    @endforeach

                                                </ul>

                                            </div>

                                            <div class="pricing-button">



                                                <form action="{{ config('app.url') }}/addplan" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="user_id" value="<?php echo $userId = Auth::id(); ?>">

                                                    <input type="hidden" name="item_id" value="{{ $package->id }}">

                                                    <input type="hidden" name="status" value="0">

                                                    <center> <button type="submit" class="main-btn">Purchase</button>
                                                    </center>

                                                </form>

                                                @if ($package->is_trial)
                                                    <form action="{{ config('app.url') }}/start-trial" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="user_id" value="<?php echo $userId = Auth::id(); ?>">

                                                        <input type="hidden" name="plan" value="{{ $package->id }}">

                                                        <input type="hidden" name="item_id" value="{{ $package_item }}"
                                                            <center> <button type="submit" class="main-btn trial">Start
                                                            Trial</button></center>

                                                    </form>
                                                @endif



                                            </div>

                                        </div>

                                    </div>
                                @endforeach

                            </div>

                        </div>
                    @endforeach



                </div>



            </div>

        </section>



        <!--====== End saas-pricing section ======-->



        <!--====== Start saas_checkout ======-->

        <section id="cart" class="saas_checkout pb-110" style="display:none;">

            <div class="container">

                <div class="section_title mb-30">

                    <h3>
                        <center>{{ __('Choose Addons') }}</center>
                    </h3>

                </div>

                @if (count($package_addons) == 0)

                    <div class="card">

                        <div class="card-body">

                            <h3 class="text-center">{{ __('NO ADDON AVALABLE ON THIS PACKAGE') }}</h3>

                        </div>

                    </div>
                @else
                    <div class="row">

                        @foreach ($package_addons as $key => $addon)
                            <div class="col-sm-3">



                                <div class="card">

                                    <div class="card-header">

                                        <span class="addon-price">
                                            <h1>₹{{ $addon->price }}</h1><span>/@if ($addon->term == 'monthly')
                                                    Month
                                                @elseif($addon->term == 'yearly')
                                                    Year
                                                @else
                                                    Onetime
                                                @endif
                                            </span>
                                        </span>

                                        <h5 class="card-title">{{ $addon->title }}</h5>

                                        <p class="card-text">{{ $addon->meta_description }}</p>



                                    </div>

                                    <div class="card-body">

                                        @php

                                            $permissions = $addon->features;

                                            if (!empty($addon->features)) {
                                                $permissions = json_decode($permissions, true);
                                            }

                                            $list_features = $addon->all_features;

                                            if (!empty($addon->all_features)) {
                                                $list_features = json_decode($list_features, true);
                                            } else {
                                                $list_features = [];
                                            }

                                        @endphp

                                        @if (is_array($list_features) && count($list_features))
                                            @foreach ($list_features as $feature)
                                                @if (is_array($permissions) && in_array($feature, $permissions))
                                                    <p class="card-text  feature-active"><svg
                                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                            <path
                                                                d="M256 512c141.4 0 256-114.6 256-256S397.4 0 256 0S0 114.6 0 256S114.6 512 256 512zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z" />
                                                        </svg>&nbsp;{{ $feature }}</p>
                                                @else
                                                    <p class="card-text  feature">

                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                            <path
                                                                d="M256 512c141.4 0 256-114.6 256-256S397.4 0 256 0S0 114.6 0 256S114.6 512 256 512zM175 175c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z" />
                                                        </svg>&nbsp;{{ $feature }}
                                                    </p>
                                                @endif
                                            @endforeach
                                        @endif



                                    </div>

                                    <div class="card-footer text-muted">



                                        @if (is_array($addonids) && in_array($addon->id, $addonids))
                                            <a href="delcart/<?php echo $addon->id; ?>" class="btn btn-warning">Remove</a>
                                        @else
                                            @if ($addon->term == 'monthly')
                                                <button class="btn btn-info" data-toggle="modal"
                                                    data-target="#modaladdonBuyMinth{{ $addon->id }}">Add</button>

                                                <div class="modal fade" id="modaladdonBuyMinth{{ $addon->id }}"
                                                    tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
                                                    aria-hidden="true">

                                                    <div class="modal-dialog modal-dialog-centered" role="document">

                                                        <div class="modal-content">

                                                            <form action="{{ config('app.url') }}/addaddon" method="POST"
                                                                id="addad{{ $addon->id }}">

                                                                @csrf

                                                                <div class="modal-header">

                                                                    <h5 class="modal-title">Select Months</h5>

                                                                    <button type="button" class="close"
                                                                        data-dismiss="modal" aria-label="Close">

                                                                        <span aria-hidden="true">&times;</span>

                                                                    </button>

                                                                </div>

                                                                <div class="modal-body text-left">

                                                                    <input type="hidden" name="user_id"
                                                                        value="<?php echo $userId = Auth::id(); ?>">

                                                                    <input type="hidden" name="item_id"
                                                                        value="{{ $addon->id }}">

                                                                    <input type="hidden" name="status" value="0">

                                                                    <input type="hidden" name="type" value="1">

                                                                    <input type="hidden" name="plan"
                                                                        value="{{ $myplan }}">

                                                                    <select id="addon{{ $addon->id }}" name="cycle"
                                                                        class="form-control" required>

                                                                        <option value="" selected=""
                                                                            disabled="">Select a months</option>

                                                                        <option value="1">1</option>

                                                                        <option value="2">2</option>

                                                                        <option value="3">3</option>

                                                                        <option value="4">4</option>

                                                                        <option value="5">5</option>

                                                                        <option value="6">6</option>

                                                                        <option value="7">7</option>

                                                                        <option value="8">8</option>

                                                                        <option value="9">9</option>

                                                                        <option value="10">10</option>

                                                                        <option value="11">11</option>

                                                                        <option value="12">12</option>

                                                                    </select>

                                                                </div>

                                                                <div class="modal-footer">

                                                                    <button type="submit" class="btn btn-primary">Buy
                                                                        Now</button>

                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal"
                                                                        aria-label="Close">Close</button>

                                                                </div>

                                                            </form>

                                                        </div>

                                                    </div>

                                                </div>
                                            @elseif($addon->term == 'yearly')
                                                <button class="btn btn-info" data-toggle="modal"
                                                    data-target="#modaladdonBuyYear{{ $addon->id }}">Add</button>

                                                <div class="modal fade" id="modaladdonBuyYear{{ $addon->id }}"
                                                    tabindex="-1" role="dialog"
                                                    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

                                                    <div class="modal-dialog modal-dialog-centered" role="document">

                                                        <div class="modal-content">

                                                            <form action="{{ config('app.url') }}/addaddon"
                                                                method="POST" id="addad{{ $addon->id }}">

                                                                @csrf

                                                                <div class="modal-header">

                                                                    <h5 class="modal-title">Select Years</h5>

                                                                    <button type="button" class="close"
                                                                        data-dismiss="modal" aria-label="Close">

                                                                        <span aria-hidden="true">&times;</span>

                                                                    </button>

                                                                </div>

                                                                <div class="modal-body text-left">

                                                                    <input type="hidden" name="user_id"
                                                                        value="<?php echo $userId = Auth::id(); ?>">

                                                                    <input type="hidden" name="item_id"
                                                                        value="{{ $addon->id }}">

                                                                    <input type="hidden" name="status" value="0">

                                                                    <input type="hidden" name="type" value="1">

                                                                    <input type="hidden" name="plan"
                                                                        value="{{ $myplan }}">

                                                                    <select id="addon{{ $addon->id }}" name="cycle"
                                                                        class="form-control" required>

                                                                        <option value="" selected=""
                                                                            disabled="">Select a Years</option>

                                                                        <option value="1">1</option>

                                                                        <option value="2">2</option>

                                                                        <option value="3">3</option>

                                                                        <option value="4">4</option>

                                                                        <option value="5">5</option>

                                                                    </select>

                                                                </div>

                                                                <div class="modal-footer">

                                                                    <button type="submit" class="btn btn-primary">Buy
                                                                        Now</button>

                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal"
                                                                        aria-label="Close">Close</button>

                                                                </div>

                                                            </form>

                                                        </div>

                                                    </div>

                                                </div>
                                            @else
                                                <form action="{{ config('app.url') }}/addaddon" method="POST"
                                                    id="addad{{ $addon->id }}">

                                                    @csrf

                                                    <input type="hidden" name="user_id" value="<?php echo $userId = Auth::id(); ?>">

                                                    <input type="hidden" name="item_id" value="{{ $addon->id }}">

                                                    <input type="hidden" name="status" value="0">

                                                    <input type="hidden" name="type" value="1">

                                                    <input type="hidden" name="plan" value="{{ $myplan }}">

                                                    <input type="hidden" name="cycle" value="1">

                                                    <button class="btn btn-info" type="submit">Add</button>

                                                </form>
                                            @endif
                                        @endif



                                    </div>

                                </div>



                            </div>
                        @endforeach



                    </div>

            </div>

            <center>

                <a href="?step=details" class="main-btn mt-4">Check Out </a>

            </center>

    @endif

    </section>

    <section id="order-details" class="container mb-80">

        <div class="row">

            <div class="col-lg-12">

                <div class="card">

                    <div class="card-header">

                        <div class="section_title">

                            <h3>Add or buy a new domain</h3>

                        </div>

                    </div>

                    <div class="card-body">

                        <div class="billing_form">

                            <ul class="nav nav-pills" id="pills-tab" role="tablist">

                                <li class="nav-item" onclick="mydemo(0)">

                                    <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home"
                                        role="tab" aria-controls="pills-home" aria-selected="true">I Have a
                                        Domain</a>

                                </li>

                                <li class="nav-item" onclick="mydemo(0)">

                                    <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile"
                                        role="tab" aria-controls="pills-profile" aria-selected="false">I Want to Buy
                                        a Domain</a>

                                </li>
                                <li class="nav-item" onclick="mydemo(1)">

                                    <a class="nav-link" id="pills-demo-tab" data-toggle="pill" href="#pills-demo"
                                        role="tab" aria-controls="pills-demo" aria-selected="false">I Want to Try
                                        Demo</a>

                                </li>
                            </ul>

                            <div class="tab-content" id="pills-tabContent">

                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                    aria-labelledby="pills-home-tab">



                                    <div class="row">

                                        <div class="col-md-12">

                                            <div class="form_group">

                                                <span>Please enter your domain name*</span>
                                                <form style="display: flex;">
                                                    @csrf
                                                    <input type="text" name="domainss" id="domainss"
                                                        class="form_control" placeholder="Please Enter Your Domain Name"
                                                        <?php if(session()->get('domaint') != '' ){ ?> value="<?php echo session()->get('domaint'); ?>"
                                                        <?php } ?>>
                                                    <button type="button"
                                                        class="btn btn-success connectbutton">Connect</button>
                                                    <button type="button" class="btn btn-danger removebutton"
                                                        style="display:none">Remove</button>
                                                </form>
                                                <p class="messageshowerr" style="color:red"></p>
                                            </div>
                                            <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
                                            <script>
                                                $(document).ready(function() {
                                                    $(".connectbutton").click(function() {
                                                        if ($("#domainss").val() != "") {
                                                            //$(".connectbutton").html("Connected");
                                                            $("#domainss").prop("readonly", true);
                                                            $("#domainss").css("background", "lightgrey");
                                                            $(".messageshowerr").html("");
                                                            $(".removebutton").show();
                                                            $(".connectbutton").hide();





                                                            $.ajax({
                                                                url: "storedomain/" + $("#domainss").val(),
                                                                success: function(result) {
                                                                    console.log(result);
                                                                }
                                                            });





                                                        } else {
                                                            $(".messageshowerr").html("* Must Enter Domain");
                                                        }


                                                    });
                                                    $(".removebutton").click(function() {

                                                        //$(".connectbutton").html("Connected");
                                                        $("#domainss").prop("readonly", false);
                                                        $("#domainss").css("background", "white");
                                                        $(".messageshowerr").html("");
                                                        $("#domainss").val("");
                                                        $(".removebutton").hide();
                                                        $(".connectbutton").show();




                                                    });
                                                });
                                            </script>


                                        </div>
                                    </div>





                                </div>

                                <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                    aria-labelledby="pills-profile-tab">





                                    <span>Please enter your domain name that you want to buy*</span>

                                    <form action="#" method="post" style="display: flex;"
                                        onsubmit="return checkdomainname();">
                                        @csrf
                                        <input type="text" name="domains" id="domains" class="form_control"
                                            value="" placeholder="Please Enter Your Domain Name" required />

                                        <button type="submit" class="btn btn-success">Search</button>

                                    </form>

                                    <span id="domainAvailable"></span>



                                </div>
                                <div class="tab-pane fade" id="pills-demo" role="tabpanel"
                                    aria-labelledby="pills-demo-tab">







                                    <form action="#" method="post" style="display: none;"
                                        onsubmit="return checkdomainname();">
                                        @csrf
                                        <input value="mydemo.goaflidemo.com" type="text" name="demodomains"
                                            id="demodomains" class="form_control" value=""
                                            placeholder="Please Enter Your Domain Name" required />

                                        <button type="submit" class="btn btn-success">Search</button>

                                    </form>

                                    <span id="domainAvailable"></span>



                                </div>


                            </div>

                        </div>

                    </div>

                </div>

            </div>

            @if (count($domains))

                <div class="col-lg-12">

                    <div class="card mt-3">

                        <div class="card-header">

                            <div class="section_title">

                                <h3>Suggested SSLs</h3>

                            </div>

                        </div>

                        <div class="card-body">

                            @foreach ($ssls as $ssl)
                                <div class="card domain-result mb-2">



                                    <div class="card-body suggested-ssl-list">

                                        <div class="new_domai_buy">

                                            <div class="text-info avalable-domain">

                                                <span class="sugg-ssl-name"><b>{{ $ssl['Name'] }}</b></span>

                                                <span class="ssl-regular-price"><span
                                                        class="ssl-regular-paice-refix">Regular Price &nbsp;</span><span
                                                        class="ssl-regular-paice-amount">
                                                        ₹{{ $ssl['RegularCost'] }}/Year*</span></span>

                                            </div>



                                            <div class="right">

                                                <span>₹{{ $ssl['Cost'] }}/Year </span>&nbsp;

                                                @if ($ssl['CartId'])
                                                    <form action="{{ config('app.url') }}/remove-ssl-cart"
                                                        method="post">
                                                        @csrf
                                                        <input type="hidden" name="id"
                                                            value="{{ $ssl['CartId'] }}">

                                                        <button type="submit"
                                                            class="btn btn-sm btn-warning">Remove</button>

                                                    </form>
                                                @else
                                                    <form action="{{ config('app.url') }}/ssl-to-cart" method="post">
                                                        @csrf
                                                        <input type="hidden" name="name"
                                                            value="{{ $ssl['Name'] }}">

                                                        <input type="hidden" name="cost"
                                                            value="{{ $ssl['Cost'] }}">

                                                        <input type="hidden" name="years"
                                                            value="{{ $ssl['Duration'] }}">

                                                        <input type="hidden" name="price"
                                                            value="{{ $ssl['Price'] }}">

                                                        <button type="submit" class="btn btn-sm btn-info">Add to
                                                            Cart</button>

                                                    </form>
                                                @endif

                                            </div>

                                        </div>

                                    </div>



                                </div>
                            @endforeach

                        </div>

                    </div>

                </div>

            @endif

            <div class="col-lg-7">

                <div class="card mt-3">

                    <div class="card-header">

                        <div class="section_title">

                            <h3>Selected Package</h3>

                        </div>

                    </div>

                    <div class="card-body">

                        <div class="order_list_info">

                            <table>

                                <tr class="border-bottom">

                                    <th class="max-tbl-wth">Package</th>

                                    <th>Term</th>

                                    <th>Price</th>

                                </tr>

                                <tr>

                                    <td class="max-tbl-wth">

                                        <strong>{{ $package_name }} </strong>

                                    </td>

                                    <td>

                                        @if ($package_term == 'monthly')
                                            {{ __('Monthly') }}
                                        @elseif ($package_term == 'yearly')
                                            {{ __('Yearly') }}
                                        @elseif ($package_term == 'lifetime')
                                            {{ __('Onetime') }}
                                        @endif

                                    </td>

                                    <td>

                                        ₹{{ $package_amount }}

                                    </td>

                                </tr>



                            </table>

                        </div>

                    </div>

                </div>



                <div class="card mt-3">

                    <div class="card-header">

                        <div class="section_title">

                            <h3>Addons Summary</h3>

                        </div>

                    </div>

                    <div class="card-body">

                        <div class="order_list_info">

                            <table>

                                <tr class="border-bottom">

                                    <th>Addon</th>

                                    <th>Price</th>

                                    <th>Term</th>

                                    <th>Quantity</th>

                                    <th>Action</th>

                                </tr>

                                @foreach ($selected_addons as $sead)
                                    <tr>

                                        <td class="max-tbl-wth">

                                            <strong>{{ $sead->title }} </strong>

                                        </td>

                                        <td>

                                            <span>₹{{ $sead->price }}</span>

                                        </td>

                                        <td>

                                            @if ($sead->term == 'monthly')
                                                {{ __('Monthly') }}
                                            @elseif ($sead->term == 'yearly')
                                                {{ __('Yearly') }}
                                            @elseif ($sead->term == 'lifetime')
                                                {{ __('Onetime') }}
                                            @endif

                                        </td>

                                        <td>

                                            {{ $sead->quantity }}

                                        </td>

                                        <td>

                                            <a href="delcart/{{ $sead->id }}"
                                                class="btn btn-warning btn-sm">Remove</a>

                                        </td>

                                    </tr>
                                @endforeach

                            </table>

                        </div>

                    </div>

                </div>

            </div>

            <div class="col-lg-5">

                @if (count($domains))

                    <div class="card mt-3">

                        <div class="card-header">

                            <div class="section_title">

                                <h3>Selected Domains</h3>

                            </div>

                        </div>

                        <div class="card-body">

                            <table>

                                <tr class="border-bottom">

                                    <th>Domain</th>

                                    <th>Term</th>

                                    <th>Price</th>

                                    <th>Remove</th>

                                </tr>

                                @foreach ($domains as $domain)
                                    <tr>

                                        <td class="max-tbl-wth">

                                            <strong>{{ $domain->name }} </strong>

                                        </td>

                                        <td>

                                            {{ $domain->years }}

                                            @if ($domain->years > 1)
                                                Years
                                            @else
                                                Year
                                            @endif

                                        </td>

                                        <td>

                                            ₹{{ $domain->price }}

                                        </td>

                                        <td>

                                            <a href="remove-domain-cart/{{ $domain->id }}"
                                                class="btn btn-warning btn-sm mt-2">Remove</a>

                                        </td>

                                    </tr>
                                @endforeach

                            </table>

                        </div>

                    </div>

                @endif

                <div class="card mt-3">

                    <div class="card-header">

                        <div class="section_title">

                            <h3>Billing Information</h3>

                        </div>

                    </div>

                    <div class="card-body">

                        <div class="order_wrap_box">

                            <form action="{{ config('app.url') }}/addtoorder" method="POST"
                                onsubmit="return putdomain()">
                                @csrf
                                <input type="hidden" id="mydemo" name="demo" value="0">

                                <input type="hidden" name="user_id" value="<?php echo $userId = Auth::id(); ?>">

                                <input type="hidden" name="plan" value="{{ $myplan }}" id="new_plan">

                                <input type="hidden" name="item_id" value="{{ $package_item }}" id="new_item_id">

                                <input type="hidden" name="total" value="{{ $total_amount }}">

                                <input type="hidden" name="domain" id="domain" value="">

                                <input type="hidden" name="domaintype" id="domaintype" value="">

                                <div id="couponReload"></div>

                                <div class="order_payment_box"></div>

                                <div class="section_title">

                                    <h5>Billing Address</h5>

                                </div>

                                <select id="billing_info" name="billing_info" class=" olima_select">

                                    @if (count($addresses))

                                        @foreach ($addresses as $address)
                                            <option value="{{ $address->id }}">{{ $address->address }},
                                                {{ $address->country }}, {{ $address->zip }}</option>
                                        @endforeach

                                    @endif

                                    <option value="">Create new billing information</option>

                                </select>

                                <br><br>

                                <div class="section_title">

                                    <h5>Payment Method</h5>

                                </div>

                                <select name="payment_method" id="payment-gateway" class="olima_select">

                                    <option value="" selected disabled>{{ __('Choose an option') }}</option>

                                    @foreach ($payment_methods as $payment_method)
                                        <option value="{{ $payment_method->name }}"
                                            {{ $payment_method->name == 'Razorpay' ? 'selected' : '' }}>

                                            {{ $payment_method->name }}

                                        </option>
                                    @endforeach

                                </select>

                                <br><br>

                                <div class="order_payment_box">

                                    <div class="order_product_info ">

                                        <h5 class="">Total : <span style="float:right;">
                                                ₹{{ $total_amount }}</span></h5>

                                    </div>

                                </div>



                                <div class="text-center">

                                    <button class="main-btn w-100 mt-2" type="submit">{{ __('Check Out') }}

                                    </button>

                                </div>



                            </form>

                            <div class="modal fade" id="modaladdbillinginfo" tabindex="-1" role="dialog"
                                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

                                <div class="modal-dialog modal-dialog-centered" role="document">

                                    <div class="modal-content">

                                        <div class="modal-header">

                                            <h5 class="modal-title" id="exampleModalLongTitle">Add Billing Information
                                            </h5>

                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">

                                                <span aria-hidden="true">&times;</span>

                                            </button>

                                        </div>

                                        <div class="modal-body text-left">

                                            <form action="{{ config('app.url') }}/addbillinginfo" method="POST">
                                                @csrf
                                                <div class="row">

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">First Name</label>

                                                            <input type="text" class="form-control" placeholder="John"
                                                                name="first_name" value="" required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">Last Name</label>

                                                            <input type="text" class="form-control" placeholder="Doe"
                                                                name="last_name" value="" required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">Phone Number</label>

                                                            <input type="number" class="form-control"
                                                                placeholder="9874563210" name="phone" value=""
                                                                required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">Email Address</label>

                                                            <input type="text" class="form-control"
                                                                placeholder="johndoe@mail.com" name="email"
                                                                value="" required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-12">

                                                        <div class="form-group">

                                                            <label for="">Address</label>

                                                            <textarea type="text" class="form-control" placeholder="Kolkata, Bidhan Nagar, Sector 5." name="address"
                                                                required></textarea>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">City</label>

                                                            <input type="text" class="form-control"
                                                                placeholder="Kolkata" name="city" value=""
                                                                required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">State</label>

                                                            <input type="text" class="form-control"
                                                                placeholder="West Bengal" name="state" value=""
                                                                required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">Country</label>

                                                            <input type="text" class="form-control"
                                                                placeholder="India" name="country" value=""
                                                                required>

                                                        </div>

                                                    </div>

                                                    <div class="col-lg-6">

                                                        <div class="form-group">

                                                            <label for="">Zip</label>

                                                            <input type="number" class="form-control"
                                                                placeholder="720000" name="zip" value=""
                                                                required>

                                                        </div>

                                                    </div>

                                                </div>

                                                <button class="main-btn w-100 mt-2"
                                                    type="submit">{{ __('Create') }}</button>

                                            </form>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>



        </div>

    </section>
@else
    <section class=" pricing-page pt-110 pb-120">

        <div class="container">



            <center>
                <h1>You Have no Item in your cart</h1>
            </center>

            <center> <a href="{{ url('/') }}/services" class="btn btn-primary mt-30">View Services</a></center>

        </div>

    </section>



    @endif







    <?php $rand = rand(10000, 99999); ?>



    <!--====== End saas_checkout ======-->

    <script>
        var newdomain = '{{ $newdomain }}';

        function checkdomainname() {

            var domain = document.getElementById("domains").value;

            var status = document.getElementById("domainAvailable");



            var item_id = document.getElementById("new_item_id").value;

            var plan_id = document.getElementById("new_plan").value;



            status.innerHTML = '<p class="text-info">Checking ..</p>';


            var token = '<?= csrf_token() ?>';
            var data = new FormData();

            data.append('_token', token);
            data.append('domain', domain);



            var xhttp = new XMLHttpRequest();

            xhttp.open("POST", "searchdomain", false);

            xhttp.onreadystatechange = function() {

                if (this.readyState == 4 && this.status == 200 && this.responseText != '') {

                    const obj = JSON.parse(this.response);

                    /*if(obj.Available == 'true'){

                        status.innerHTML = '<form action="/domain-to-cart" method="post" class="new_domai_buy"><p class="text-success">Wow, '+domain+' is available <input type="hidden" name="domain" value="'+domain+'"><input type="hidden" name="item_id" value="'+item_id+'"><input type="hidden" name="plan_id" value="'+plan_id+'"><input type="hidden" name="price" value="'+obj.Rs+'"><input type="hidden" name="chargedAmount" value="'+obj.Price+'"></p><div>₹'+obj.Rs+'/Year &nbsp;<button class="btn btn-sm btn-info">Add to Cart</button></div></form>';

                    }else{

                        status.innerHTML = '<p class="text-danger">Sorry, '+domain+' is not available</p>';

                    }*/
                    /*alert(obj.Price);*/
                    if (obj.availibility == 'available') {

                        status.innerHTML =
                            '<form action="domain-to-cart" method="post" class="new_domai_buy">@csrf<p class="text-success">Wow, ' +
                            domain + ' is available <input type="hidden" name="domain" value="' + domain +
                            '"><input type="hidden" name="item_id" value="' + item_id +
                            '"><input type="hidden" name="plan_id" value="' + plan_id +
                            '"><input type="hidden" name="price" value="' + obj.Rs +
                            '"><input type="hidden" name="chargedAmount" value="' + obj.Price + '"></p><div>₹' + obj
                            .Rs + '/Year &nbsp;<button class="btn btn-sm btn-info">Add to Cart</button></div></form>';

                    } else {

                        status.innerHTML = '<p class="text-danger">Sorry, ' + domain + ' is not available</p>';

                    }

                }

            }

            xhttp.send(data);

            return false;

        }

        function addaddon2(val) {

            document.getElementById("itemid").value = val;

            document.getElementById("itemid2").value = val;

        }



        function loadXMLDoc() {

            var xhttp = new XMLHttpRequest();

            xhttp.onreadystatechange = function() {

                if (this.readyState == 4 && this.status == 200) {

                    document.getElementById("couponReload").innerHTML =

                        this.responseText;

                }

            };

            xhttp.open("GET", "{{ config('app.url') }}/cart2?id=<?php echo $rand; ?>", true);

            xhttp.send();

        }

        // loadXMLDoc();

        function addaddon(val) {

            alert('s');

            var params = 'user_id=1&item_id=2&status=0';

            var xhttp = new XMLHttpRequest();

            xhttp.onreadystatechange = function() {

                if (this.readyState == 4 && this.status == 200) {

                    alert('ok');

                }

            };

            xhttp.open("POST", "{{ config('app.url') }}/addaddon/", true);

            http.send(params);



        }





        <?php if($plan == '1'){ ?>



        document.getElementById("pricing").style.display = 'none';

        document.getElementById("cart").style.display = 'block';

        document.getElementById("order-details").style.display = 'none';

        <?php }elseif($plan == '2'){ ?>

        document.getElementById("pricing").style.display = 'none';

        document.getElementById("cart").style.display = 'none';

        document.getElementById("order-details").style.display = 'block';

        <?php }else{ ?>



        document.getElementById("pricing").style.display = 'block';

        document.getElementById("cart").style.display = 'none';

        document.getElementById("order-details").style.display = 'none';



        <?php } ?>





        function putdomain() {

            var billing_info = document.getElementById("billing_info").value;
            var payment_gateway = document.getElementById("payment-gateway").value;
            if (payment_gateway == "") {
                toastr.warning("Please Select a payment Method!");

                return false;
            }
            if (!billing_info) {

                $('#modaladdbillinginfo').modal('show');

                return false;

            }



            vall = document.getElementById("domainss").value;

            if (vall == '') {
                vall = document.getElementById("demodomains").value;
            }
            if (vall != '') {

                document.getElementById("domain").value = vall;

                document.getElementById("domaintype").value = "old";

            } else {

                if (newdomain != '') {

                    document.getElementById("domain").value = newdomain;

                    document.getElementById("domaintype").value = "new";

                } else {

                    alert('please enter domain name');


                    return false;

                }



            }

        }

        function mydemo(val) {
            document.getElementById("mydemo").value = val;
        }
    </script>



@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@section('js')
    <script>
        console.log("Hi, I'm using the Laravel-AdminLTE package!");
    </script>
@stop
