<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />

        <title>{{ isset($metaTitle) ? $metaTitle : 'Afli - Turning Your Ideas Into Reality' }}</title>

    <meta name="description" content="AFLI - Turning your ideas into Reality" />
    <meta name="keywords"
        content="agency, app, business, company, corporate, designer, freelance, fullpage, modern, office, personal, portfolio, professional, web, web agency" />
    <meta name="author" content="Themexriver" />
    <link rel="shortcut icon" href="{{ asset('assets/logo_maker/img/logo/f-icon.png') }}" type="image/x-icon" />
    <!-- Mobile Specific Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="stylesheet" href="{{ asset('assets/cgi_video/css/new_style.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/cgi_video/css/main.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/flaticon_aina.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/global.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/swiper.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/logo_maker/css/logo-maker.css') }}" />

    <link href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Rubik+Gemstones&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Bungee&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Knewave&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Exo:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

    <style>
        .exo{
              font-family: "Exo", sans-serif !important;
        }
        .playFul {
            font-family: "Rubik Gemstones", serif;
            font-weight: 400;
            font-style: normal;
        }

        .bungee {
            font-family: "Bungee", serif;
            font-weight: 400;
            font-style: normal;
        }

        .handwriting {
            font-family: "Knewave", serif;
            font-weight: 400;
            font-style: normal;
        }

        .responsive_text {
            font-size: 4rem !important;
            color: #fff;
        }

        .logoCard {
            height: 100%;
            position: relative;
        }

        .logoCard .download_icons {
            position: absolute;
            top: 10px;
            right: 30px;
        }

        .saveIconToDb {
            color: #fff;
            border: 1px solid #fff;
            padding: 10px;
            border-radius: 50px !important;
        }

        .uploadAndSave {
            color: #fff;
            border: 1px solid #fff;
            padding: 10px;
            border-radius: 50px !important;

        }
        .nav-link:hover{
            color:#fff !important;
        }
        .nav-link:focus{
            color:#000 !important;
        }
    </style>
    <style>
        body {
            background: linear-gradient(to right, #676efcb8, #ec008c) !important;
        }

        .spad-2 {
            position: relative;
            background-color: transparent !important;
            padding-top: 50px !important;
            background: none !important;
        }
    </style>

    <style>
        .nissan-header-main {
            position: relative;
            left: 0;
            top: 0;
            width: 100%;
            z-index: 999;
        }

        .left-bumber-front-style-set {
            width: 60px;
            position: relative;
            background-color: white;
            clip-path: polygon(100% 0%, 100% 100%, 50% 61%, 11% 12%, 24% 0%);
            margin-right: -1px;
        }

        .right-bumber-front-style-set {
            width: 60px;
            position: relative;
            background-color: white;
            clip-path: polygon(0% 0%, 0% 100%, 50% 61%, 89% 12%, 76% 0%);
            margin-left: -1px;
        }

        .left-bmp-style-set-s-d {
            /* Adding backdrop filter for glass blur effect */
            backdrop-filter: blur(15px);
            /* Increase the blur value for more effect */
            -webkit-backdrop-filter: blur(15px);
            /* Safari support */

            /* Optional: You can adjust opacity for a better glass effect */
            opacity: 0.9;
            /* Adjust the transparency to make the effect more prominent */
            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.637),
                    rgba(170, 170, 170, 0.26));

            /* background-color: red; */
            clip-path: polygon(0% 0%,
                    85% 0%,
                    82% 17%,
                    87% 50%,
                    98% 100%,
                    10% 100%,
                    2% 50%);
            margin-right: -45px;
        }

        .left-bmp-style-set-s-d ul {
            margin-right: 60px;
        }

        .left-bmp-style-set-s-d {
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);

            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.637),
                    rgba(170, 170, 170, 0.26));

            clip-path: polygon(0% 0%,
                    85% 0%,
                    82% 17%,
                    87% 50%,
                    98% 100%,
                    10% 100%,
                    2% 50%);
            margin-right: -45px;
        }

        .left-bmp-style-set-s-d ul {
            margin-right: 60px;
        }

        .right-bmp-style-set-s-d {
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);

            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.637),
                    rgba(170, 170, 170, 0.26));

            clip-path: polygon(100% 0%,
                    15% 0%,
                    18% 17%,
                    13% 50%,
                    2% 100%,
                    90% 100%,
                    98% 50%);

            margin-left: -45px;
        }

        .right-bmp-style-set-s-d .welcome-container {
            margin-left: 60px;
        }

        .welcome-container {
            padding: 12px 20px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .welcome-text {
            color: white;
            font-size: 14px;
            font-weight: 400;
            margin: 0;
        }

        .separator {
            color: white;
            margin: 0 4px;
        }

        .avatar {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            object-fit: cover;
            background-color: #ccc;
        }

        .overlay-style-set-d-s {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.342);
            z-index: 10;
            display: none;
            transition: 0.3s;
        }

        .offcanvas-main-sidebar-style-set-d {
            position: fixed;
            left: -300px;
            top: 0;
            min-height: 100vh;
            width: 300px;
            background-color: white;
            z-index: 11;
            /* display: none; */
            transition: 0.3s;
        }

        #sideBarCloseBtn {
            display: block;
            text-align: center;
        }

        .mobile-view-menu-style-set {
            display: none;
        }

        .bottom-icons-sidebar-fixed-style {
            width: 267px;
        }

        .nav-link-style-set-s {
            font-size: 20px;
            text-align: start;
        }

        .sidebar-list-height-set-style {
            height: 100vh;
        }

        .cart-count-style {
            position: absolute;
            right: -7px;
            top: -5px;
            background-color: #000;
            color: white;
            border-radius: 50%;
            width: 17px;
            height: 17px;
            font-size: 12px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media(max-width:550px)
        {
            .hideMobile
            {
                display: none !important;
            }
        }
        .nissan-header-main
        {
            max-width: 100vw;
        }
          .popup-menu {
            position: absolute !important;
            top: 60px; /* Adjust based on avatar size */
            right: 150px;
            background: white;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
            border-radius: 5px;
            padding: 10px;
            min-width: 150px;
            z-index: 9999; /* Ensure it's always above */
            text-align: left;
            display: none;
            
    }
    .popup-menu a {
        display: block; /* Ensure each link is on a new line */
        padding: 10px;
        text-decoration: none;
        color: black;
        font-size: 14px;
        transition: background 0.3s;
    }

.popup-menu a:hover {
    background: #f1f1f1;
    border-radius: 3px;
}

    </style>

    @yield('css')
</head>

<body class="AFLI-home">


    <header class="nissan-header-main py-3">
        <div id="overlayStyleSectionSS"></div>
        <div class="container text-center">
            <div class="d-inline-block">
                <div class="d-flex">
                    <div class="left-bmp-style-set-s-d d-flex align-items-center pe-5">
                        <ul class="d-flex ps-0 align-items-center mb-0">
                            @if (auth()->check())
                             <li class="mx-5 list-unstyled">
                                <a href="{{url('/cgi/templates')}}" class="text-decoration-none text-white fw-semibold exo">Dashboard</a>
                            </li>
                            <li class="mx-3 list-unstyled hideMobile">
                                <a href="{{url('/cgi/orders')}}" class="text-decoration-none text-white fw-semibold exo">Orders</a>
                            </li>
                            @else
                             <li class="mx-5 list-unstyled">
                                <a href="{{url('/cgi/templates')}}" class="text-decoration-none text-white fw-semibold exo">Home</a>
                            </li>
                            <li class="mx-3 list-unstyled hideMobile">
                                <a href="#" class="text-decoration-none text-white fw-semibold exo">About</a>
                            </li>
                            @endif
                           
                        </ul>
                    </div>
                    <div class="left-bumber-front-style-set"></div>
                    <div class="d-flex justify-content-around bg-white mid-menu-style-ss p-2 align-items-center">
                        <div class="mx-4 hideMobile">
                            <a href="#" class="text-black text-decoration-none position-relative">
                                <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23"
                                    fill="currentColor" class="bi bi-cart" viewBox="0 0 16 16">
                                    <path
                                        d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5M3.102 4l1.313 7h8.17l1.313-7zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4m7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4m-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2m7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2" />
                                </svg>
                            </a>
                        </div>
                        <div class="logo mx-4 m-brand-logo hideMobile" style="width:35px;height:35px;">
                            <a href="#"><img src="{{ asset('assets/logo_maker/img/logo/logo2.png') }}"
                                    height="40px" alt="" /></a>
                        </div>
                        <div class="menu-btn mx-4">
                            <button class="bg-transparent border-0 side-bar-style-btn-open-close-s"
                                id="left-side-menu-btn-set">
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30"
                                    fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="right-bumber-front-style-set hideMobile"></div>
                    <div class="right-bmp-style-set-s-d d-flex align-items-center pe-5 hideMobile">
                        <div class="welcome-container">
                            @php
                                $user = 'User';
                                if (auth()->check()) {
                                    $user = auth()->user()->first_name;
                                }
                            @endphp


                            <span class="welcome-text exo">Welcome {{ ucfirst($user) }} !</span>
                            <span class="separator">—</span>
                             <img id="userAvatar" src="{{ asset('assets/images/userr.webp') }}" alt="User avatar"
                                        class="avatar" />
                        </div>
                    </div>

                   @if(Auth::check())
                        <div id="popupMenu" class="popup-menu">
                            <a href="{{ url('profile') }}">Edit Profile</a>
                            <a href="{{ route('userSetting') }}">Settings</a>
                            <a href="{{ url('logout') }}">Logout</a>
                        </div>
                    @else
                        <div id="popupMenu" class="popup-menu">
                            <a href="{{ url('login') }}">Login</a>
                            <a href="{{ url('register') }}">Sign Up</a>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </header>




    @yield('content')

    <section id="hap-footer" class="hap-footer-section"
        data-background="{{ asset('assets/images/bg/footer-bg.jpg') }}">
        <div class="hap-footer-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="logo-widget">
                                <div class="brand-logo">
                                    <a href="#"><img src="{{ asset('assets/logo_maker/img/logo/logo1.png') }}"
                                            alt="" /></a>
                                </div>
                                <p class="exo">
                                    Made using clean, non-toxic ingredients, our products are
                                    signed for everyone. Made using clean, non-toxic
                                </p>
                                <div class="logo-cta ul-li-block">
                                    <ul>
                                        <li>
                                            <a href="#" class="exo"><i class="fas fa-map-marker-alt"></i> Address: Dubai
                                                Silicon Oasis, DDP, Building A1, Dubai, United Arab Emirates</a>
                                        </li>
                                        <li>
                                            <a href="#" class="exo"><i class="fas fa-envelope"></i> Email: info@afli.ae</a>
                                        </li>
                                        <li>
                                            <a href="#" class="exo"><i class="fas fa-phone"></i>Phone: +971 58 242 2625</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="hap-contact-social text-uppercase d-flex">
                                    <a href="https://www.facebook.com/Afli.ae"><i class="fab fa-facebook-f"></i>
                                        Facebook</a>
                                    <a href="#"><i class="fab fa-instagram"></i> Instagram</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="menu-widget ul-li-block">
                                <h3 class="widget-title text-uppercase exo">quick links</h3>
                                <ul>
                                    <li><a href="#" class="exo">FAQ</a></li>
                                    <li><a href="#" class="exo">Privacy Policy</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="menu-widget ul-li-block">
                                <h3 class="widget-title text-uppercase exo">categories</h3>
                                <ul>
                                    <li><a href="{{url('service')}}" class="exo">Services</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="newslatter-widget">
                                <h3 class="widget-title text-uppercase exo">subcribe</h3>
                                <p class="text-white exo">You can be always date with our company news</p>
                                <form >
                                    <input type="email" name="email" id="subscribeEmail" placeholder="Subcribe email" />
                                    <button type="button" id="subscribeNow"><i class="fal fa-long-arrow-right"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="hap-footer-copyright text-center">
            © 2025 Afflictor-FZCO All Rights Reserved.
        </div>
    </section>

    <a href="https://wa.me/+971582422625" target="_blank" class="whatsApp-float">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp"
            class="whatsapp-icon" />
    </a>





    <div class="overlay-style-set-d-s"></div>
    <div class="offcanvas-main-sidebar-style-set-d p-3" style="z-index:9999 !important;">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="sidepanel-log">
                <a href="#">
                    <img src="{{asset('assets/logo_maker/img/logo/logo2.png')}}" style="width:30px;"/>
                </a>
            </div>
            <div class="d-flex align-items-center">
                <div class="text-center me-3">
                    <a class="text-black me-2" data-bs-toggle="collapse" href="#collapseExample" role="button"
                        aria-expanded="false" aria-controls="collapseExample">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor"
                            class="bi bi-search" viewBox="0 0 16 16">
                            <path
                                d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001q.044.06.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1 1 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0" />
                        </svg></a>
                    <a href="#" class="text-black"><svg xmlns="http://www.w3.org/2000/svg" width="30"
                            height="30" fill="currentColor" class="bi bi-cart-fill" viewBox="0 0 16 16">
                            <path
                                d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5M5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4m7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4m-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2m7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2">
                            </path>
                        </svg></a>
                    <a href="#" class="text-black ms-2"><svg xmlns="http://www.w3.org/2000/svg" width="25"
                            height="25" fill="currentColor" class="bi bi-heart" viewBox="0 0 16 16">
                            <path
                                d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143q.09.083.176.171a3 3 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15">
                            </path>
                        </svg></a>
                </div>
                <button type="button" class="btn-close close-btn-style-set-cl-s" aria-label="Close"></button>
            </div>
        </div>
        <div class="collapse mb-3" id="collapseExample">
            <input type="email" class="form-control border-black" id="exampleFormControlInput1"
                placeholder="Search here..." />
        </div>
        <div class="overflow-y-auto sidebar-list-height-set-style">
            <div class="d-block d-lg-none nav-link-style-set-s">
                <ul class="ps-2 mb-0">
                    <li class="list-unstyled">
                        <a href="#" class="text-decoration-none text-black py-2 d-block">Home</a>
                    </li>

                    <li class="list-unstyled">
                        <a href="#" class="text-decoration-none text-black py-2 d-block">About</a>
                    </li>
                    <li class="list-unstyled">
                        <a href="#" class="text-decoration-none text-black py-2 d-block">Collection 2025</a>
                    </li>
                    <li class="list-unstyled">
                        <a href="#" class="text-decoration-none text-black py-2 d-block">Shop</a>
                    </li>
                </ul>
            </div>

            <div class="nav-link-style-set-s">
                <ul class="ps-2 mb-4">
                    <!-- Accordion Wrapper -->
                    <div class="accordion" id="menuAccordion">
                        <!-- Other Sports with accordion submenu and icon -->
                        <li class="list-unstyled">
                            <div class="accordion-item border-0">
                                <h2 class="accordion-header" id="headingOne">
                                    <button
                                        class="text-decoration-none text-black py-2 d-block w-100 btn px-0 text-start btn-link nav-link-style-set-s"
                                        type="button" data-bs-toggle="collapse"
                                        data-bs-target="#otherSportsCollapse" aria-expanded="false"
                                        aria-controls="otherSportsCollapse">
                                        Other Sports
                                        <i class="bi bi-chevron-down ms-2"></i>
                                        <!-- Arrow icon -->
                                    </button>
                                </h2>
                                <div id="otherSportsCollapse" class="accordion-collapse collapse"
                                    aria-labelledby="headingOne" data-bs-parent="#menuAccordion">
                                    <div class="accordion-body">
                                        <ul class="list-unstyled ps-3">
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Basketball</a>
                                            </li>
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Tennis</a>
                                            </li>
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Baseball</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <!-- FAQ & Contact with accordion submenu and icon -->
                        <li class="list-unstyled">
                            <div class="accordion-item border-0">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button
                                        class="text-decoration-none text-black py-2 d-block w-100 btn btn-link px-0 text-start nav-link-style-set-s"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#faqContactCollapse"
                                        aria-expanded="false" aria-controls="faqContactCollapse">
                                        FAQ &amp; Contact
                                        <i class="bi bi-chevron-down ms-2"></i>
                                        <!-- Arrow icon -->
                                    </button>
                                </h2>
                                <div id="faqContactCollapse" class="accordion-collapse collapse"
                                    aria-labelledby="headingTwo" data-bs-parent="#menuAccordion">
                                    <div class="accordion-body">
                                        <ul class="list-unstyled ps-3">
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">General
                                                    FAQ</a>
                                            </li>
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Customer
                                                    Support</a>
                                            </li>
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Contact
                                                    Form</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <!-- Blog with accordion submenu and icon -->
                        <li class="list-unstyled">
                            <div class="accordion-item border-0">
                                <h2 class="accordion-header" id="headingThree">
                                    <button
                                        class="text-decoration-none text-black py-2 d-block w-100 btn btn-link px-0 text-start nav-link-style-set-s"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#blogCollapse"
                                        aria-expanded="false" aria-controls="blogCollapse">
                                        Blog
                                        <i class="bi bi-chevron-down ms-2"></i>
                                        <!-- Arrow icon -->
                                    </button>
                                </h2>
                                <div id="blogCollapse" class="accordion-collapse collapse"
                                    aria-labelledby="headingThree" data-bs-parent="#menuAccordion">
                                    <div class="accordion-body">
                                        <ul class="list-unstyled ps-3">
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Latest
                                                    Posts</a>
                                            </li>
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Popular
                                                    Posts</a>
                                            </li>
                                            <li>
                                                <a href="#"
                                                    class="text-decoration-none text-black py-2 d-block">Archives</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </div>

                    <!-- Client Login (no collapse) -->
                    <li class="list-unstyled">
                        <a href="#" class="text-decoration-none text-black py-2 d-block">
                            Client Login
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <div
            class="mx-auto my-1 text-center position-fixed bottom-0 left-0 p-3 bg-white bottom-icons-sidebar-fixed-style">
            <div class="mb-3">
                <a href="#" class="text-black"><svg xmlns="http://www.w3.org/2000/svg" width="20"
                        height="20" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                        <path
                            d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951">
                        </path>
                    </svg></a>
                <a href="#" class="text-black ms-3"><svg xmlns="http://www.w3.org/2000/svg" width="20"
                        height="20" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
                        <path
                            d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334">
                        </path>
                    </svg></a>
                <a href="#" class="text-black ms-3"><svg xmlns="http://www.w3.org/2000/svg" width="20"
                        height="20" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                        <path
                            d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z">
                        </path>
                    </svg></a>
            </div>

            @if (auth()->check())
            <div class="row">
                <div class="col">
                    <button class="btn bg-danger w-100 text-white" id="logoutUser">
                        Logout
                    </button>
                </div>
            </div>
            @else
            <div class="row">
                <div class="col">
                    <a class="btn bg-black w-100 text-white" href="{{url('login/')}}">
                        Sign Up
                    </a>
                </div>
                <div class="col">
                    <a class="btn bg-black w-100 text-white" href="{{url('login/')}}">
                        Login
                    </a>
                </div>
            </div>
            @endif

            
        </div>
    </div>





    <script src="https://code.jquery.com/jquery-3.7.1.min.js" type="text/javascript"></script>
    <script src="{{ asset('assets/logo_maker/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/logo_maker/js/ScrollTrigger.min.js') }}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" type="text/javascript">
    </script>
    <script src="https://kit.fontawesome.com/768b80f5c3.js" crossorigin="anonymous"></script>

    @yield('js')

    <script src="{{ asset('assets/logo_maker/js/script.js') }}"></script>
      <script>
    let btnSideBar = document.querySelector(
      ".side-bar-style-btn-open-close-s"
    );
    let sidebarCOSstyle = document.querySelector(
      ".offcanvas-main-sidebar-style-set-d"
    );
    let CloseBtnStyleSidebar = document.querySelector(
      ".close-btn-style-set-cl-s"
    );
    let overlaySideBarSet = document.querySelector(".overlay-style-set-d-s");
    btnSideBar.addEventListener("click", () => {
      sidebarCOSstyle.style.left = "0px";
      overlaySideBarSet.style.display = "block";
    });
    CloseBtnStyleSidebar.addEventListener("click", () => {
      sidebarCOSstyle.style.left = "-300px";
      overlaySideBarSet.style.display = "none";
    });
  </script>
     <!-- Custom JS to toggle the icon direction -->
<script>
  // Toggle arrow icon direction on submenu expand/collapse
  document.querySelectorAll('[data-bs-toggle="collapse"]').forEach(button => {
    button.addEventListener('click', function () {
      const icon = this.querySelector('i');
      if (icon.classList.contains('bi-chevron-down')) {
        icon.classList.remove('bi-chevron-down');
        icon.classList.add('bi-chevron-up');
      } else {
        icon.classList.remove('bi-chevron-up');
        icon.classList.add('bi-chevron-down');
      }
    });
  });
</script>
<script>
    $("#logoutUser").on('click', function(){
        var logoutUser = "{{route('logout')}}";
        location.href = logoutUser;
    });
</script>
<script>
        document.getElementById("userAvatar").addEventListener("click", function(event) {
            var menu = document.getElementById("popupMenu");
            menu.style.display = (menu.style.display === "block") ? "none" : "block";
        });

        // Close menu when clicking outside
        document.addEventListener("click", function(event) {
            var menu = document.getElementById("popupMenu");
            if (event.target.id !== "userAvatar" && !menu.contains(event.target)) {
                menu.style.display = "none";
            }
        });
    </script>
    <script>
        $("#subscribeNow").on('click', function(){
            var email = $("#subscribeEmail").val();
            if(email)
            {
                var data = {email:email, _token:"{{csrf_token()}}"};
                var url = "{{route('subscribeEmail')}}";
                $.post(url, data, function(data){
                    
                }); 
            }
        });
    </script>
</body>

</html>
