@extends('user.layout')

@section('content')
<div class="page-header">
    <h4 class="page-title">{{__('SSL List')}}</h4>
    <ul class="breadcrumbs">
        <li class="nav-home">
            <a href="{{route('user-dashboard')}}">
            <i class="flaticon-home"></i>
            </a>
        </li>
        <li class="separator">
            <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
            <a href="#">{{__('SSL List')}}</a>
        </li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card-title d-inline-block">{{__('SSL List')}}</div>
                    </div>
                    <div class="col-lg-3">
                    </div>
                    <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                        <a href="{{ route('front.ssl-certificates') }}" class="btn btn-info btn-sm" style="float: right;">Buy SSL</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (count($ssls) == 0)
                        <h3 class="text-center">{{__('NO SSL FOUND')}}</h3>
                        @else
                        <div class="table-responsive">
                            <table class="table table-striped mt-3">
                                <thead>
                                    <tr>
                                        <th scope="col">{{__('Name')}}</th>
                                        <th scope="col">{{__('Amount')}}</th>
                                        <th scope="col">{{__('Payment')}}</th>
                                        <th scope="col">{{__('Years')}}</th>
                                        <th scope="col">{{__('Purchased')}}</th>
                                        <th scope="col">{{__('Expired')}}</th>
                                        <th scope="col">{{__('Transaction')}}</th>
                                        <th scope="col">{{__('Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($ssls as $key => $ssl)
                                    <tr>
                                        <td>{{$ssl->name}}</td>
                                        <td>₹{{$ssl->price}}</td>
                                        <td>
                                            @if($ssl->is_paid == 1)
                                                <h3 class="d-inline-block badge badge-success">Success</h3>
                                            @else
                                                <h3 class="d-inline-block badge badge-warning">Pending</h3>
                                            @endif    
                                        </td>
                                        <td>{{$ssl->years}}</td>
                                        <td>@if($ssl->purchased){{\Carbon\Carbon::parse($ssl->purchased)->format('d/m/Y')}}@endif</td>
                                        <td>@if($ssl->expired){{\Carbon\Carbon::parse($ssl->expired)->format('d/m/Y')}}@endif</td>
                                        <td>{{$ssl->transactionID}}</td>
                                        <td>
                                            @if($ssl->certificateID)<a href="{{ route('user.ssl.activate',[$ssl->certificateID]) }}" class="btn btn-warning btn-sm mr-1">Activate</a>@endif
                                            @if($ssl->certificateID)<a href="{{ route('user.ssl.view',[$ssl->certificateID]) }}" class="btn btn-info btn-sm">Info</a>@endif
                                        </td>
                                    </tr>    
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="d-inline-block mx-auto">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
