<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\AiBuilder\CronController;

/*
|--------------------------------------------------------------------------
| Console Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of your Closure based console
| commands. Each Closure is bound to a command instance allowing a
| simple approach to interacting with each command's IO methods.
|
*/

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');


Artisan::command('update_personal_domain_dns', function(){
    $controller = app(\App\Http\Controllers\AiBuilder\CronController::class);
    $controller->propogation();
});

Artisan::command('purchase_domain', function(){
    $controller = app(\App\Http\Controllers\AiBuilder\CronController::class);
    $controller->purchase_domain();
});

Artisan::command('purchase_ecommerce_domain', function(){
    $controller = app(\App\Http\Controllers\Ecommerce\CronController::class);
    $controller->purchase_domain();
});


Artisan::command('check_ecommerce_propogation', function(){
    $controller = app(\App\Http\Controllers\Ecommerce\CronController::class);
    $controller->check_propogation();
});

Artisan::command('connect_ecommerce_domain', function(){
    $controller = app(\App\Http\Controllers\Ecommerce\CronController::class);
    $controller->connect_ecommerce_domain();
});


Artisan::command('upload_personal_files', function(){
    $controller = app(\App\Http\Controllers\AiBuilder\CronController::class);
    $controller->upload_personal_files();
});

Artisan::command('fix', function(){
    Artisan::call('optimize');
    Artisan::call('config:clear');
    $this->comment('Command Fixed Run Successfully');
});