<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ChatController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\ProjectsController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\CallingController;
use App\Http\Controllers\AgentDashboard;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\Payment\RazorpayController;
use App\Http\Controllers\PaymentLogController;
use App\Http\Controllers\DomainController;
use App\Http\Controllers\CronJobController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\CronController;
use App\Http\Controllers\FacebookController;
use App\Http\Controllers\TwitterController;
use App\Http\Controllers\LinkedinController;
use App\Http\Controllers\SocialController;
use App\Http\Controllers\CrmController;
use App\Http\Controllers\WidgetController;
use App\Http\Controllers\FtpController;
use App\Http\Controllers\WhmController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\LogoController;
use App\Http\Controllers\InstagramController;
use App\Http\Controllers\PinterestController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\TransactionsController;
use App\Http\Controllers\WebsiteController;
use App\Http\Controllers\AiController;
use App\Http\Controllers\ThemeController;
use App\Models\User;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\Whm\CpanelController;
use App\Http\Controllers\Whm\SqlDatabaseController;
use App\Http\Controllers\VideoCgi\CgiUserController;
use App\Http\Controllers\ContactusController;
use App\Http\Controllers\ImageEditor\ImageTemplatesController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\Invoices\InvoicesController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('service', [ServicesController::class,  'services'])->name('services');
Route::get('services', function () {
    return redirect('service');
});


Route::get('namechea-domain-check', [DomainController::class, 'nameCheapChecker']);
Route::get('/', [FrontController::class, 'pricing'])->name('welcome');
Route::get('/docroot', [FrontController::class, 'docroot'])->name('docroot');
Route::get('/baseurl', [FrontController::class, 'baseurl'])->name('baseurl');
Route::get('/pages/{id}', [FrontController::class, 'pages'])->name('pages');
Route::get('/pagesections', [FrontController::class, 'pagesections'])->name('pagesections');
Route::get('/pricing', [FrontController::class, 'pricing'])->name('pricing');
Route::get('/cart', [CheckoutController::class, 'cart'])->name('user.plan.cart');
Route::get('/registrationstopurchasepricing/{id}', [FrontController::class, 'registrationspricing'])->name('front.registeration4.view'); 

Route::get('converter', [ProjectController::class, 'imageConverter']);


Route::get('test_editor', [ProjectController::class, 'testEditor']);
Route::get('project/{id}', [ProjectController::class, 'viewProject']);

Route::prefix('domains')->group(function () {
    Route::get('/', [DomainController::class, 'index'])->name('domain.index');
    Route::post('availability', [DomainController::class, 'domainAvailability'])->name('domain.availability');
    Route::post('check-availability', [DomainController::class, 'checkAvailability'])->name('domain.check_availability');
    Route::post('check-ae-availability', [DomainController::class, 'checkAeAvailability'])->name('ae.availability');
});

Route::post('get-stock-images', [AdminController::class, 'getStockImages']);

Route::prefix('project')->group(function () {
  Route::get('view/{id}', [ProjectController::class, 'viewUserProject']);
  Route::get('view/{id}/{pagename}', [ProjectController::class, 'viewUserProject']);  
  Route::post('change-status', [ProjectController::class, 'changeStatus']);
  Route::post('update-web-setting', [ProjectController::class, 'updateWebSetting']);
  Route::post('update-web-settings', [ProjectController::class, 'updateWebSettings']);
  Route::post('update', [ProjectController::class, 'update']);
});
Route::get('/service-details/{slug}/{id}', [FrontController::class, 'blogdetails'])->name('front.blogdetails'); 
Route::get('/registrationstopurchaseproduct/{id}', [FrontController::class, 'registrationsproduct']); 
Route::get('/registrationstopurchase/{id}', [FrontController::class, 'registrations2'])->name('front.registeration2.view');   
Route::get('/registrationsprocess', [FrontController::class, 'registrationsprocess'])->name('front.registrationsprocess.view'); 
Route::post('/registrationsprocess', [FrontController::class, 'registrationsprocess']); 
Route::post('/registrationsprocess', [FrontController::class, 'registrationsprocess']);     Route::post('/addaddon', [CheckoutController::class, 'addaddon'])->name('user.plan.addaddon'); 
Route::post('/addbillinginfo', [CheckoutController::class, 'addbillinginfo'])->name('user.addbilling.info');   
Route::post('/addtoorder', [CheckoutController::class, 'addtoorder'])->name('user.plan.addtoorder'); 
Route::post('/addtocart', [CheckoutController::class, 'addtocart'])->name('user.plan.addtocart'); 
Route::post('/addplan', [CheckoutController::class, 'addplan'])->name('user.plan.addplan');
Route::get('/userdashboard', [UserController::class, 'index'])->name('user-dashboard');
Route::get('/app-setup/{id}', [PaymentLogController::class, 'app_setup'])->name('user.order-log.app-setup');    


Route::post('razorpay/success', 'Payment\RazorpayController@successPayment')->name('membership.razorpay.success');
Route::post('razorpay/cancel', 'Payment\RazorpayController@cancelPayment')->name('membership.razorpay.cancel');
Route::post('txnstatusrazor', [CheckoutController::class, 'txnstatusrazor'])->name('membership.razor.status');
Route::post('txnstatusrenewr', [CheckoutController::class, 'txnstatusrenewr'])->name('membership.razor.txnstatusrenewr');   
Route::post('txnstatusrenewr', [CheckoutController::class, 'txnstatusrenewr'])->name('membership.razor.statusrenew');    
Route::post('/searchdomain', [CheckoutController::class, 'searchdomain'])->name('user.search.domain');    
Route::post('/domain-to-cart', [CheckoutController::class, 'buydomain'])->name('user.buy.domain'); 
Route::post('/ssl-to-cart', [CheckoutController::class, 'ssltocart'])->name('user.cartto.newssl');   
Route::post('/remove-ssl-cart', [CheckoutController::class, 'removesslcart'])->name('user.remove.cartssl');
Route::get('/remove-domain-cart/{id}', [ServicesController::class, 'removedomaincart'])->name('user.remove.domain.cart');
Route::get('/delcart/{id}', [CheckoutController::class, 'delcart'])->name('user.plan.delcart');
Route::get('download/pdf-invoice/{id}', 'PdfController@pdfInvoice')->name('download.order-log.pdf-invoice');
Route::get('download/pdf-invoice/{type}/{id}', 'PdfController@pdfInvoiceType')->name('download.order-log.pdf-invoice-type');
Route::get('/order-log', [PaymentLogController::class, 'order'])->name('user.order-log.order');
Route::post('/buyaddon', [PaymentLogController::class, 'buyaddon'])->name('user.order-log.buyaddon');
Route::get('/cart/{id}',  [PaymentLogController::class, 'usercart'])->name('user.plan.usercart'); 
Route::post('/reneworder',  [CheckoutController::class, 'reneworder'])->name('user.plan.reneworder');
Route::post('/addtocart', [CheckoutController::class, 'addtocart'])->name('user.plan.addtocart');
Route::get('/checksslstatus', [CronJobController::class, 'checksslstatus'])->name('cron.checksslstatus');
Route::get('/testupload', [CronJobController::class, 'testupload'])->name('cron.testupload');
Route::get('/custompricing/{blogid}/{planid}', [CheckoutController::class, 'custompricing'])->name('user.plan.custompricing');
Route::get('/addtocart/{id}', [CheckoutController::class, 'addtocart2'])->name('user.plan.addtocart2');
Route::get('/addtocart/{id}/{uid}', [CheckoutController::class, 'addtocart3'])->name('user.plan.addtocart3');


Route::get('reverse', [DomainController::class, 'reverseIp']);

Route::prefix('cron')->group(function () {
  Route::get('fetch_emails', [CronController::class, 'fetchEmails']);
  Route::get('publish_website', [CronController::class, 'publishWebsite']);
  Route::get('assign_cpanels', [CronController::class, 'assignCpanels'])->name('assign.cpanels');
  Route::get('check_dns', [CronController::class, 'checkPropogation'])->name('propogation.check');
  Route::post('fetch_email', [EmailController::class, 'fetchCustomEmails'])->name('custom_email.fetch_email');
  Route::post('remove_custom_email', [EmailController::class, 'removeCustomEmail'])->name('custom_email.remove_email');
  Route::get('cgi_update_text_file', [CronController::class, 'cgiStatus'])->name('cron.cgi_text_file');
});

Route::get('blog/post/{id}', [BlogController::class, 'viewBlogPost']);
Route::prefix('blog/home')->group(function () {
    Route::get('/', [BlogController::class, 'homepage']);
});


Route::get('svgBackgrounds', [ImageTemplatesController::class, 'getBackgrounds'])->name('svgBackgrounds');
Route::get('getShapes', [ImageTemplatesController::class, 'getShapes'])->name('getShapes');

Route::middleware(['auth'])->group(function () {
    Route::get('dashboard', [ProfileController::class, 'dashboard'])->name('dashboard'); 
});

Route::middleware(['auth', 'role:2'])->group(function () {

    Route::prefix('admin/invoices')->group(function () {
        Route::get('list', [InvoicesController::class, 'list'])->name('invoices.list');
        Route::post('add', [InvoicesController::class, 'add'])->name('invoices.add');
        Route::get('download/{id}', [InvoicesController::class, 'download'])->name('invoices.download');
    });

    Route::prefix('sql')->group(function () {
        Route::get('/{cpanel_id}', [SqlDatabaseController::class, 'list'])->name('sql.list');
        Route::post('add', [SqlDatabaseController::class, 'add'])->name('sql.add');
        Route::post('delete', [SqlDatabaseController::class, 'delete'])->name('sql.delete');
        Route::post('update', [SqlDatabaseController::class, 'update'])->name('sql.update');
    });

    Route::prefix('ecommerce')->group(function () {
        Route::get('subscription', [SubscriptionController::class, 'ecommerceSubscription'])->name('admin.ecommerce.subscriptions');
        Route::post('add', [SubscriptionController::class, 'addNewEcommerceSubscriptionPlan'])->name('admin.ecommerce.subscriptions.add');
        Route::post('delete', [SubscriptionController::class, 'deleteEcommerceSubscription'])->name('admin.ecommerce.subscriptions.delete');
        Route::post('update', [SubscriptionController::class, 'updateEcommerceSubscription'])->name('admin.ecommerce.subscriptions.update');
    });

    Route::prefix('image')->group(function () {
        Route::prefix('section')->group(function () {
            Route::post('add', [AdminController::class, 'addSection']);
            Route::post('delete', [AdminController::class, 'deleteSection']);
            Route::post('update', [AdminController::class, 'updateSection']);
        });
    });
    Route::post('change-image-section', [AdminController::class, 'changeImageSection']);
    Route::post('remove-image-url', [AdminController::class, 'removeImageUrl']);
            Route::get('getBackgrounds', [ImageTemplatesController::class, 'getBackgrounds'])->name('admin.getBackgrounds');
    Route::prefix('admin')->group(function () {
        
        Route::post('addBalance', [AdminController::class, 'addBalance'])->name('admin.addBalance');
        Route::get('getShapes', [ImageTemplatesController::class, 'getShapes'])->name('admin.getShapes');
        
        Route::prefix('ecommerce')->group(function () {
            Route::get('extras', [AdminController::class, 'ecommerceExtraSections'])->name('ecommerce.extras');
            Route::post('addExtra', [AdminController::class, 'addExtraSections'])->name('ecommerce.addExtraSection');
        });

        Route::prefix('image_template')->group(function () {
            Route::get('/', [ImageTemplatesController::class, 'template'])->name('admin.image_template');
            Route::get('edit/{id}', [ImageTemplatesController::class, 'editTemplate'])->name('admin.image_template.edit');
            Route::post('edit', [ImageTemplatesController::class, 'updateTemplate'])->name('admin.image_template.update');
            Route::get('list', [ImageTemplatesController::class, 'listTemplates'])->name('admin.image_template.list');
            Route::post('delete', [ImageTemplatesController::class, 'deleteTemplate'])->name('admin.image_template.delete');
        });


        Route::get('contact-us', [ContactusController::class, 'adminContactus'])->name('admin.contactus');
        Route::post('uploadTemplateImage', [ImageTemplatesController::class, 'uploadImageForTemplate'])->name('admin.image_template.upload_image');

        Route::get('transactions', [TransactionsController::class, 'adminTransactions'])->name('admin.transactions');
        Route::prefix('currency')->group(function () {
            Route::get('settings', [CurrencyController::class, 'settings'])->name('admin.currency_settings');
            Route::post('add', [CurrencyController::class, 'add'])->name('admin.currency.add');
            Route::post('delete', [CurrencyController::class, 'delete'])->name('admin.currency.delete');
            Route::get('edit/{id}', [CurrencyController::class, 'edit'])->name('admin.currency.edit');
            Route::post('update', [CurrencyController::class, 'update'])->name('admin.currency.update');
            Route::post('update_status', [CurrencyController::class, 'update_status'])->name('admin.currency.update_status');
        });

        Route::prefix('blog')->group(function () {
            Route::get('/', [BlogController::class, 'index']);
            Route::any('view/{id}', [BlogController::class, 'viewPost'])->name('admin.blog.view.post');
            Route::any('/add', [BlogController::class, 'addBlog'])->name('admin.blog.add.post');
            Route::post('/delete', [BlogController::class, 'deleteBlog']);
            Route::post('/update', [BlogController::class, 'updateBlog']);
        });


        Route::prefix('cpanel')->group(function () {
            Route::get('/', [CpanelController::class, 'list'])->name('cpanel.list');
            Route::post('add', [CpanelController::class, 'add'])->name('cpanel.add');
            Route::post('connect_cpanel', [CpanelController::class, 'connect'])->name('cpanel.connect');
            Route::post('disconnect_cpanel', [CpanelController::class, 'disconnect'])->name('cpanel.disconnect');
        });


        Route::prefix('whm')->group(function () {
            Route::get('/', [WhmController::class, 'index']);
            Route::post('add', [WhmController::class, 'addWhm']);
            Route::post('delete', [WhmController::class, 'deleteWhm'])->name('whm.delete');
            Route::post('edit', [WhmController::class, 'updateWhm']);
            Route::post('update', [WhmController::class, 'update'])->name('whm.update');
        });

        Route::prefix('ftp')->group(function () {
            Route::get('/', [FtpController::class, 'index']);
            Route::post('/add', [FtpController::class, 'addFtp'])->name('ftps.add');
            Route::post('/remove', [FtpController::class, 'removeFtp']);
            Route::post('/assign', [FtpController::class, 'AssignFtp']);
        });
        Route::get('users', [AdminController::class, 'users']);
        Route::get('domains', [AdminController::class, 'domains']);
        
        Route::get('categories', [AdminController::class, 'categories'])->name('categories.index');
        Route::post('categories', [AdminController::class, 'addCategory'])->name('categories.add');
        Route::post('delete-category', [AdminController::class, 'deleteCategory'])->name('categories.delete');
        Route::post('update-category', [AdminController::class, 'updateCategory'])->name('categories.update');

        Route::get('gallery', [AdminController::class, 'gallery']);
        Route::post('gallery-upload', [AdminController::class, 'imageUploadCategory'])->name('categories.image.upload');

    });
});

Route::middleware(['auth'])->group(function () {
    Route::post('changeYourPassword', [ProfileController::class, 'changeYourPassword'])->name('changeYourPassword');
    Route::post('uploadTempImage', [ImageTemplatesController::class, 'uploadTempImage'])->name('uploadTempImage');
    Route::prefix('domains')->group(function () {
      Route::post('nameservers', [DomainController::class, 'getNameServers']);
      Route::post('update-ns', [DomainController::class, 'updateNs']);
      Route::get('dns/{id}', [DomainController::class, 'showDns']);
      Route::post('dns/delete', [DomainController::class, 'dnsDelete']);
      Route::post('dns/update', [DomainController::class, 'dnsUpdate']);
      Route::post('dns/add', [DomainController::class, 'dnsAdd']);
      Route::post('info', [DomainController::class, 'info']);
    });

    Route::prefix('social')->group(function () {
        Route::prefix('post')->group(function () {
            Route::post('generate_using_ai', [SocialController::class, 'generateUsingAi']);
        });
    });

    Route::prefix('cgi')->group(function () {
        Route::post('merge_video', [CgiUserController::class, 'mergeVideo'])->name('mergeVideo');
        Route::post('video/export', [CgiUserController::class, 'cgiVideoExport'])->name('video.export');
        Route::post('uploadCgiImage', [CgiUserController::class, 'uploadVideoEditorImage'])->name('video.upload.image');
        Route::post('getVideoTemplate', [CgiUserController::class, 'getVideoTemplate'])->name('getVideoTemplate');
    });

});
    

Route::prefix('icon')->group(function () {
    Route::post('search', [LogoController::class, 'searchIcon']);
    Route::post('download', [LogoController::class, 'downloadIcon']);
});


Route::middleware(['auth', 'role:1'])->group(function () {

    Route::post('addAddress', [ProfileController::class, 'addAddress'])->name('addAddress');
    Route::get('setting', [ProfileController::class, 'userSetting'])->name('userSetting');
    Route::get('addresses', [ProfileController::class, 'userAddress'])->name('userAddresses');
    Route::post('addresses', [ProfileController::class, 'updateAddress'])->name('updateAddress');

    Route::prefix('payment')->group(function () {
        Route::post('create-stripe-intent', [PaymentController::class, 'createStripePaymentIntent'])->name('stripe.intent.create');
    });

    Route::prefix('cgi')->group(function () {
        Route::post('getDraft', [CgiUserController::class, 'getDraft'])->name('getDraftUrl');
        Route::post('getDraftDetail', [CgiUserController::class, 'getDraftDetail'])->name('getDraftDetail');
        Route::post('removeDraft', [CgiUserController::class, 'removeDraft'])->name('removeDraft');
        Route::post('saveDraft', [CgiUserController::class, 'saveDraft'])->name('saveDraft');
        Route::post('getUploads', [CgiUserController::class, 'getVideoEditorUploads'])->name('getVideoEditorUploads');
        Route::post('mergeVideoUrls', [CgiUserController::class, 'mergeVideoUrls'])->name('mergeVideoUrls');
        Route::post('video/trim', [CgiUserController::class, 'trimVideo'])->name('trimVideo');
        Route::get('edit/{id}', [CgiUserController::class, 'editCgiOrder'])->name('cgi.editOrder');
        Route::post('upload_glb_file', [CgiUserController::class, 'uploadGlbFile'])->name('cgi.uploadGlbFile');
        Route::post('order/duplicate-with-transaction', [CgiUserController::class, 'createDuplicateOrderWithTranscation'])->name('Cgi.createDuplicateOrderWithTransaction');
        Route::post('order/replace_image', [CgiUserController::class, 'replaceTemplateImage'])->name('cgi.template.replace_edited_image');
        Route::post('order/upload_image', [CgiUserController::class, 'uploadTemplateImage'])->name('cgi.template.upload_image');
        Route::post('order/upload_video', [CgiUserController::class, 'uploadTemplateVideo'])->name('cgi.template.upload_video');
        Route::get('order/create/{template_id}', [CgiUserController::class, 'generateOrder'])->name('cgi.order.generate');
        Route::post('generate', [CgiUserController::class, 'createOrder'])->name('cgi.generate');
        Route::get('orders/{page?}', [CgiUserController::class, 'orders'])
            ->where('page', '[0-9]+')
            ->name('cgi.orders');

        

        Route::get('get', [CgiUserController::class, 'getCgi'])->name('cgi.video_get_information');
        Route::get('checkout', [CgiUserController::class, 'checkout'])->name('cgi.checkout');
        Route::post('createPaymentIntent', [CgiUserController::class, 'createPaymentIntent'])->name('cgi.payment_intent');
        Route::post('addTransactionHistory', [CgiUserController::class, 'addTransactionHistory'])->name('cgi.transaction.add');
        Route::post('deductcgiUsingWallet', [CgiUserController::class, 'deductcgiUsingWallet'])->name('cgi.deductUserBalance');
    });

    Route::prefix('project')->group(function () {
        Route::get('create/{id}', [WebsiteController::class, 'createProject'])->name('ai.website.project.create');
    });
    Route::prefix('transactions')->group(function () {
        Route::post('add', [TransactionsController::class, 'add'])->name('transactions.add');
    });



    Route::prefix('wallet')->group(function () {
        Route::get('/', [WalletController::class, 'index'])->name('user.wallet');
        Route::get('add', [WalletController::class, 'add'])->name('user.wallet.add');
        Route::post('create-stripe-payment-intent', [WalletController::class, 'createStripePaymentIntent']);
        Route::post('create-pending-payment-intent', [WalletController::class, 'createSubscriptionPaymentIntent']);
    });
    
    
    Route::post('delete-reuseable-icons', [ProjectController::class, 'deleteIcon']);
    Route::post('get-uploaded-icons', [ProjectController::class, 'getUploadedIcons']);
    Route::post('upload-icons', [ProjectController::class, 'uploadIcon']);
    Route::post('delete-reuseable-image', [ProjectController::class, 'deleteReusableImage']);
    Route::post('get-uploaded-pictures', [ProjectController::class, 'getUploadedPictures']);
    Route::post('get-images', [ProjectController::class, 'getImages']);
    Route::post('get_pages', [ProjectController::class, 'getPages']);
    Route::post('get-subcategory', [ProjectController::class, 'getSubCategory']);
    Route::post('stock-images', [ProjectController::class, 'stockImages']);
    Route::post('get-theme-sections', [ProjectController::class, 'themeSections']);
    Route::post('get-section-code', [ProjectController::class, 'getSectionCode']);
  
    Route::post('get-pricing-packages', [CrmController::class, 'getPackages']);

   Route::prefix('widgets')->group(function () {
        Route::post('custom_css/add', [WidgetController::class, 'addCustomCss']);
        Route::post('custom_css/get', [WidgetController::class, 'getCustomCss']);
        Route::post('custom_js/add', [WidgetController::class, 'addCustomJs']);
        Route::prefix('whatsapp')->group(function () {
            Route::post('enable', [WidgetController::class, 'enableWhatsapp']);
            Route::post('disable', [WidgetController::class, 'disableWhatsapp']);
        });
        Route::prefix('facebook')->group(function () {
            Route::post('enable', [WidgetController::class, 'enableFacebook']);
            Route::post('disable', [WidgetController::class, 'disableFacebook']);
        });
        Route::prefix('analytics')->group(function () {
            Route::post('enable', [WidgetController::class, 'enableAnalytics']);
            Route::post('disable', [WidgetController::class, 'disableAnalytics']);
        });
   });



    Route::prefix('crm')->group(function () {
        Route::get('/', [CrmController::class, 'dashboard']);
        Route::prefix('projects')->group(function () {
            Route::get('list', [CrmController::class, 'projectsList']);
        });
        Route::post('connect', [CrmController::class, 'crmConnect']);
        Route::prefix('project')->group(function () {
            Route::get('{id}', [CrmController::class, 'viewProject'])->name('project.id');
            Route::get('{id}/users', [CrmController::class, 'projectUsers'])->name('project.users');
            Route::post('user_delete', [CrmController::class, 'userDelete'])->name('project.users.delete');
            Route::get('{id}/subscriptions', [CrmController::class, 'subscriptions'])->name('project.subscriptions');
            Route::post('{id}/subscription/add', [CrmController::class, 'subscriptionAdd'])->name('project.subscription.add');
            Route::get('{id}/subscriptions/active', [CrmController::class, 'activeSubscriptions'])->name('project.subscription.active');
            Route::post('{id}/subscription/delete', [CrmController::class, 'deleteSubscription'])->name('project.subscription.delete');
            Route::get('{id}/transactions', [CrmController::class, 'transactions'])->name('project.transactions');
            Route::get('{id}/create-form', [CrmController::class, 'create_form']);
            Route::post('{id}/create-form', [CrmController::class, 'createForm']);
            Route::get('{id}/inquiries', [CrmController::class, 'inquiries']);
            Route::get('{id}/create-post', [CrmController::class, 'createPosts']);
            Route::get('{id}/posts', [CrmController::class, 'getPosts']);

        });

    });

  


    Route::post('update-pexel-image', [ProjectController::class, 'downloadPixelImage']);
    Route::post('upload-static-image', [ProjectController::class, 'uploadStaticImage']);
    Route::post('search-px-images', [ProjectController::class, 'searchPxImages']);
    Route::post('search-online-images', [ProjectController::class, 'searchOnlineImage']);
    Route::prefix('project')->group(function () {
        Route::get('edit/{id}', [ProjectController::class, 'editProject']);
        Route::get('edit/{id}/{pagename}', [ProjectController::class, 'editProject']);
        Route::post('save_user_file', [ProjectController::class, 'saveUserFile']);
        Route::post('add-using-subscription', [ProjectController::class, 'addUsingSubscription']);
        Route::post('update-details', [ProjectController::class, 'updateDetails'])->name('ai.project.website.update_details');
        Route::post('add-page', [ProjectController::class, 'addPage']);
        Route::post('get-pages', [ProjectController::class, 'getPages']);
        Route::post('remove_page', [ProjectController::class, 'removePage']);
    });
  Route::prefix('user')->group(function () {
      Route::get('subscriptions', [SubscriptionController::class, 'userSubscriptions']);
      Route::prefix('subscriptions')->group(function () {
        Route::get('buy', [SubscriptionController::class, 'buyUser']);
        Route::post('activate', [SubscriptionController::class, 'activate']);
    });
  });
  

  Route::prefix('theme')->group(function () {
    Route::get('get-shape', [ProjectController::class, 'getShape'])->name('theme.getShape');
    Route::post('upload-image', [ProjectController::class, 'uploadThemeImage'])->name('theme.upload_image');
      Route::post('change-user-theme', [ProjectController::class, 'changeUserTheme']);
      Route::post('get-themes', [ProjectController::class, 'getThemes']);
      Route::post('update', [ProjectController::class, 'updateUserTheme']);
      Route::post('generate_ai_content', [ProjectController::class, 'aiContentGenerator']);
      Route::post('update-ai-status', [ProjectController::class, 'updateAiStatus']);
      
      Route::post('get-theme-pages', [ProjectController::class, 'getThemePages']);
      Route::post('get-new-section-content', [ProjectController::class, 'newSectionTheme']);
      Route::post('get-project-details', [ProjectController::class, 'getProjectDetails']);
      Route::post('updateSocialLinks', [ProjectController::class, 'updateSocialLinks'])->name('website.social_links');
  });


  Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
  Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
  Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

  Route::prefix('projects')->group(function () {
    Route::any('add', [ProjectsController::class, 'addproject']);
    Route::any('upload', [ProjectsController::class, 'uploadproject']);
    Route::any('edit/{id}/{id2}', [ProjectsController::class, 'editproject']);
    Route::any('view/{id}', [ProjectsController::class, 'viewproject']);
    Route::get('list', [ProjectsController::class, 'listproject']);
    Route::post('delete', [ProjectsController::class, 'deleteproject']);
    Route::get('deletepage/{id}', [ProjectsController::class, 'deletepage']);
    Route::post('sections', [ProjectsController::class, 'sections']);
    Route::post('themessections', [ProjectsController::class, 'themessections']);
  });

  Route::prefix('domains')->group(function () {
    Route::post('purchase', [DomainController::class, 'purchase']);
    Route::get('list', [DomainController::class, 'list']);
    
    Route::post('set-session', [DomainController::class, 'setSession']);
    Route::get('checkout', [DomainController::class, 'checkout']);
  });
 
    Route::prefix('ai')->group(function () {
        Route::post('content-generate', [AiController::class, 'generateContent'])->name('ai.generate.content');
        Route::prefix('website')->group(function () {
            Route::get('edit/{id}', [WebsiteController::class, 'websiteEditor'])->name('ai.website.editor');
        });
        Route::prefix('themes')->group(function () {
            Route::post('get', [ThemeController::class, 'getThemes'])->name('ai.website.themes.get');
            Route::post('theme_html', [ThemeController::class, 'getHtmlTheme'])->name('ai.website.themes.get_html');
        });
        Route::prefix('websites')->group(function () {
            Route::prefix('purchase')->group(function () {
                Route::post('start', [SubscriptionController::class, 'startPurchase'])->name('ai.website.purchase.start');               
                 Route::post('cancel', [SubscriptionController::class, 'cancelPurchase'])->name('ai.website.purchase.cancel');
                Route::post('save_domain_details', [SubscriptionController::class, 'domainDetails'])->name('ai.website.purchase.save_domain_details');
                Route::post('save-customer-details', [SubscriptionController::class, 'saveCustomerDetails'])->name('aibuilder.purchase.save_customer_details');
                Route::post('remove-domain-session', [SubscriptionController::class, 'removeDomainSession'])->name('ai.website.purchase.remove_domain_session');

            });
        });
    });




});
require __DIR__.'/auth.php';

Route::get('test-icons', [LogoController::class, 'testIcons']);
Route::get('view-theme/{id}', [ThemeController::class, 'viewTheme']);
Route::prefix('website')->group(function () {
    Route::get('view/{id}/{pagename?}', [ThemeController::class, 'viewPublicWebsite']);
  
});

Route::get('run-artisan', function () {
    Artisan::call('optimize');
    Artisan::call('config:clear');
    return "Command Executed";
});

Route::get('sendEmail', [SubscriptionController::class, 'sendTestEmail'])->name('send.test_email');
Route::post('contact-us', [ContactusController::class, 'store'])->name('contactus');
Route::post('subscribeEmail', [ProfileController::class, 'subscribeEmail'])->name('subscribeEmail');
Route::get('/check-php', function () {
    return phpinfo();
});