<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pricing</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="<?php echo e(asset('assets/services/css/pricing.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
    <!-- Font Awesome 5.15.4 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Exo:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: "Exo", sans-serif !important;
        }
    </style>
    <style>
        .nissan-header-main {
            position: relative;
            left: 0;
            top: 0;
            width: 100%;
            z-index: 999;
        }

        .left-bumber-front-style-set {
            width: 60px;
            position: relative;
            background-color: white;
            clip-path: polygon(100% 0%, 100% 100%, 50% 61%, 11% 12%, 24% 0%);
            margin-right: -1px;
        }

        .right-bumber-front-style-set {
            width: 60px;
            position: relative;
            background-color: white;
            clip-path: polygon(0% 0%, 0% 100%, 50% 61%, 89% 12%, 76% 0%);
            margin-left: -1px;
        }

        .left-bmp-style-set-s-d {
            /* Adding backdrop filter for glass blur effect */
            backdrop-filter: blur(15px);
            /* Increase the blur value for more effect */
            -webkit-backdrop-filter: blur(15px);
            /* Safari support */

            /* Optional: You can adjust opacity for a better glass effect */
            opacity: 0.9;
            /* Adjust the transparency to make the effect more prominent */
            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.837),
                    rgba(170, 170, 170, 0.8));

            /* background-color: red; */
            clip-path: polygon(0% 0%,
                    85% 0%,
                    82% 17%,
                    87% 50%,
                    98% 100%,
                    10% 100%,
                    2% 50%);
            margin-right: -45px;
        }

        .left-bmp-style-set-s-d ul {
            margin-right: 60px;
        }

        .left-bmp-style-set-s-d {
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);

            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.837),
                    rgba(170, 170, 170, 0.86));

            clip-path: polygon(0% 0%,
                    85% 0%,
                    82% 17%,
                    87% 50%,
                    98% 100%,
                    10% 100%,
                    2% 50%);
            margin-right: -45px;
        }

        .left-bmp-style-set-s-d ul {
            margin-right: 60px;
        }

        .right-bmp-style-set-s-d {
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);

            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.837),
                    rgba(170, 170, 170, 0.86));

            clip-path: polygon(100% 0%,
                    15% 0%,
                    18% 17%,
                    13% 50%,
                    2% 100%,
                    90% 100%,
                    98% 50%);

            margin-left: -45px;
        }

        .right-bmp-style-set-s-d .welcome-container {
            margin-left: 60px;
        }

        .welcome-container {
            padding: 12px 20px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .welcome-text {
            color: white;
            font-size: 14px;
            font-weight: 400;
            margin: 0;
        }

        .separator {
            color: white;
            margin: 0 4px;
        }

        .avatar {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            object-fit: cover;
            background-color: #ccc;
        }

        .overlay-style-set-d-s {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.342);
            z-index: 10;
            display: none;
            transition: 0.3s;
        }

        .offcanvas-main-sidebar-style-set-d {
            position: fixed;
            left: -300px;
            top: 0;
            min-height: 100vh;
            width: 300px;
            background-color: white;
            z-index: 11;
            /* display: none; */
            transition: 0.3s;
        }

        #sideBarCloseBtn {
            display: block;
            text-align: center;
        }

        .mobile-view-menu-style-set {
            display: none;
        }

        .bottom-icons-sidebar-fixed-style {
            width: 267px;
        }

        .nav-link-style-set-s {
            font-size: 20px;
            text-align: start;
        }

        .sidebar-list-height-set-style {
            height: 100vh;
        }

        .cart-count-style {
            position: absolute;
            right: -7px;
            top: -5px;
            background-color: #000;
            color: white;
            border-radius: 50%;
            width: 17px;
            height: 17px;
            font-size: 12px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media(max-width:550px) {
            .hideMobile {
                display: none !important;
            }
        }

        .nissan-header-main {
            max-width: 100vw;

        }

        .popup-menu {
            position: absolute !important;
            top: 60px;
            /* Adjust based on avatar size */
            right: 150px;
            background: white;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
            border-radius: 5px;
            padding: 10px;
            min-width: 150px;
            z-index: 9999;
            /* Ensure it's always above */
            text-align: left;
            display: none;

        }

        .popup-menu a {
            display: block;
            /* Ensure each link is on a new line */
            padding: 10px;
            text-decoration: none;
            color: black;
            font-size: 14px;
            transition: background 0.3s;
        }

        .popup-menu a:hover {
            background: #f1f1f1;
            border-radius: 3px;
        }
    </style>
    <style>
        .dark-toast {
            border-radius: 12px;
            padding: 12px;
            width: 320px !important;
        }

        .dark-toast-btn {
            background: #3b82f6 !important;
            color: #fff !important;
            border-radius: 8px !important;
            padding: 6px 14px !important;
            font-weight: 600 !important;
            border: none !important;
        }

        .dark-toast-btn:hover {
            filter: brightness(1.1);
        }
        .swal2-toast h2:where(.swal2-title)
        {
            line-height: 0px !important;
        }
        .swal2-toast button:where(.swal2-styled)
        {
            padding: 0px 20px !important;
            height: 30px !important;
        }
    </style>
    <?php echo $__env->yieldContent('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global.css')); ?>">
</head>

<body>

    <main class="content">
        <header class="nissan-header-main py-3">
            <div id="overlayStyleSectionSS"></div>
            <div class="container text-center">
                <div class="d-inline-block">
                    <div class="d-flex">
                        <div class="left-bmp-style-set-s-d d-flex align-items-center pe-5">
                            <ul class="d-flex ps-0 align-items-center mb-0">
                                <li class="mx-5 list-unstyled">
                                    <a href="<?php echo e(url('/cgi/templates')); ?>"
                                        class="text-decoration-none text-white fw-semibold exo">Home</a>
                                </li>
                                <li class="mx-3 list-unstyled hideMobile">
                                    <a href="<?php echo e(url('service')); ?>"
                                        class="text-decoration-none text-white fw-semibold exo">Menu</a>
                                </li>
                            </ul>
                        </div>
                        <div class="left-bumber-front-style-set"></div>
                        <div class="d-flex justify-content-around bg-white mid-menu-style-ss p-2 align-items-center">
                            <div class="mx-4 hideMobile">
                                <a href="#" class="text-black text-decoration-none position-relative">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23"
                                        fill="currentColor" class="bi bi-cart" viewBox="0 0 16 16">
                                        <path
                                            d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5M3.102 4l1.313 7h8.17l1.313-7zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4m7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4m-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2m7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2" />
                                    </svg>
                                </a>
                            </div>
                            <div class="logo mx-4 m-brand-logo hideMobile" style="width:35px;height:35px;">
                                <a href="#"><img src="<?php echo e(asset('assets/logo_maker/img/logo/logo2.png')); ?>"
                                        height="40px" alt="" /></a>
                            </div>
                            <div class="menu-btn mx-4">
                                <button class="bg-transparent border-0 side-bar-style-btn-open-close-s"
                                    id="left-side-menu-btn-set">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30"
                                        fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd"
                                            d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                        <div class="right-bumber-front-style-set hideMobile"></div>
                        <div class="right-bmp-style-set-s-d d-flex align-items-center pe-5 hideMobile">
                            <div class="welcome-container">
                                <?php
                                    $user = 'User';
                                    if (auth()->check()) {
                                        $user = auth()->user()->first_name;
                                    }
                                ?>
                                <span class="welcome-text exo">Welcome <?php echo e(ucfirst($user)); ?> !</span>
                                <span class="separator">—</span>
                                <img id="userAvatar" src="<?php echo e(asset('assets/images/userr.webp')); ?>" alt="User avatar"
                                    class="avatar" />
                            </div>
                        </div>

                        <?php if(auth()->user()): ?>
                            <div id="popupMenu" class="popup-menu">
                                <a href="<?php echo e(url('profile')); ?>">Edit Profile</a>
                                <a href="<?php echo e(route('userSetting')); ?>">Settings</a>
                                <a href="<?php echo e(url('logout')); ?>">Logout</a>
                            </div>
                        <?php else: ?>
                            <div id="popupMenu" class="popup-menu">
                                <a href="<?php echo e(url('login')); ?>">Login</a>
                                <a href="<?php echo e(route('login')); ?>">Register</a>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>
            </div>
        </header>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" type="text/javascript"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <?php echo $__env->yieldContent('js'); ?>
    <script>
        document.getElementById("userAvatar").addEventListener("click", function(event) {
            var menu = document.getElementById("popupMenu");
            menu.style.display = (menu.style.display === "block") ? "none" : "block";
        });
        
        document.addEventListener("click", function(event) {
            var menu = document.getElementById("popupMenu");
            if (event.target.id !== "userAvatar" && !menu.contains(event.target)) {
                menu.style.display = "none";
            }
        });
    </script>
    <script>
        function showToast(icon = 'success', title = 'Done!', message = '', withButton = false, buttonText = 'OK',
            onConfirm = null) {
            Swal.fire({
                toast: true,
                position: 'top-end', // top right
                icon: icon, // success | error | warning | info | question
                title: title,
                text: message,
                showConfirmButton: false,
                timer: 3000, // auto-close after 3s
                timerProgressBar: true,
                background: '#1e1e1e', // dark background
                color: '#fff', // white text
                showConfirmButton: withButton,
                confirmButtonText: buttonText,
                timerProgressBar: true,
            }).then((result) => {
                if (result.isConfirmed && typeof onConfirm === 'function') {
                    onConfirm();
                }
            });
        }
    </script>
</body>

</html>>
<?php /**PATH D:\aflisocial\resources\views/ecommerce/purchase/app.blade.php ENDPATH**/ ?>