<?php $__env->startSection('css'); ?>
<style>
 .glass-card{background:rgba(255,255,255,.15);backdrop-filter:blur(10px);border-radius:14px;border:1px solid rgba(255,255,255,.2)}
 .form-label{color:#fff}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
  <div class="betweenflex mt-3">
    <h4 class="text-white"><?php echo e(isset($link) ? 'Edit Short Link' : 'Create Short Link'); ?></h4>
    <a href="<?php echo e(url('crm/projects/short-links')); ?>" class="btn btn-dark transparent-btn fs-6">Back</a>
  </div>

  <div class="glass-card p-4 mt-3">
    <form method="post" action="<?php echo e(isset($link) ? route('shortlinks.update',$link->id) : route('shortlinks.store')); ?>">
      <?php echo csrf_field(); ?>
      <?php if(isset($link)): ?>
        <?php echo method_field('PUT'); ?>
      <?php endif; ?>
      <div class="row g-3">
        <div class="col-12">
          <label class="form-label">Long URL</label>
          <input type="url" name="long_url" class="form-control" placeholder="https://example.com/very/long/url" value="<?php echo e(old('long_url', $link->long_link ?? '')); ?>" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Custom Slug (optional)</label>
          <input type="text" name="slug" class="form-control <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                 placeholder="Enter custom slug (e.g., my-offer)" 
                 value="<?php echo e(old('slug', $link->backhalf ?? '')); ?>"
                 pattern="[a-zA-Z0-9_-]+"
                 title="Only letters, numbers, hyphens and underscores are allowed">
          <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback d-block">
              <?php echo e($message); ?>

            </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        <div class="col-md-6">
          <label class="form-label">Expiry (optional)</label>
          <input type="datetime-local" name="expires_at" class="form-control" value="<?php echo e(isset($link->expires_at) && $link->expires_at ? $link->expires_at->format('Y-m-d\\TH:i') : ''); ?>">
        </div>
        <?php
            $isPasswordEnabled = $settings->allow_password_protection ?? false;
            $hasPassword = isset($link) && !empty($link->password);
        ?>
        <div class="col-md-6">
          <label class="form-label">Password <?php echo e($isPasswordEnabled ? '(optional)' : '(disabled)'); ?></label>
          <input type="text" name="password" id="password" class="form-control" 
                placeholder="<?php echo e($hasPassword ? 'Enter new password (leave blank to keep)' : 'Enter password'); ?>"
                <?php echo e(!$isPasswordEnabled ? 'disabled' : ''); ?>>
          <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small mt-1"><?php echo e($message); ?></div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
          <?php if($hasPassword): ?>
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" value="1" id="password_off" name="password_off" 
                    <?php echo e(!$isPasswordEnabled ? 'disabled' : ''); ?>>
              <label class="form-check-label text-white" for="password_off">Remove password</label>
            </div>
          <?php endif; ?>
        </div>
        <div class="col-md-6 d-flex align-items-end">
          <div class="form-check">
            <input type="hidden" name="generate_qr" value="0">
            <input class="form-check-input" type="checkbox" value="1" id="generate_qr" name="generate_qr" <?php echo e(old('generate_qr', isset($link) ? ($link->generate_qr ?? true) : true) ? 'checked' : ''); ?>>
            <label class="form-check-label text-white" for="generate_qr">Generate QR</label>
          </div>
        </div>
      </div>
      <div class="text-end mt-3">
        <button class="btn btn-primary"><?php echo e(isset($link) ? 'Update' : 'Create'); ?></button>
      </div>
    </form>
  </div>
  <?php if(isset($link)): ?>
    <div class="glass-card p-3 mt-3">
      <div class="text-white-50">Current short link:</div>
      <a href="<?php echo e($link->short_link); ?>" target="_blank"><?php echo e($link->short_link); ?></a>
    </div>
  <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shortlink::app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shortlink/public_html/packages/ShortLink/src/Providers/../resources/views/create.blade.php ENDPATH**/ ?>