
<?php $__env->startSection('css'); ?>
    <style>
        .card__cta
        {
            padding-top: 20px !important;
            padding-bottom: 10px;
            height: 60px !important;
        }

        .pricing-section .fa
        {
            padding: 0px !important;
        }
        .btn-topper
        {
            padding: 10px 20px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="pricing-section py-5">
        <div class="container">

            <div class="wrap mb-4">
                <div class="">
                    <h1 class="main__heading mb-0 me-3 text-dark fw-bold">Pricing For</h1>
                </div>
                <a class="btn btn-info btn-topper fw-bold" href="#" role="button" data-bs-toggle="dropdown"
                aria-expanded="false">
                <span id="selected"><i class="fa fa-globe"></i> AI Website</span>
            </a>
            </div>
            <div class="">
                <div class="main__cards cards">
                    <div class="cards__inner">
                        <?php if(!$packages->isEmpty()): ?>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="cards__card card monthly">
                                    <h2 class="card__heading"><?php echo e($package->name); ?></h2>
                                    <p class="card__price"><?php echo e(currency_symbol()); ?> <?php echo e($package->price); ?></p>
                                    <ul role="list" class="card__bullets flow">
                                        <?php
                                            $features = json_decode($package->features);
                                        ?>

                                        <?php if(!empty($features)): ?>
                                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <?php echo e($feature); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        <li>
                                            <?php echo e($package->emails ?? "0"); ?> Professional Emails
                                        </li>
                                    </ul>
                                    <a href="javascript:void(0)" class="card__cta cta start_purchase"
                                        data-price="<?php echo e($package->price); ?>" data-id="<?php echo e($package->id); ?>">Get Started</a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="overlay cards__inner"></div>
                </div>
            </div><!-- Monthly -->
        </div><!-- container -->
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        $(document).on('click', '.start_purchase', function() {
            var id = $(this).attr('data-id');
            var url = "<?php echo e(route('aibuilder.purchase.start')); ?>";
            var btn = $(this);
            var btn_html = btn.html();
            let authUser = null;
            <?php if(auth()->check()): ?>
                authUser = <?php echo e(auth()->id()); ?>;
            <?php endif; ?>

            if(!authUser)
            {
                showToast('info', 'Session Expired', 'Please log in to continue.', true, 'Login', () => {
                    window.location.href = '/login';
                });
                return;
            }
            
            btn.html("<span class='fa fa-spinner fa-spin'></span> Please wait");
            var data = {
                _token: '<?php echo e(csrf_token()); ?>',
                id: id
            };
            
            $.post({
                url: url,
                data: data,
                dataType: 'json', // Force JSON parsing
                success: function(data) {
                    btn.html(btn_html);
                    if(!data.result)
                    {
                        generalError(data.msg ?? "Some error occured");
                        return;   
                    }
                    location.href = "<?php echo e(route('ai.website.purchase.step1')); ?>";
                },
                error: function(xhr) {
                    btn.html(btn_html);
                    generalError("Some error occurred");
                    console.error(xhr.responseText);
                }
            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('aibuilder.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/aibuilder/pricing.blade.php ENDPATH**/ ?>