
<?php $__env->startSection('css'); ?>
<link href="<?php echo e(asset('assets/services/css/cms-style.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('assets/services/css/main.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('assets/services/css/company-details.css')); ?>" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="<?php echo e(asset('assets/services/css/countrySelect.min.css')); ?>">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
<style>
    .iti {
        width: 100%;
    }

    .iti__flag-box,
    .iti__country-name {
        color: #000;
    }

    .red_border {
        border-color: red !important;
    }
</style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="company-details-page" style="padding-top:0px !important;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="nestcart-table"style="padding-top:10px !important;">
                    <div class="card rounded-0 transparent-bg">
                        <div class="card-body p-lg-5">
                            <h5 class="mb-0 fw-bold exo">Create the following for your billing details :</h5>
                            <hr>
                            <form class="row g-3">
                                <div class="col-6">
                                    <label for="form-label">First Name</label>
                                    <input type="text" name="first_name" id="first_name" class="form-control"
                                        placeholder="First name" value="<?php if(!empty($customer)){echo $customer->first_name;} ?>" />
                                </div>
                                <div class="col-6">
                                    <label for="form-label">Last Name</label>
                                    <input type="text" name="last_name" id="last_name" class="form-control"
                                        placeholder="Last name" value="<?php if(!empty($customer)){echo $customer->last_name;} ?>">
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Address</label>
                                    <textarea class="form-control" id="address" name="address" placeholder="Address"><?php if(!empty($customer)){echo $customer->address;} ?></textarea>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">City</label>
                                    <input type="text" class="form-control" id="city" placeholder="City" value="<?php if(!empty($customer)){echo $customer->city;} ?>" />
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">Zip Code</label>
                                    <input type="text" id="zipcode" class="form-control"
                                        placeholder="Zip Code"  value="<?php if(!empty($customer)){echo $customer->zipcode;} ?>" />
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">State</label>
                                    <input type="text" id="state" class="form-control"  value="<?php if(!empty($customer)){echo $customer->state;} ?>" placeholder="State" />
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">Country</label>
                                    <input type="text" id="country_selector" class="form-control"
                                        placeholder="Country" />
                                </div>
                                <div class="col-md-12">
                                    <label for="form-label">Phone Number</label>
                                    <input type="text" class="form-control" id="mobile_code"
                                        placeholder="Phone Number" value="<?php if(!empty($customer)){echo $customer->phone_number;} ?>" style="width:100%;">
                                </div>
                                <div class="col-12 text-end">
                                    <a href="javascript:void(0)" class="btn btn-transparent text-white"
                                        id="saveCustomerDetails">Save</a>
                                    <a href="javascript:void(0)" class="btn btn-transparent text-white"
                                        id="cancelPurchase">Cancel</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div><!--/*col -->
        </div><!--/*row -->
    </div><!--/*container -->
</section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>

<script src="<?php echo e(asset('assets/services/js/countrySelect.min.js')); ?>"></script>
<?php 
$prefCountry = null;
if(!empty($customer))
{
    if($customer->country)
    {
        $prefCountry = $customer->country;
    }
}

?>
<script>

    var prefCountry = "<?php echo e($prefCountry); ?>";
    
    $("#country_selector").countrySelect({
        preferredCountries: ['ca', 'gb', 'us']
    });

    if (prefCountry) {
        $("#country_selector").countrySelect("setCountry", prefCountry.toLowerCase());
    }
</script>
<script>
    const input = document.querySelector("#mobile_code");
    let iti = window.intlTelInput(input, {
        loadUtilsOnInit: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.7.0/build/js/utils.js",
    });
    $("#country_selector").on("change", function() {
        const selectedCountry = $("#country_selector").countrySelect("getSelectedCountryData");
        input.value = selectedCountry.dialCode ? `+${selectedCountry.dialCode}` : '';
    });
</script>

<script>
    $(document).on('click', '#cancelPurchase', function() {
        var url = "<?php echo e(route('ai.website.purchase.cancel')); ?>";
        var data = {
            _token: '<?= csrf_token() ?>'
        };
        $.post(url, data, function() {
            var purchaseStartUrl = "<?php echo e(route('ai.website.pricing')); ?>";
            location.href = purchaseStartUrl;
        });
    });
</script>
<script>
    $(document).on('click', '#saveCustomerDetails', function() {
        // Remove red borders from all form controls
        $(".form-control").removeClass('red_border');

        // Retrieve form values
        const fn = $("#first_name").val().trim();
        const ln = $("#last_name").val().trim();
        const address = $("#address").val().trim();
        const city = $("#city").val().trim();
        const state = $("#state").val().trim();
        const zipcode = $("#zipcode").val().trim();
        const phoneNumberInput = $("#mobile_code").val().trim();

        // Get country details
        const countryData = $("#country_selector").countrySelect("getSelectedCountryData");
        const countryName = countryData.name.split('(')[0].trim(); // Extract clean country name
        const iso2 = countryData.iso2;

        // Get phone details
        const dialCode = iti.getSelectedCountryData().dialCode;
        let phoneNumber = phoneNumberInput.startsWith(`+${dialCode}`) ?
            phoneNumberInput.replace(`+${dialCode}`, '').trim() :
            phoneNumberInput;

        // Validate fields
        let hasError = false;
        $(".form-control").each(function() {
            if (!$(this).val().trim()) {
                $(this).addClass('red_border');
				$(this).focus()
                generalError("Please fill in all required fields");
                hasError = true;
                return false; // Break the loop
            }
        });

        if (hasError) return; // Stop execution if there are validation errors

        // Prepare data for submission
        const data = {
            first_name: fn,
            last_name: ln,
            address: address,
            city: city,
            state: state,
            country: countryName,
            iso2: iso2,
            dial_code: dialCode,
            phone_number: phoneNumber,
            _token: '<?= csrf_token() ?>',
            zip:zipcode
        };

        // Send AJAX request
        const url = "<?php echo e(route('ai.website.purchase.save_customer_details')); ?>";
        $.post(url, data, function(result) {
			if(result.result)
			{
				var url = "<?php echo e(route('ai.website.purchase.checkout')); ?>";
				location.href = url;
				
			}else{
				generalError("Some error occured");
			}
        }).fail(function(error) {
            console.error("Error:", error);
            generalError("An error occurred while saving the details.");
        });
    });


    $(document).on('input', '.form-control', function() {
        if ($(this).hasClass('red_border')) {
            $(this).removeClass('red_border');
        }
    });

    function generalError(msg) {
        $.confirm({
            title: "Error",
            content: msg,
            icon: "fa fa-times-circle",
            type: "red",
            buttons: {
                confirm: {
                    text: 'OK',
                    btnClass: 'btn-red',
                    action: function() {}
                }
            }
        });
    }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('aibuilder.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/aibuilder/customer_details.blade.php ENDPATH**/ ?>