
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="betweenflex mt-5">
        <h4 class="text-white exo">Subscriptions </h4>
        <a href="<?php echo e(route('ai.website.pricing')); ?>" class="btn btn-dark transparent-btn fs-6">Add</a>
    </div>

    <div class="nestcart-table 1table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <td class="rounded-top-left fw-semibold">Product</td>
                    <td align="center" class="fw-semibold">Domain</td>
                    <td align="center" class="fw-semibold">Email</td>
                    <td align="right" class="fw-semibold">Expiration</td>
                </tr>
            </thead>
            <tbody>

                <?php if(!$subscriptions->isEmpty()): ?>
                    <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $subscriptionName = '';
                            $transactionId = 'Not Found';
                            $totalPrice = 0;
                            $projectExpired = false;
                            $subscriptionData = DB::table('subscriptions')
                                ->where('id', $subscription->subscription_id)
                                ->first();
                            if (!empty($subscriptionData)) {
                                $subscriptionName = $subscriptionData->name;
                                $totalPrice += $subscriptionData->price;
                            }

                            $transactionData = DB::table('transactions')
                                ->where('id', $subscription->transaction_id)
                                ->first();
                            if (!empty($transactionData)) {
                                $transactionId = $transactionData->transaction_id;
                            }
                            $domain = 'No domain linked';
                            $domainPrice = "$0";
                            $domainStatus = '';
                            $domainExists = false;
                            $domainId = 0;

                            $domainStatus = 'Domain not linked';
                            $domainClass = 'bg-danger';

                            $getDomain = DB::table('domains')
                                ->where('user_subscription_id', $subscription->id)
                                ->first();
                            if (!empty($getDomain)) {
                                $domain = $getDomain->domain;

                                $domainPrice = $getDomain->price;
                                $totalPrice += $domainPrice;
                                $domainId = $getDomain->id;
                                $domainExists = true;
                                if ($getDomain->status == 'completed') {
                                    $domainStatus = 'Hosting Pending';
                                }

                                if ($getDomain->status == 'propogation_pending') {
                                    $domainStatus = 'DNS Propogation Pending';
                                    $domainClass = 'bg-warning';
                                } elseif ($getDomain->status == 'connected') {
                                    $domainStatus = 'Connected';
                                    $domainClass = 'bg-success';
                                }
                            }

                            $brandName = 'Not Set';
                            $projectDetails = DB::table('projects')
                                ->where('user_subscription_id', $subscription->id)
                                ->first();
                            if (!empty($projectDetails)) {
                                $brandName = $projectDetails->brand_name;
                            }

                            if ($subscription->expires_on >= now()) {
                                $projectExpired = true;
                            }

                        ?>
                        <tr>
                            <td>
                                <div class="dropdown">
                                    <a class="1dropdown-toggle domain" data-bs-toggle="dropdown" aria-expanded="false">
                                        <?php echo e($brandName); ?>

                                    </a>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#">Renew</a></li>
                                        <li><a class="dropdown-item" href="#">Upgrade</a></li>
                                    </ul>
                                </div>
                                <span class="gray-text text-uppercase">AI Website (<?php echo e($subscriptionName); ?>)</span>
                            </td>
                            <td align="center">
                                <span class="circle-block position-relative">
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo e($domainStatus); ?>"
                                        class="circle <?php echo e($domainClass); ?>"></span>
                                    <div class="dropdown">
                                        <a class="1dropdown-toggle domain" data-bs-toggle="dropdown" aria-expanded="false">
                                            <?php echo e(ucfirst($domain)); ?>

                                        </a>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="https://nestcart.ai/user">User</a></li>
                                            <li><a class="dropdown-item" href="https://nestcart.ai/seller">Seller</a></li>
                                            <li><a class="dropdown-item" href="https://nestcart.ai/admin">Admin</a></li>
                                            <li><a class="dropdown-item" href="#" data-bs-toggle="modal"
                                                    data-bs-target="#domainChange">Change</a></li>
                                        </ul>
                                    </div>
                                </span>

                                <?php
                                    $getProject = DB::table('projects')
                                        ->where('user_subscription_id', $subscription->id)
                                        ->first();
                                    $projectUrl = route('aiBuilder.details', ['id' => $subscription->id]);
                                    if (!empty($getProject)) {
                                        $projectUrl = route('aiBuilder.editor', ['id' => $subscription->id]);
                                    }
                                ?>

                                <a class="btn btn-dark btn-sm transparent-btn mt-1 me-1"
                                    href="<?php echo e($projectUrl); ?>">Editor</a>
                                <a href="<?php echo e(url('project/create/' . $subscription->id)); ?>"><svg
                                        xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-gear-fill text-dark" viewBox="0 0 16 16">
                                        <path
                                            d="M9.405 1.05c-.413-1.4-2.397-1.4-2.81 0l-.1.34a1.464 1.464 0 0 1-2.105.872l-.31-.17c-1.283-.698-2.686.705-1.987 1.987l.169.311c.446.82.023 1.841-.872 2.105l-.34.1c-1.4.413-1.4 2.397 0 2.81l.34.1a1.464 1.464 0 0 1 .872 2.105l-.17.31c-.698 1.283.705 2.686 1.987 1.987l.311-.169a1.464 1.464 0 0 1 2.105.872l.1.34c.413 1.4 2.397 1.4 2.81 0l.1-.34a1.464 1.464 0 0 1 2.105-.872l.31.17c1.283.698 2.686-.705 1.987-1.987l-.169-.311a1.464 1.464 0 0 1 .872-2.105l.34-.1c1.4-.413 1.4-2.397 0-2.81l-.34-.1a1.464 1.464 0 0 1-.872-2.105l.17-.31c.698-1.283-.705-2.686-1.987-1.987l-.311.169a1.464 1.464 0 0 1-2.105-.872zM8 10.93a2.929 2.929 0 1 1 0-5.86 2.929 2.929 0 0 1 0 5.858z">
                                        </path>
                                    </svg></a>
                            </td>
                            <td align="center">
                                <div class="dropdown">
                                    <a class="1dropdown-toggle domain" data-bs-toggle="dropdown" aria-expanded="false">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                            <path
                                                d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z">
                                            </path>
                                        </svg>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item createEmail" data-domainname="<?php echo e($domain); ?>"
                                                data-domain="<?php echo e($domainExists); ?>" data-domainId="<?php echo e($domainId); ?>"
                                                href="javascript:void(0)">Create</a></li>
                                        <li><a class="dropdown-item manageEmail" data-domainname="<?php echo e($domain); ?>"
                                                data-domain="<?php echo e($domainExists); ?>" data-domainId="<?php echo e($domainId); ?>"
                                                href="javascript:void(0)">Manage</a></li>
                                        <li><a class="dropdown-item" href="#">Login</a></li>
                                    </ul>
                                </div>
                            </td>
                            <td align="right" class="text-warning">
                                <div class="dropdown">
                                    <a class="1dropdown-toggle domain text-warning" data-bs-toggle="dropdown"
                                        aria-expanded="false">
                                        <?php echo e(currency_symbol()); ?><?php echo e($totalPrice); ?>/mo
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#">Renew</a></li>
                                        <li><a class="dropdown-item" href="#">Upgrade</a></li>
                                        <li><a class="dropdown-item" href="#" data-bs-toggle="modal"
                                                data-bs-target="#expirationCancel">Cancel</a></li>
                                    </ul>
                                </div>
                                <span class="gray-text">
                                    <?php echo e(date('M d Y', strtotime($subscription->expires_on))); ?>

                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <nav aria-label="Page navigation example">
        <ul class="pagination justify-content-end">
            <!-- Previous Page Link -->
            <?php if($subscriptions->onFirstPage()): ?>
                <li class="page-item disabled">
                    <a class="page-link">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            class="bi bi-chevron-left" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0" />
                        </svg>
                    </a>
                </li>
            <?php else: ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($subscriptions->previousPageUrl()); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            class="bi bi-chevron-left" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0" />
                        </svg>
                    </a>
                </li>
            <?php endif; ?>

            <!-- Page Numbers -->
            <?php $__currentLoopData = $subscriptions->getUrlRange(1, $subscriptions->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="page-item <?php echo e($subscriptions->currentPage() == $page ? 'active' : ''); ?>">
                    <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Next Page Link -->
            <?php if($subscriptions->hasMorePages()): ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($subscriptions->nextPageUrl()); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            class="bi bi-chevron-right" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708" />
                        </svg>
                    </a>
                </li>
            <?php else: ?>
                <li class="page-item disabled">
                    <a class="page-link">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            class="bi bi-chevron-right" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708" />
                        </svg>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </nav>



    <div class="modal fade" id="emailManage" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content modal-content-transparent transparent-bg">
                <div class="modal-header border-0">

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Email</th>
                                <th class="text-center">Password</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody id="appendCustomEmails">

                        </tbody>
                    </table>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-transparent" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary btn-transparent">Save</button>
                </div>
            </div>
        </div>
    </div><!--/*emailManage*/-->

    <div class="modal fade" id="emailCreate" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content modal-content-transparent transparent-bg">
                <div class="modal-header border-0">

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <input type="text" id="customEmailUsername" class="form-control" placeholder="Username" />
                        <label class="text-white fs-6" id="emailDomain">@nestcart.ai</label>
                    </div>

                    <div class="mb-3 position-relative">
                        <form class="needs-validation" novalidate action="#" method="#" onsubmit="return false">
                            <input type="password" class="form-control input-password" id="customEmailPassword"
                                minlength="8" name="password" placeholder="Password" value="" required />
                            <span toggle="#validationPassword" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                            <div class="progress" style="height:2px;">
                                <div id="progressbar" class="progress-bar progress-bar-striped progress-bar-animated"
                                    role="progressbar" style="width: 0%;" aria-valuenow="50" aria-valuemin="0"
                                    aria-valuemax="100"></div>
                            </div>
                            <div id="feedbackin" class="valid-feedback">Strong Password!</div>
                            <div id="feedbackirn" class="invalid-feedback">Atlead 8 characters, Number,
                                special character Caplital Letter and Small letters</div>
                        </form>
                    </div>
                    <div class="mb-3 position-relative">
                        <input type="password" id="customEmailConfirmPassword" class="form-control input-password2"
                            placeholder="Confirm Password" />
                        <span toggle="#confirm_password" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                        <span id="confirm_password_msg"></span>
                    </div>
                </div><!--/*modal-body*/-->
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-transparent text-white" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" id="createCustomEmail" class="btn btn-primary btn-transparent">Save</button>
                </div>
            </div>
        </div>
    </div><!--/*emailCreate*/-->



<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        $(document).on('click', '.expiry_popup', function() {
            var title = $(this).attr('data-title');
            var msg = $(this).attr('data-msg');
            $.confirm({
                title: title,
                content: msg,
                icon: 'fa fa-times-circle', // Green check icon
                type: 'red', // Green color for the icon
                buttons: {
                    recharge: {
                        text: 'Buy New Subscription',
                        btnClass: 'btn-green',
                        action: function() {
                            var url = '<?= url('ai/websites/pricing') ?>';
                            location.href = url;
                        }
                    },
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }

                }
            });

        });
    </script>
    <script>
        $(document).on('click', '.manageEmail', function() {

            var domain = $(this).attr('data-domain');

            if (!domain) {
                error("No Domain Linked With The Project");
                return;
            }
            var domainId = $(this).attr('data-domainId');
            var domainName = $(this).attr('data-domainname');
            $("#emailManage").modal('show');

            fetchCreatedEmails(domainId)

        });

        function fetchCreatedEmails(domainId) {
            var data = {
                domainId: domainId,
                _token: "<?php echo e(csrf_token()); ?>"
            };
            var url = "<?php echo e(route('custom_email.fetch_email')); ?>";
            $("#appendCustomEmails").html("");
            $.post(url, data, function(data) {
                if (!data.result) {
                    var msg = "Some error occured";
                    if (data.msg) {
                        msg = data.msg;
                    }
                    error(msg);
                    return;
                }

                var emails = data.emails

                if (data.emails.length > 0) {
                    console.log(data.emails);
                    data.emails.forEach(email => {

                        var stringEmail = '<tr>\
                            <td>' + email.email + '</td>\
                            <td align="center">************</td>\
                            <td align="center">\
                                <a href="javascript:void(0)" class="text-danger removeEmail" data-id="' + email.id + '"><svg\
                                        xmlns="http://www.w3.org/2000/svg" width="16" height="16"\
                                        fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">\
                                        <path\
                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />\
                                        <path\
                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />\
                                    </svg></a>\
                            </td>\
                        </tr>';

                        $("#appendCustomEmails").append(stringEmail);

                    });
                }





            }).fail(function() {
                error("Some error occured");
            })
        }
    </script>
    <script>
        $(document).on('click', '.createEmail', function() {

            var domain = $(this).attr('data-domain');
            if (!domain) {
                error("No Domain Linked With The Project");
                return;
            }
            var domainId = $(this).attr('data-domainId');
            var domainName = $(this).attr('data-domainname');
            $("#emailDomain").html("@" + domainName);
            $("#createCustomEmail").attr('data-domainId', domainId);
            $("#emailCreate").modal('show');

        });

        function error(msg) {
            $.confirm({
                title: "Error",
                content: msg,
                icon: 'fa fa-times-circle', // Green check icon
                type: 'red', // Green color for the icon
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }
                }
            });
        }
    </script>
    <script>
        $(document).on('click', '.removeEmail', function() {
            var btn = $(this);
            var id = $(this).attr('data-id');
            var data = {
                id: id,
                _token: "<?php echo e(csrf_token()); ?>"
            };
            var url = "<?php echo e(route('custom_email.remove_email')); ?>";
            $.post(url, data, function(data) {
                if (!data.result) {
                    var msg = "Some error occured";
                    if (data.msg) {
                        msg = data.msg
                    }
                    error(msg);
                    return;
                }

                btn.closest('tr').remove();

            });
        });
    </script>
    <script>
        $("#createCustomEmail").on('click', function() {
            var domain = $(this).attr('data-domainId');
            if (!domain) {
                error("Please select domain Id");
                return;
            }
            var email = $("#customEmailUsername").val();
            if (!email) {
                error("Please enter email");
                return;
            }

            var password = $("#customEmailPassword").val();
            if (!password) {
                error("Please enter confirm password");
                return;
            }
            var confirmPassword = $("#customEmailConfirmPassword").val();
            if (!confirmPassword) {
                error("Please enter confirm password");
                return;
            }

            if (password != confirmPassword) {
                error("Both password doesnt changed");
                return;
            }

            var passwordStrength = calculatePasswordStrength(password);
            if (passwordStrength < 50) {
                error("Password strength should be stronger");
                return;
            }

            var data = {
                email: email,
                password: password,
                domainId: domain,
                _token: "<?php echo e(csrf_token()); ?>"
            };
            var url = "<?php echo e(route('custom_email.add')); ?>";

            $.post(url, data, function(data) {
                if (!data.result) {
                    var msg = "Some error occured";
                    if (data.msg) {
                        msg = data.msg;
                    }
                    error(msg);
                    return;
                }

                $.confirm({
                    title: "Email created",
                    content: "Email Created successfully",
                    icon: 'fa fa-check-circle', // Green check icon
                    type: 'green', // Green color for the icon
                    buttons: {
                        confirm: {
                            text: 'OK',
                            btnClass: 'btn-green',
                            action: function() {
                                location.reload()
                            }
                        }
                    }
                });


            });



        });

        $("#customEmailPassword").on('focusout', function() {
            var password = $(this).val();
            var strength = calculatePasswordStrength(password);
            $("#progressbar").css('width', strength + '%');
            $("#feedbackin").hide();
            $("#feedbackirn").hide();

            if (strength >= 80) {
                $("#progressbar").css('background-color', 'green');
                $("#feedbackin").show();
                $("#feedbackin").html("Strong Password");
            } else if (strength >= 50) {
                $("#progressbar").css('background-color', 'orange');
                $("#feedbackin").show();
                $("#feedbackin").html("Weak Password");
            } else {
                $("#progressbar").css('background-color', 'red');
                $("#feedbackirn").html("Weak Password");
                $("#feedbackirn").show();
            }
        });

        function calculatePasswordStrength(password) {
            let score = 0;
            if (password.length >= 8) score += 20;
            if (password.length >= 12) score += 10;
            if (/[a-z]/.test(password)) score += 20; // Lowercase
            if (/[A-Z]/.test(password)) score += 20; // Uppercase
            if (/[0-9]/.test(password)) score += 20; // Numbers
            if (/[\W_]/.test(password)) score += 20; // Special characters
            if (/^(password|123456|qwerty|letmein|admin)$/i.test(password)) score -= 30;
            return Math.max(0, Math.min(100, score));
        }
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('aibuilder.app_with_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/aibuilder/subscriptions.blade.php ENDPATH**/ ?>