
<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('assets/services/css/checkout.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        .form-control:focus {
            background: transparent !important;
        }

        .jconfirm .jconfirm-box div.jconfirm-title-c .jconfirm-title {
            color: black !important;
        }

        .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content {
            color: black !important;
        }
        .is-disabled { pointer-events: none; opacity: .6; }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="checkout-page spad-2">
        <div class="container">
            <h2 class="exo">Website AiBuilder Checkout</h2>
            <div class="row g-4">
                <div class="col-lg-4">
                    <div class="card transparent-bg card-left">
                        <div class="card-body">
                            <div class="row g-2">
                                <div class="col-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        fill="currentColor" class="bi bi-pc-display-horizontal text-dark"
                                        viewBox="0 0 16 16">
                                        <path
                                            d="M1.5 0A1.5 1.5 0 0 0 0 1.5v7A1.5 1.5 0 0 0 1.5 10H6v1H1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1h-5v-1h4.5A1.5 1.5 0 0 0 16 8.5v-7A1.5 1.5 0 0 0 14.5 0zm0 1h13a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-7a.5.5 0 0 1 .5-.5M12 12.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0m2 0a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0M1.5 12h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1 0-1M1 14.25a.25.25 0 0 1 .25-.25h5.5a.25.25 0 1 1 0 .5h-5.5a.25.25 0 0 1-.25-.25" />
                                    </svg>
                                </div><!--/*col -->
                                <div class="col-6 text-end">
                                    <p>Ai website</p>
                                    <h6 class=""><?php echo e(currency_symbol()); ?> <?php echo e($subscriptionPrice); ?> </h6>
                                </div><!--/*col -->
                                <div class="col-1 text-end">
                                    <a href="<?php echo e(route('ai.website.pricing')); ?>" data-bs-toggle="tooltip"
                                        data-bs-placement="top" data-bs-title="Edit"><svg xmlns="http://www.w3.org/2000/svg"
                                            width="16" height="16" fill="currentColor"
                                            class="bi bi-pencil text-white" viewBox="0 0 16 16">
                                            <path
                                                d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325" />
                                        </svg></a>
                                </div><!--/*col -->
                                <div class="col-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        fill="currentColor" class="bi bi-globe2 text-dark" viewBox="0 0 16 16">
                                        <path
                                            d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z">
                                        </path>
                                    </svg>
                                </div><!--/*col -->
                                <div class="col-6 text-end">
                                    <p>
                                        <?php echo e($domain_name); ?>

                                    </p>
                                    <h6 class=""><?php echo e(currency_symbol()); ?> <?php echo e($domainPrice); ?> </h6>
                                </div><!--/*col -->
                                <div class="col-1 text-end">
                                    <a href="<?php echo e(route('ai.website.purchase.step1')); ?>" data-bs-toggle="tooltip"
                                        data-bs-placement="top" data-bs-title="Edit"><svg xmlns="http://www.w3.org/2000/svg"
                                            width="16" height="16" fill="currentColor"
                                            class="bi bi-pencil text-white" viewBox="0 0 16 16">
                                            <path
                                                d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325" />
                                        </svg></a>
                                </div><!--/*col -->
                                <div class="col-12">
                                    <hr />
                                </div><!--/*col -->

                                <div class="col-6">
                                    <p>Sub Total</p>
                                </div><!--/*col -->
                                <div class="col-6 text-end">
                                    <p><?php echo e(currency_symbol()); ?> <?php echo e($total_price); ?> </p>
                                </div><!--/*col -->
                                <div class="col-6">
                                    <p>Tax</p>
                                </div><!--/*col -->
                                <div class="col-6 text-end">
                                    <p><?php echo e(currency_symbol()); ?> 0.00</p>
                                </div><!--/*col -->

                                <div class="col-6">
                                    <h5 class="exo">Total</h5>
                                </div><!--/*col -->
                                <div class="col-6 text-end">
                                    <p><?php echo e(currency_symbol()); ?> <?php echo e($total_price); ?> </p>
                                </div><!--/*col -->


                            </div><!--/*row -->

                        </div><!--/*card-body -->
                    </div><!--/*card -->
                </div><!--/*col -->

                <div class="col-lg-8">
                    <nav class="my-4">
                        <div class="nav nav-tabs border-0" id="nav-tab" role="tablist">
                            <button class="nav-link active" id="nav-credit-card-tab" data-bs-toggle="tab"
                                data-bs-target="#nav-credit-card" type="button" role="tab"
                                aria-controls="nav-credit-card" aria-selected="true">Credit Card</button>
                            <button class="nav-link" id="nav-paypal-tab" data-bs-toggle="tab" data-bs-target="#nav-paypal"
                                type="button" role="tab" aria-controls="nav-paypal"
                                aria-selected="false">Wallet</button>
                            <button class="nav-link" id="nav-paypal-credit-tab" data-bs-toggle="tab"
                                data-bs-target="#nav-paypal-credit" type="button" role="tab"
                                aria-controls="nav-paypal-credit" aria-selected="false">PayPal</button>
                        </div>
                    </nav><!--/*nav -->
                    <div class="tab-content" id="nav-tabContent">
                        <div class="tab-pane fade show active" id="nav-credit-card" role="tabpanel"
                            aria-labelledby="nav-credit-card-tab" tabindex="0">
                            <ul class="list-inline">
                                <li class="list-inline-item">
                                    <a href="#"><svg class="icon--full-color" viewBox="0 0 38 24"
                                            xmlns="http://www.w3.org/2000/svg" role="img" width="38"
                                            height="24" aria-labelledby="pi-visa">
                                            <title id="pi-visa">Visa</title>
                                            <path opacity=".07"
                                                d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z">
                                            </path>
                                            <path fill="#fff"
                                                d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32">
                                            </path>
                                            <path
                                                d="M28.3 10.1H28c-.4 1-.7 1.5-1 3h1.9c-.3-1.5-.3-2.2-.6-3zm2.9 5.9h-1.7c-.1 0-.1 0-.2-.1l-.2-.9-.1-.2h-2.4c-.1 0-.2 0-.2.2l-.3.9c0 .1-.1.1-.1.1h-2.1l.2-.5L27 8.7c0-.5.3-.7.8-.7h1.5c.1 0 .2 0 .2.2l1.4 6.5c.1.4.2.7.2 1.1.1.1.1.1.1.2zm-13.4-.3l.4-1.8c.1 0 .2.1.2.1.7.3 1.4.5 2.1.4.2 0 .5-.1.7-.2.5-.2.5-.7.1-1.1-.2-.2-.5-.3-.8-.5-.4-.2-.8-.4-1.1-.7-1.2-1-.8-2.4-.1-3.1.6-.4.9-.8 1.7-.8 1.2 0 2.5 0 3.1.2h.1c-.1.6-.2 1.1-.4 1.7-.5-.2-1-.4-1.5-.4-.3 0-.6 0-.9.1-.2 0-.3.1-.4.2-.2.2-.2.5 0 .7l.5.4c.4.2.8.4 1.1.6.5.3 1 .8 1.1 1.4.2.9-.1 1.7-.9 2.3-.5.4-.7.6-1.4.6-1.4 0-2.5.1-3.4-.2-.1.2-.1.2-.2.1zm-3.5.3c.1-.7.1-.7.2-1 .5-2.2 1-4.5 1.4-6.7.1-.2.1-.3.3-.3H18c-.2 1.2-.4 2.1-.7 3.2-.3 1.5-.6 3-1 4.5 0 .2-.1.2-.3.2M5 8.2c0-.1.2-.2.3-.2h3.4c.5 0 .9.3 1 .8l.9 4.4c0 .1 0 .1.1.2 0-.1.1-.1.1-.1l2.1-5.1c-.1-.1 0-.2.1-.2h2.1c0 .1 0 .1-.1.2l-3.1 7.3c-.1.2-.1.3-.2.4-.1.1-.3 0-.5 0H9.7c-.1 0-.2 0-.2-.2L7.9 9.5c-.2-.2-.5-.5-.9-.6-.6-.3-1.7-.5-1.9-.5L5 8.2z"
                                                fill="#142688"></path>
                                        </svg></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="#"><svg class="icon--full-color" viewBox="0 0 38 24"
                                            xmlns="http://www.w3.org/2000/svg" role="img" width="38"
                                            height="24" aria-labelledby="pi-master">
                                            <title id="pi-master">Mastercard</title>
                                            <path opacity=".07"
                                                d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z">
                                            </path>
                                            <path fill="#fff"
                                                d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32">
                                            </path>
                                            <circle fill="#EB001B" cx="15" cy="12" r="7"></circle>
                                            <circle fill="#F79E1B" cx="23" cy="12" r="7"></circle>
                                            <path fill="#FF5F00"
                                                d="M22 12c0-2.4-1.2-4.5-3-5.7-1.8 1.3-3 3.4-3 5.7s1.2 4.5 3 5.7c1.8-1.2 3-3.3 3-5.7z">
                                            </path>
                                        </svg></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="#"><svg class="icon--full-color" xmlns="http://www.w3.org/2000/svg"
                                            role="img" aria-labelledby="pi-american_express" viewBox="0 0 38 24"
                                            width="38" height="24">
                                            <title id="pi-american_express">American Express</title>
                                            <path fill="#000"
                                                d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3Z"
                                                opacity=".07"></path>
                                            <path fill="#006FCF"
                                                d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32Z">
                                            </path>
                                            <path fill="#FFF"
                                                d="M22.012 19.936v-8.421L37 11.528v2.326l-1.732 1.852L37 17.573v2.375h-2.766l-1.47-1.622-1.46 1.628-9.292-.02Z">
                                            </path>
                                            <path fill="#006FCF"
                                                d="M23.013 19.012v-6.57h5.572v1.513h-3.768v1.028h3.678v1.488h-3.678v1.01h3.768v1.531h-5.572Z">
                                            </path>
                                            <path fill="#006FCF"
                                                d="m28.557 19.012 3.083-3.289-3.083-3.282h2.386l1.884 2.083 1.89-2.082H37v.051l-3.017 3.23L37 18.92v.093h-2.307l-1.917-2.103-1.898 2.104h-2.321Z">
                                            </path>
                                            <path fill="#FFF"
                                                d="M22.71 4.04h3.614l1.269 2.881V4.04h4.46l.77 2.159.771-2.159H37v8.421H19l3.71-8.421Z">
                                            </path>
                                            <path fill="#006FCF"
                                                d="m23.395 4.955-2.916 6.566h2l.55-1.315h2.98l.55 1.315h2.05l-2.904-6.566h-2.31Zm.25 3.777.875-2.09.873 2.09h-1.748Z">
                                            </path>
                                            <path fill="#006FCF"
                                                d="M28.581 11.52V4.953l2.811.01L32.84 9l1.456-4.046H37v6.565l-1.74.016v-4.51l-1.644 4.494h-1.59L30.35 7.01v4.51h-1.768Z">
                                            </path>
                                        </svg></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="#"><svg class="icon--full-color" viewBox="0 0 38 24"
                                            xmlns="http://www.w3.org/2000/svg" width="38" height="24"
                                            role="img" aria-labelledby="pi-paypal">
                                            <title id="pi-paypal">PayPal</title>
                                            <path opacity=".07"
                                                d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z">
                                            </path>
                                            <path fill="#fff"
                                                d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32">
                                            </path>
                                            <path fill="#003087"
                                                d="M23.9 8.3c.2-1 0-1.7-.6-2.3-.6-.7-1.7-1-3.1-1h-4.1c-.3 0-.5.2-.6.5L14 15.6c0 .2.1.4.3.4H17l.4-3.4 1.8-2.2 4.7-2.1z">
                                            </path>
                                            <path fill="#3086C8"
                                                d="M23.9 8.3l-.2.2c-.5 2.8-2.2 3.8-4.6 3.8H18c-.3 0-.5.2-.6.5l-.6 3.9-.2 1c0 .2.1.4.3.4H19c.3 0 .5-.2.5-.4v-.1l.4-2.4v-.1c0-.2.3-.4.5-.4h.3c2.1 0 3.7-.8 4.1-3.2.2-1 .1-1.8-.4-2.4-.1-.5-.3-.7-.5-.8z">
                                            </path>
                                            <path fill="#012169"
                                                d="M23.3 8.1c-.1-.1-.2-.1-.3-.1-.1 0-.2 0-.3-.1-.3-.1-.7-.1-1.1-.1h-3c-.1 0-.2 0-.2.1-.2.1-.3.2-.3.4l-.7 4.4v.1c0-.3.3-.5.6-.5h1.3c2.5 0 4.1-1 4.6-3.8v-.2c-.1-.1-.3-.2-.5-.2h-.1z">
                                            </path>
                                        </svg></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="#"><svg class="icon--full-color" viewBox="0 0 38 24"
                                            xmlns="http://www.w3.org/2000/svg" role="img" width="38"
                                            height="24" aria-labelledby="pi-diners_club">
                                            <title id="pi-diners_club">Diners Club</title>
                                            <path opacity=".07"
                                                d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z">
                                            </path>
                                            <path fill="#fff"
                                                d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32">
                                            </path>
                                            <path
                                                d="M12 12v3.7c0 .3-.2.3-.5.2-1.9-.8-3-3.3-2.3-5.4.4-1.1 1.2-2 2.3-2.4.4-.2.5-.1.5.2V12zm2 0V8.3c0-.3 0-.3.3-.2 2.1.8 3.2 3.3 2.4 5.4-.4 1.1-1.2 2-2.3 2.4-.4.2-.4.1-.4-.2V12zm7.2-7H13c3.8 0 6.8 3.1 6.8 7s-3 7-6.8 7h8.2c3.8 0 6.8-3.1 6.8-7s-3-7-6.8-7z"
                                                fill="#3086C8"></path>
                                        </svg></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="#"><svg class="icon--full-color" viewBox="0 0 38 24" width="38"
                                            height="24" role="img" aria-labelledby="pi-discover" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <title id="pi-discover">Discover</title>
                                            <path fill="#000" opacity=".07"
                                                d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z">
                                            </path>
                                            <path
                                                d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32z"
                                                fill="#fff"></path>
                                            <path
                                                d="M3.57 7.16H2v5.5h1.57c.83 0 1.43-.2 1.96-.63.63-.52 1-1.3 1-2.11-.01-1.63-1.22-2.76-2.96-2.76zm1.26 4.14c-.34.3-.77.44-1.47.44h-.29V8.1h.29c.69 0 1.11.12 1.47.44.37.33.59.84.59 1.37 0 .53-.22 1.06-.59 1.39zm2.19-4.14h1.07v5.5H7.02v-5.5zm3.69 2.11c-.64-.24-.83-.4-.83-.69 0-.35.34-.61.8-.61.32 0 .59.13.86.45l.56-.73c-.46-.4-1.01-.61-1.62-.61-.97 0-1.72.68-1.72 1.58 0 .76.35 1.15 1.35 1.51.42.15.63.25.74.31.21.14.32.34.32.57 0 .45-.35.78-.83.78-.51 0-.92-.26-1.17-.73l-.69.67c.49.73 1.09 1.05 1.9 1.05 1.11 0 1.9-.74 1.9-1.81.02-.89-.35-1.29-1.57-1.74zm1.92.65c0 1.62 1.27 2.87 2.9 2.87.46 0 .86-.09 1.34-.32v-1.26c-.43.43-.81.6-1.29.6-1.08 0-1.85-.78-1.85-1.9 0-1.06.79-1.89 1.8-1.89.51 0 .9.18 1.34.62V7.38c-.47-.24-.86-.34-1.32-.34-1.61 0-2.92 1.28-2.92 2.88zm12.76.94l-1.47-3.7h-1.17l2.33 5.64h.58l2.37-5.64h-1.16l-1.48 3.7zm3.13 1.8h3.04v-.93h-1.97v-1.48h1.9v-.93h-1.9V8.1h1.97v-.94h-3.04v5.5zm7.29-3.87c0-1.03-.71-1.62-1.95-1.62h-1.59v5.5h1.07v-2.21h.14l1.48 2.21h1.32l-1.73-2.32c.81-.17 1.26-.72 1.26-1.56zm-2.16.91h-.31V8.03h.33c.67 0 1.03.28 1.03.82 0 .55-.36.85-1.05.85z"
                                                fill="#231F20"></path>
                                            <path d="M20.16 12.86a2.931 2.931 0 100-5.862 2.931 2.931 0 000 5.862z"
                                                fill="url(#pi-paint0_linear)"></path>
                                            <path opacity=".65"
                                                d="M20.16 12.86a2.931 2.931 0 100-5.862 2.931 2.931 0 000 5.862z"
                                                fill="url(#pi-paint1_linear)"></path>
                                            <path
                                                d="M36.57 7.506c0-.1-.07-.15-.18-.15h-.16v.48h.12v-.19l.14.19h.14l-.16-.2c.06-.01.1-.06.1-.13zm-.2.07h-.02v-.13h.02c.06 0 .09.02.09.06 0 .05-.03.07-.09.07z"
                                                fill="#231F20"></path>
                                            <path
                                                d="M36.41 7.176c-.23 0-.42.19-.42.42 0 .23.19.42.42.42.23 0 .42-.19.42-.42 0-.23-.19-.42-.42-.42zm0 .77c-.18 0-.34-.15-.34-.35 0-.19.15-.35.34-.35.18 0 .33.16.33.35 0 .19-.15.35-.33.35z"
                                                fill="#231F20"></path>
                                            <path
                                                d="M37 12.984S27.09 19.873 8.976 23h26.023a2 2 0 002-1.984l.024-3.02L37 12.985z"
                                                fill="#F48120"></path>
                                            <defs>
                                                <linearGradient id="pi-paint0_linear" x1="21.657" y1="12.275"
                                                    x2="19.632" y2="9.104" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#F89F20"></stop>
                                                    <stop offset=".25" stop-color="#F79A20"></stop>
                                                    <stop offset=".533" stop-color="#F68D20"></stop>
                                                    <stop offset=".62" stop-color="#F58720"></stop>
                                                    <stop offset=".723" stop-color="#F48120"></stop>
                                                    <stop offset="1" stop-color="#F37521"></stop>
                                                </linearGradient>
                                                <linearGradient id="pi-paint1_linear" x1="21.338" y1="12.232"
                                                    x2="18.378" y2="6.446" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#F58720"></stop>
                                                    <stop offset=".359" stop-color="#E16F27"></stop>
                                                    <stop offset=".703" stop-color="#D4602C"></stop>
                                                    <stop offset=".982" stop-color="#D05B2E"></stop>
                                                </linearGradient>
                                            </defs>
                                        </svg></a>
                                </li>
                            </ul>
                            <p class="py-2">We support the card type above</p>

                            <div class="row g-4 mt-2 mb-4">
                                <div class="col-md-12">
                                    <form class="checkout-form">
                                        <div class="row g-4">
                                            <div class="col-12">
                                                <div class="">
                                                    <label class="form-label">Name</label>
                                                    <input type="text" class="form-control" placeholder="Name"
                                                        value="" />
                                                </div>
                                            </div><!--/*col -->
                                            <div class="col-12">
                                                <div class="">
                                                    <label class="form-label">Card Number</label>
                                                    <div id="card-number-element" class="form-control"></div>
                                                </div>
                                            </div><!--/*col -->
                                            <div class="col-6">
                                                <div class="">
                                                    <label class="form-label">Exp. Date</label>
                                                    <div id="card-expiry-element" class="form-control"></div>
                                                </div>
                                            </div><!--/*col -->
                                            <div class="col-6">
                                                <div class="">
                                                    <label class="form-label">CVC</label>
                                                    <div id="card-cvc-element" class="form-control"></div>
                                                </div>
                                            </div><!--/*col -->
                                        </div><!--/*row -->
                                    </form>


                                    <div class="betweenflex d-none">
                                        <div class="mb-3">
                                            <label class="form-label">Exp. Date</label>
                                            <input type="text" class="form-control" placeholder="Exp. Date"
                                                value="12/30" />
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">CVV</label>
                                            <input type="text" class="form-control" placeholder="CVV"
                                                value="123" />
                                        </div>
                                    </div>
                                </div><!--/*col -->
                            </div><!--/*row -->

                            <div class="mb-3">
                                <label class="form-label">Billing Address</label>
                                <div class="alignflex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="flexRadioDefault" checked />
                                        <label class="form-check-label">Same as shipping</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="flexRadioDefault" />
                                        <label class="form-check-label">Use a different address</label>
                                    </div>
                                </div>
                            </div>

                            <div class="btn-flex mt-4">
                                <a href="<?php echo e(route('aibuilder.purchase.step2')); ?>" class="btn btn-outline-light">Back</a>
                                <a href="javascript:void(0)" id="submit-button" class="btn btn-dark">Pay now</a>
                            </div>


                        </div><!--/*Credit Card -->




                        <div class="tab-pane fade" id="nav-paypal" role="tabpanel" aria-labelledby="nav-paypal-tab"
                            tabindex="0">
                            <div class="alert alert-primary">
                                You current balance is AED <?php echo e(auth()->user()->walletbalance); ?> in your wallet
                            </div>
                            <button class="btn btn-md btn-primary mt-3" id="payUsingWallet">Pay using wallet</button>
                        </div>
                        <div class="tab-pane fade" id="nav-paypal-credit" role="tabpanel"
                            aria-labelledby="nav-paypal-credit-tab" tabindex="0">
                            <div class="alert alert-primary">
                                Coming Soon !!!
                            </div>
                        </div>
                    </div><!--/*tab-content -->
                </div><!--/*col -->

            </div><!--/*row -->
        </div><!--/*container -->
    </section><!--/*checkout-page -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" type="text/javascript"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
    <script src="<?php echo e(asset('assets/services/js/checkout.js')); ?>" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>


    <script src="https://js.stripe.com/v3/"></script>
    <script>
        $(document).ready(function() {
            const stripePublicKey = "<?php echo e(env('STRIPE_PUBLIC_KEY')); ?>";
            const stripe = Stripe(stripePublicKey);
            const elements = stripe.elements();

            const style = {
                base: {
                    color: '#fff',
                    fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                    fontSize: '16px',
                    '::placeholder': {
                        color: '#aab7c4',
                    },
                },
                invalid: {
                    color: '#fa755a',
                    iconColor: '#fa755a',
                },
            };

            const cardNumber = elements.create('cardNumber', {
                style
            });
            const cardExpiry = elements.create('cardExpiry', {
                style
            });
            const cardCvc = elements.create('cardCvc', {
                style
            });

            cardNumber.mount('#card-number-element');
            cardExpiry.mount('#card-expiry-element');
            cardCvc.mount('#card-cvc-element');

            $('#submit-button').on('click', async function(event) {
                var btn = $(this);
                var btn_html = btn.html();

                btn.html("<i class='fa fa-spinner fa-spin'></i>");

                disableLink(btn);

                $("#error").addClass('hide');
                event.preventDefault();
                const intentUrl = "<?php echo e(route('aiBuilder.CreatePaymentIntent')); ?>";
                const data = {
                    _token: '<?php echo e(csrf_token()); ?>'
                };

                try {

                    $.post(intentUrl, data, async function(response) {
                        
                        if (!response.result) {
                            enableLink(btn);
                            showToast("error", "Error", response.msg ??
                                "Some error occured");
                            btn.html(btn_html)
                            return;
                        }

                        const {
                            clientSecret
                        } = response;

                        // Confirm the card payment
                        const {
                            error,
                            paymentIntent
                        } = await stripe.confirmCardPayment(clientSecret, {
                            payment_method: {
                                card: cardNumber,
                            },
                        });

                        if (error) {
                            enableLink(btn);
                            $("#error").removeClass('hide');
                            $("#error").html("Error: " + error.message);
                            btn.html(btn_html);
                            showToast("error", "Error", error.message ??
                                "Some error occured");
                        } else if (paymentIntent.status === 'succeeded') {

                            var transactionId = paymentIntent.id;
                            var transactionAmount = paymentIntent.amount / 100;
                            var transactionUrl = '<?= url('transactions/add') ?>';
                            var transactionData = {
                                transactionId: transactionId,
                                amount: transactionAmount,
                                payment_method: 'stripe',
                                status: 'completed',
                                _token: '<?php echo e(csrf_token()); ?>'
                            };
                            var url = "<?php echo e(route('ai.website.purchase.complete')); ?>";
                            $.post(url, transactionData, function(data) {
                                btn.html(btn_html);
                                enableLink(btn);
                                if (!data.result) {
                                    showToast("error", "Error", data.msg ??
                                        "Some error occured")
                                    btn.html(btn_html)
                                    return;
                                }
                                if (data.result) {
                                    showToast("success", "Success",
                                        "Subscription Purchased Successfully",
                                        true, 'Move To Dashboard', () => {
                                            location.href =
                                                '<?php echo e(route('ai.websites', ['page' => 1])); ?>';
                                            btn.html(btn_html)
                                        });

                                    setTimeout(() => {
                                        location.href =
                                            '<?php echo e(route('ai.websites', ['page' => 1])); ?>';
                                    }, 4000);

                                }
                            }).fail(function() {
                                enableLink(btn);
                                showToast("error", "Error", "Some error occured");
                                btn.html(btn_html)
                            });


                        }

                    });

                } catch (err) {
                    enableLink(btn);
                    showToast("error", "Error", "Some error occured");
                    btn.html(btn_html)
                }


            });


        });
    </script>
    <script>
        function generalError(msg) {
            $.confirm({
                title: "Error",
                content: msg,
                icon: "fa fa-times-circle",
                type: "red",
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }
                }
            });
        }

        $("#payUsingWallet").on('click', function() {
            var balance = parseFloat("<?php echo e(auth()->user()->walletbalance); ?>");
            var price = parseFloat("<?php echo e($total_price); ?>");

            if (balance < price) {
                showToast("error", "Error", "Insufficient Balanace");
                return;
            }

            var btn = $(this);
            var btn_html = btn.html();

            btn.prop('disabled', true).html("<i class='fa fa-spinner fa-spin'></i>");

            var route = "<?php echo e(route('ai.website.purchase.completeUsingWallet')); ?>";

            $.post(route, {
                _token: "<?php echo e(csrf_token()); ?>",
                amount: price
            }, function(data) {
                if (data.result) {
                    showToast("success", "Success ! ", "Subscription activated successfully", true, "Move To Dashboard", ()=>{
                          location.href = '<?php echo e(route('ai.websites', ['page' => 1])); ?>';
                    });

                    setTimeout(() => {
                        location.href = '<?php echo e(route('ai.websites', ['page' => 1])); ?>';
                    }, 4000);
                
                } else {
                    showToast("error", "Error", data.msg ?? "Some error occured");
                    btn.prop('disabled', false).html(btn_html);
                }
            }).fail(function() {
                showToast("error", "Error", "Some error occured");
                btn.prop('disabled', false).html(btn_html);
            });
        });

        function disableLink($a) {
            $a.addClass('is-disabled')
            .attr({ 'aria-disabled': 'true', 'tabindex': '-1' })
            .data('href', $a.attr('href'))
            .removeAttr('href')
            .html("<i class='fa fa-spinner fa-spin'></i>")
            .on('click.disabled', e => e.preventDefault());
        }

        function enableLink($a, html) {
            $a.removeClass('is-disabled')
            .removeAttr('aria-disabled tabindex')
            .attr('href', $a.data('href'))
            .off('click.disabled')
            .html(html);
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('aibuilder.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/aibuilder/checkout.blade.php ENDPATH**/ ?>