<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Protected Link</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/short_links/css/global.css')); ?>">
    <style>
      body, html { min-height:100vh; }
      .glass-card{background:rgba(255,255,255,.15);backdrop-filter:blur(10px);border-radius:14px;border:1px solid rgba(255,255,255,.2)}
      .state-title{color:#fff}
    </style>
  </head>
  <body>
    <div class="container py-5">
      <div class="glass-card p-4 mx-auto" style="max-width:560px;">
        <?php if(($state ?? '') === 'prompt'): ?>
          <h4 class="state-title mb-2">🔒 This link is password protected.</h4>
          <?php if(!empty($error)): ?>
            <div class="alert alert-danger py-2"><?php echo e($error); ?></div>
          <?php endif; ?>
          <form method="post" action="<?php echo e(isset($link) ? url('go/'.$link->backhalf) : '#'); ?>">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
              <label class="text-white-50 mb-2">Enter Password</label>
              <input type="password" class="form-control" name="password" placeholder="Enter password" required>
            </div>
            <button class="btn btn-primary">Continue</button>
          </form>
        <?php elseif(($state ?? '') === 'expired'): ?>
          <h4 class="state-title mb-2">⚠️ This link has expired.</h4>
          <p class="text-white-50">The link you're trying to access is no longer active.</p>
          <a href="<?php echo e(url('/')); ?>" class="btn btn-outline-light">Go Back Home</a>
        <?php elseif(($state ?? '') === 'paused'): ?>
          <h4 class="state-title mb-2">⏸ This link is currently paused by the owner.</h4>
          <p class="text-white-50">Please try again later.</p>
          <a href="<?php echo e(url('/')); ?>" class="btn btn-outline-light">Go Back Home</a>
        <?php elseif(($state ?? '') === 'invalid'): ?>
          <h4 class="state-title mb-2">❌ Invalid short link.</h4>
          <p class="text-white-50">This link does not exist or has been removed.</p>
          <a href="<?php echo e(url('/')); ?>" class="btn btn-outline-light">Go Back Home</a>
        <?php endif; ?>
      </div>
    </div>
  </body>
 </html>
<?php /**PATH /home/shortlink/public_html/packages/ShortLink/src/Providers/../resources/views/protect.blade.php ENDPATH**/ ?>