<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>AFLI - Turning your ideas into Reality</title>
    <meta name="description" content="AFLI - Turning your ideas into Reality" />
    <meta name="keywords"
        content="agency, app, business, company, corporate, designer, freelance, fullpage, modern, office, personal, portfolio, professional, web, web agency" />
    <meta name="author" content="Themexriver" />
    <link rel="shortcut icon" href="<?php echo e(asset('assets/logo_maker/img/logo/f-icon.png')); ?>" type="image/x-icon" />
    <!-- Mobile Specific Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/fontawesome.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/flaticon_aina.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/global.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/logo_maker/css/logo-maker.css')); ?>" />

    <link href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Rubik+Gemstones&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Bungee&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Knewave&display=swap" rel="stylesheet">

    <style>
        .playFul{
            font-family: "Rubik Gemstones", serif;
            font-weight: 400;
            font-style: normal;
        }
        .bungee{
            font-family: "Bungee", serif;
            font-weight: 400;
            font-style: normal;
        }
        .handwriting
        {
            font-family: "Knewave", serif;
            font-weight: 400;
            font-style: normal;
        }
        .responsive_text{
            font-size:4rem !important;
            color: #fff;
        }
        .logoCard
        {
            height:100%;
            position: relative;
        }
        .logoCard .download_icons{
            position: absolute;
            top:10px;
            right:30px;
        }
        .saveIconToDb
        {
            color:#fff;
            border:1px solid #fff;
            padding:10px;
            border-radius:50px !important;
        }
        .uploadAndSave
        {
                color:#fff;
            border:1px solid #fff;
            padding:10px;
            border-radius:50px !important;
            
        }
    </style>


</head>

<body class="AFLI-home">
    <header id="hap-header" class="hap-header-section">
        <div class="container">
            <div class="hap-header-top-area">
                <div class="top-info-cta-social d-flex justify-content-between align-items-center">
                    <div class="top-info-cta ul-li">
                        <ul>
                            <li>
                                <a href="./login"><i class="fas fa-user"></i> Customer Sign In</a>
                            </li>
                            <li>
                                <a target="_blank" href="https://wa.me/971582422625"><i class="fas fa-phone"></i>
                                    WhatsApp +971 58 242 2625</a>
                            </li>
                        </ul>
                    </div>
                    <div class="top-social-area">
                        <a target="_blank" href="https://www.instagram.com/afli.ae/">
                            <i class="fab fa-instagram"></i></a>
                        <a target="_blank" href="https://www.linkedin.com/company/afliae/">
                            <i class="fab fa-linkedin-in"></i></a>
                        <a target="_blank" href="https://www.facebook.com/Afli.ae">
                            <i class="fab fa-facebook"></i></a>
                    </div>
                </div>
            </div>
            <div class="hap-header-menu-navigation d-flex align-items-center justify-content-between">
                <div class="brand-logo">
                    <a href="<?php echo e(route('logo.home')); ?>"><img src="<?php echo e(asset('assets/logo_maker/img/logo/logo1.png')); ?>"
                            alt="" /></a>
                </div>
                <nav class="main-navigation clearfix ul-li">
                    <ul id="main-nav" class="nav navbar-nav clearfix">
                        <li class="nav-item">
                            <a href="<?php echo e(url('/')); ?>" class="nav-link active" href="#hap-banner">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#hap-about">About</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#hap-service">Service</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#hap-pricing">Pricing</a>
                        </li>
                    </ul>
                </nav>
                <div class="spacing-div"></div>
            </div>
            <div class="mobile_menu position-relative">
                <div class="mobile_menu_button open_mobile_menu">
                    <i class="fal fa-bars"></i>
                </div>
                <div class="mobile_menu_wrap">
                    <div class="mobile_menu_overlay open_mobile_menu"></div>
                    <div class="mobile_menu_content">
                        <div class="mobile_menu_close open_mobile_menu">
                            <i class="fal fa-times"></i>
                        </div>
                        <div class="m-brand-logo">
                            <a href="!#"><img src="<?php echo e(asset('assets/logo_maker/img/logo/logo2.png')); ?>"
                                    alt="" /></a>
                        </div>
                        <div class="mobile-search-bar position-relative">
                            <form action="#">
                                <input type="text" name="search" placeholder="Keywords" />
                                <button><i class="fal fa-search"></i></button>
                            </form>
                        </div>
                        <nav class="mobile-main-navigation clearfix ul-li">
                            <ul id="m-main-nav" class="nav navbar-nav clearfix">
                                <li class="nav-item">
                                    <a class="nav-link active" href="#hap-banner">Home</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#hap-about">About</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#hap-service">Service</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#hap-pricing">Pricing</a>
                                </li>
                            </ul>
                        </nav>
                        <div class="bi-mobile-header-social text-center">
                            <a target="_blank" href="https://www.instagram.com/afli.ae/">
                                <i class="fab fa-instagram"></i></a>
                            <a target="_blank" href="https://www.linkedin.com/company/afliae/">
                                <i class="fab fa-linkedin-in"></i></a>
                            <a target="_blank" href="https://www.facebook.com/Afli.ae">
                                <i class="fab fa-facebook"></i></a>
                        </div>
                    </div>
                </div>
                <!-- /Mobile-Menu -->
            </div>
        </div>
    </header>
    <!-- Sidebar sidebar Item -->
    <div class="xs-sidebar-group info-group">
        <div class="xs-overlay xs-bg-black">
            <div class="row loader-area">
                <div class="col-3 preloader-wrap">
                    <div class="loader-bg"></div>
                </div>
                <div class="col-3 preloader-wrap">
                    <div class="loader-bg"></div>
                </div>
                <div class="col-3 preloader-wrap">
                    <div class="loader-bg"></div>
                </div>
                <div class="col-3 preloader-wrap">
                    <div class="loader-bg"></div>
                </div>
            </div>
        </div>
        <div class="xs-sidebar-widget">
            <div class="sidebar-widget-container">
                <div class="widget-heading">
                    <a href="#" class="close-side-widget text-uppercase">
                        <i class="fal fa-times"></i> Close
                    </a>
                </div>
                <div class="sidebar-textwidget">
                    <!-- Sidebar Info Content -->
                    <div class="sidebar-info-contents headline pera-content">
                        <div class="content-inner">
                            <div class="sidebar-logo">
                                <a href="#"><img src="<?php echo e(asset('assets/logo_maker/img/logo/logo2.png')); ?>"
                                        alt="" /></a>
                            </div>
                            <div class="sidebar-menu ul-li-block">
                                <ul>
                                    <li>
                                        <a href="about.html"><i class="fal fa-home"></i> About Us
                                        </a>
                                    </li>
                                    <li>
                                        <a href="service.html"><i class="fal fa-cogs"></i> Service
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="sidebar-more-menu text-uppercase d-flex ul-li">
                                <span>More:</span>
                                <ul>
                                    <li><a href="#">My Account </a></li>
                                    <li><a href="#">Job Apply </a></li>
                                    <li><a href="#">Privacy Policy </a></li>
                                </ul>
                            </div>
                            <div class="sidebar-social ul-li-block">
                                <span>Social:</span>
                                <ul>
                                    <li>
                                        <a target="_blank" href="https://www.facebook.com/Afli.ae"><i
                                                class="fab fa-facebook-f"></i> Facebook</a>
                                    </li>
                                    <li>
                                        <a target="_blank" href="https://www.instagram.com/afli.ae/"><i
                                                class="fab fa-instagram"></i> Instagram</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="sidebar-copyright text-center">
                                © Copyright 2023. All Rights Reserved.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End of Header section
 ============================================= -->

    <!-- Start Of Logo Maker Section
 ======================================= -->

    <section id="logo-maker">
        <!-- Background decorations -->
        <div class="decoration" style="width: 100px; height: 100px; top: 10%; left: 10%"></div>
        <div class="decoration" style="width: 150px; height: 150px; top: 20%; right: 15%"></div>
        <div class="decoration" style="width: 80px; height: 80px; bottom: 30%; left: 20%"></div>

        <div class="container py-5">
            <!-- Step 1 -->
            <div class="step active animate__animated" id="step1">
                <div class="row align-items-center justify-content-center min-vh-75">
                    <div class="col-lg-8 text-center">
                        <div class="logo-container mb-4">
                            <h1 class="display-4 fw-bold mb-3 color-primary">Free Logo Maker</h1>
                            <p class="lead mb-5">Create beautiful logos in 5 minutes</p>
                        </div>
                        <div class="col-lg-8 mx-auto">
                            <div class="input-group mb-3">
                                <div class="input-container">
                                    <input class="input" name="text" id="brand_name" type="text"
                                        placeholder="Enter your Brand Name" />
                                    <label class="label" for="input">Your Brand Name</label>
                                    <div class="topline"></div>
                                    <div class="underline"></div>
                                </div>
                                <button class="btn btn-create text-white" id="startFreeLogo">
                                    Create free logo
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 2 -->
            <div class="step animate__animated" id="step2">
                <div class="row align-items-center justify-content-center min-vh-75">
                    <div class="col-lg-8 text-center">
                        <div class="logo-container mb-4">
                            <h1 class="display-4 fw-bold mb-3 color-primary">Free Logo Maker</h1>
                            <p class="lead mb-5">Create beautiful logos in 5 minutes</p>
                        </div>

                        <div class="col-lg-8 mx-auto">
                            <div class="input-group mb-3">
                                <div class="input-container">
                                    <input class="input input-lg" name="text" type="text" id="businessType"
                                        placeholder="Type of Business (optional)" />
                                    <label class="label" for="input">Type of Business</label>
                                    <div class="topline"></div>
                                    <div class="underline"></div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <button class="btn btn-outline-light me-2" id="BackToStepOne">
                                Back
                            </button>

                            <button id="moveToThirdStep" class="btn btn-create btn-next text-white">
                                Next
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 3 -->
            <div class="step animate__animated" id="step3">
                <!-- Sub Step 1 -->

                <div class="sub-step active" id="sub-step1">
                    <div class="container cards-container">
                        <h1 class="text-center mb-1">Choose a Style</h1>
                        <p class="text-center mb-1">Pick your Favorite Font (1/3)</p>

                        <!-- Cards -->
                        <div class="row justify-content-center">
                            <div class="col-md-4">
                                <div class="style-card selectFont" data-font="playFul">
                                    <h2 class="serif-font playFul brandName">Brand Name</h2>
                                    <p class="serif-font">
                                        Rubik Gemstone: Geometric, Bold, Playful & Modern
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="style-card selectFont" data-font="bungee">
                                    <h2 class="sans-serif-font bungee brandName">Brand Name</h2>
                                    <p class="sans-serif-font">
                                        Display Typefaces: Bold, Energetic, Playful & Urban
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="style-card selectFont" data-font="handwriting">
                                    <h2 class="handwritten-font handwriting brandName">Brand Name</h2>
                                    <p class="handwritten-font">
                                        Calligraphic / Handwritten: Elegant, Friendly, Humble &
                                        Bold
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Step 4 -->
            <div class="step animate__animated" id="step4">
                <div class="container palette-container">
                    <h1 class="text-center mb-2">Pick your Favorite Color</h1>
                    <p class="text-center mb-5">What Color works best for <span class="brandName">csdcsdc</span>?</p>

                    <div class="row g-4">
                        <!-- Blue Palette -->
                        <div class="col-md-2">
                            <div class="color-card selectColor" data-color1="0066ff" data-color2="4d94ff" data-color3="99c2ff" data-color4="e6f0ff">
                                <div class="color-strip blue-palette">
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                </div>
                                <div class="description">Friendly, Loyal & Peaceful</div>
                            </div>
                        </div>

                        <!-- Green Palette -->
                        <div class="col-md-2">
                            <div class="color-card selectColor" data-color1="00b894" data-color2="55ebd0" data-color3="a6f5e6" data-color4="e6faf7">
                                <div class="color-strip green-palette">
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                </div>
                                <div class="description">Natural, Happy, Natural & Calm</div>
                            </div>
                        </div>

                        <!-- Purple Palette -->
                        <div class="col-md-2">
                            <div class="color-card selectColor" data-color1="9b51e0" data-color2="bb86fc" data-color3="d4b3fd" data-color4="f3ebff">
                                <div class="color-strip purple-palette">
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                </div>
                                <div class="description">Bold, Engaging & Vibrant</div>
                            </div>
                        </div>

                        <!-- Pink Palette -->
                        <div class="col-md-2">
                            <div class="color-card selectColor" data-color1="e91e63" data-color2="f06292" data-color3="f8bbd0" data-color4="fce4ec">
                                <div class="color-strip pink-palette">
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                </div>
                                <div class="description">Intense, Warm & Romantic</div>
                            </div>
                        </div>

                        <!-- Brown Palette -->
                        <div class="col-md-2">
                            <div class="color-card selectColor" data-color1="5d4037" data-color2="8d6e63" data-color3="bcaaa4" data-color4="efebe9">
                                <div class="color-strip brown-palette">
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                </div>
                                <div class="description">Somber, Earthy, Solid & Natural</div>
                            </div>
                        </div>

                        <!-- Orange Palette -->
                        <div class="col-md-2">
                            <div class="color-card selectColor" data-color1="ff4b2b" data-color2="ff7e65" data-color3="ffbcad" data-color4="ffe8e0">
                                <div class="color-strip orange-palette">
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                    <div class="color-segment"></div>
                                </div>
                                <div class="description">Cheerful, Vibrant & Happy</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 5 -->
            <div class="step animate__animated" id="step5">
                <div class="container icons-container">
                    <h1 class="text-center mb-2">Choose Icons</h1>
                    <p class="text-center mb-4">
                        Search & pick your 3 favorite icons
                    </p>

                    <div class="search-container">
                        <input type="text" id="searchIconsInput" class="search-input" placeholder="Or search for icons here" />
                    </div>

                    <div class="icon-grid">
                        <div class="row justify-content-center" id="svgIcons">
                            
                        </div>
                    </div>

                    <div class="selected-count">
                        <span id="numberOfSelectedIcons">0</span><span> of 3 icons selected</span>
                    </div>

                    <div class="text-center mt-2">

                        <button class="btn btn-create text-white btn-next text-align-center" id="generateLogo">Generate Logo</button>
                    </div>

                </div>
            </div>

            <!-- Step 6 -->
            <div class="step" id="step6">
                <div class="row align-items-center justify-content-center min-vh-75">
                    <div class="col-lg-8 text-center">
                        <h2 class="display-5 mb-4">Results</h2>
                        <div class="row g-4 justify-content-center" id="finalLogoRow">
                        </div>
                        <div class="mt-4">
                            <button class="btn btn-outline-light me-2" onclick="previousStep(1)">
                                Generate More
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="wave-bottom"></div>
    </section>

    <!-- Start of Footer section
 ============================================= -->
    <section id="hap-footer" class="hap-footer-section"
        data-background="<?php echo e(asset('assets/logo_maker/img/home_5/bg/footer-bg.jpg')); ?>">
        <div class="hap-footer-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="logo-widget">
                                <div class="brand-logo">
                                    <a href="#"><img src="<?php echo e(asset('assets/logo_maker/img/logo/logo2.png')); ?>"
                                            alt="" /></a>
                                </div>
                                <p>
                                    Made using clean, non-toxic ingredients, our products are
                                    signed for everyone. Made using clean, non-toxic
                                </p>
                                <div class="logo-cta ul-li-block">
                                    <ul>
                                        <li>
                                            <a href="#"><i class="fas fa-map-marker-alt"></i> Address: No 40
                                                Baria, US</a>
                                        </li>
                                        <li>
                                            <a href="#"><i class="fas fa-envelope"></i> Email:
                                                envato@gmail.com</a>
                                        </li>
                                        <li>
                                            <a href="#"><i class="fas fa-phone"></i>Phone: (+123) 938 9832</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="hap-contact-social text-uppercase d-flex">
                                    <a target="_blank" href="https://www.facebook.com/Afli.ae"><i
                                            class="fab fa-facebook-f"></i> Facebook</a>
                                    <a href="#"><i class="fab fa-instagram"></i> Instagram</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="menu-widget ul-li-block">
                                <h3 class="widget-title text-uppercase">quick links</h3>
                                <ul>
                                    <li><a href="#">FAQ</a></li>
                                    <li><a href="#">Trems Condition</a></li>
                                    <li><a href="#">Payment info</a></li>
                                    <li><a href="#">Privacy Notice</a></li>
                                    <li><a href="#">Billing</a></li>
                                    <li><a href="#">Size Chart</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="menu-widget ul-li-block">
                                <h3 class="widget-title text-uppercase">categories</h3>
                                <ul>
                                    <li><a href="#">Cosmatic </a></li>
                                    <li><a href="#">Services</a></li>
                                    <li><a href="#">Payment info</a></li>
                                    <li><a href="#">Size Chart</a></li>
                                    <li><a href="#">Women Product</a></li>
                                    <li><a href="#">Billing</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="hap-footer-widget hap-headline pera-content">
                            <div class="newslatter-widget">
                                <h3 class="widget-title text-uppercase">subcribe</h3>
                                <p>You can be always date with our company news</p>
                                <form action="#" method="get">
                                    <input type="email" name="email" placeholder="Subcribe email" />
                                    <button><i class="fal fa-long-arrow-right"></i></button>
                                </form>
                                <div class="tranding-service ul-li">
                                    <h4 class="text-uppercase">Trending services</h4>
                                    <ul>
                                        <li>
                                            <a href="#"><img
                                                    src="<?php echo e(asset('assets/logo_maker/img/home_5/icon/ic8.png')); ?>"
                                                    alt="" /></a>
                                        </li>
                                        <li>
                                            <a href="#"><img
                                                    src="<?php echo e(asset('assets/logo_maker/img/home_5/icon/ic9.png')); ?>"
                                                    alt="" /></a>
                                        </li>
                                        <li>
                                            <a href="#"><img
                                                    src="<?php echo e(asset('assets/logo_maker/img/home_5/icon/ic10.png')); ?>"
                                                    alt="" /></a>
                                        </li>
                                        <li>
                                            <a href="#"><img
                                                    src="<?php echo e(asset('assets/logo_maker/img/home_5/icon/ic11.png')); ?>"
                                                    alt="" /></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="hap-footer-copyright text-center">
            © 2023 Envato All Rights Reserved.
        </div>
    </section>
    <!-- End of Footer section
 ============================================= -->

    <!-- For Js Library -->
    <script src="<?php echo e(asset('assets/logo_maker/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/logo_maker/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/logo_maker/js/gsap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/logo_maker/js/ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/logo_maker/js/script.js')); ?>"></script>
    <script>
        let searchIconRoute = "<?php echo e(route('logo.searchIcons')); ?>";
        let _token = "<?php echo e(csrf_token()); ?>";
        let downloadIconRoute = "<?php echo e(route('logo.downloadIcon')); ?>";
        let downloadFileRoute = "<?php echo e(route('logo.saveLogoFile')); ?>";
        let logoDashboard = "<?php echo e(route('logo.dashboard')); ?>";
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="<?php echo e(asset('assets/logo_maker/js/logo_creation.js')); ?>"></script>
    <script>
       

        const searchInput = document.querySelector('.search-input');
        searchInput.addEventListener('input', (e) => {
            const searchTerm = e.target.value.toLowerCase();
        });
    </script>


    <script>
        document.querySelectorAll(".style-thumb").forEach((thumb, index) => {
            thumb.addEventListener("click", () => {
                document
                    .querySelectorAll(".style-thumb")
                    .forEach((t) => t.classList.remove("active"));
                document
                    .querySelectorAll(".style-card")
                    .forEach((c) => c.classList.remove("active"));

                thumb.classList.add("active");
                document
                    .querySelectorAll(".style-card")[index].classList.add("active");
            });
        });
    </script>

    <script>
        function nextStep(step) {
            document.querySelectorAll(".step").forEach((el) => {
                el.classList.remove("active");
            });
            document.getElementById("step" + step).classList.add("active");
            console.log(step);
        }

        function previousStep(step) {
            document.querySelectorAll(".step").forEach((el) => {
                el.classList.remove("active");
            });
            document.getElementById("step" + step).classList.add("active");
            console.log(step);
        }

        function nextSubStep(step) {
            document.querySelectorAll(".sub-step").forEach((el) => {
                el.classList.remove("active");
            });
            document.getElementById("sub-step" + step).classList.add("active");
            console.log(step);
        }

        function previousSubStep(step) {
            document.querySelectorAll(".sub-step").forEach((el) => {
                el.classList.remove("active");
            });
            document.getElementById("sub-step" + step).classList.add("active");
            console.log(step);
        }
    </script>
</body>

</html>
<?php /**PATH /home/logomaker/public_html/packages/LogoMaker/src/Providers/../resources/views/logos/index.blade.php ENDPATH**/ ?>