<?php
    use Carbon\Carbon;
    $isExpired = Carbon::parse($subscription->expires_on)->isPast();
?>

<?php $__env->startSection('css'); ?>
    <style>
        body {
            font-family: "Exo", sans-serif !important;
        }

        .exo {
            font-family: "Exo", sans-serif !important;

        }
    </style>
    <style>
        .btn-close.red-x {
            filter: brightness(0) saturate(100%) invert(16%) sepia(91%) saturate(7485%) hue-rotate(356deg) brightness(93%) contrast(105%);
        }
    </style>
    <style>
        thead th {
            text-align: center;
        }
    </style>
    <style>
        .exo {
            font-family: "Exo", sans-serif;
            font-optical-sizing: auto;
            font-weight: 500;
            font-style: normal;
        }

        thead th {
            text-align: center;
        }

        .card-video-container {
            height: 450px !important;
        }

        .pendingtext {
            position: absolute;
            top: -150%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 18px;
            width: 100%;
            text-align: center
        }

        .pendingtext p {
            text-align: center;
        }

        .jconfirm.jconfirm-modern .jconfirm-box {
            background: rgba(55, 55, 55, 0.6) !important;
        }

        .jconfirm-title {
            color: #fff !important;
        }

        .jconfirm.jconfirm-modern .jconfirm-box div.jconfirm-content {
            color: #fff !important;
        }

        .modal-content {

            background: rgba(55, 55, 55, 1.0) !important;
        }

        #paymentModalHeading {
            color: #fff !important;
        }

        #paymentModal label {
            color: #fff !important;
        }

        #paymentModal .card_elements {
            background-color: transparent;
            border-color: #fff !important;
        }

        #paymentModal .card_elements::placeholder {
            color: lightgray;
        }

        #paymentModal .card_elements {
            color: #fff !important;
        }

        #completeCreditCardPayment {
            background: linear-gradient(45deg, var(--golden) 0%, var(--light-golden) 100%);
            border-radius: 100px;
            will-change: transform;
            color: black;
            font-weight: 600;
            font-size: 14px;
            margin-top: 10px;
            transition: .4s all ease;
            padding-left: 30px;
            padding-right: 30px;
            text-align: center;
            margin: 10px auto;
            border-color: transparent;
        }
    </style>

    <style>
        .nissan-header-main {
            position: relative;
            left: 0;
            top: 0;
            width: 100%;
            z-index: 999;
        }

        .left-bumber-front-style-set {
            width: 60px;
            position: relative;
            background-color: white;
            clip-path: polygon(100% 0%, 100% 100%, 50% 61%, 11% 12%, 24% 0%);
            margin-right: -1px;
        }

        .right-bumber-front-style-set {
            width: 60px;
            position: relative;
            background-color: white;
            clip-path: polygon(0% 0%, 0% 100%, 50% 61%, 89% 12%, 76% 0%);
            margin-left: -1px;
        }

        .left-bmp-style-set-s-d {
            /* Adding backdrop filter for glass blur effect */
            backdrop-filter: blur(15px);
            /* Increase the blur value for more effect */
            -webkit-backdrop-filter: blur(15px);
            /* Safari support */

            /* Optional: You can adjust opacity for a better glass effect */
            opacity: 0.9;
            /* Adjust the transparency to make the effect more prominent */
            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.837),
                    rgba(170, 170, 170, 0.8));

            /* background-color: red; */
            clip-path: polygon(0% 0%,
                    85% 0%,
                    82% 17%,
                    87% 50%,
                    98% 100%,
                    10% 100%,
                    2% 50%);
            margin-right: -45px;
        }

        .left-bmp-style-set-s-d ul {
            margin-right: 60px;
        }

        .left-bmp-style-set-s-d {
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);

            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.837),
                    rgba(170, 170, 170, 0.86));

            clip-path: polygon(0% 0%,
                    85% 0%,
                    82% 17%,
                    87% 50%,
                    98% 100%,
                    10% 100%,
                    2% 50%);
            margin-right: -45px;
        }

        .left-bmp-style-set-s-d ul {
            margin-right: 60px;
        }

        .right-bmp-style-set-s-d {
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);

            background: linear-gradient(135deg,
                    rgba(204, 204, 204, 0.837),
                    rgba(170, 170, 170, 0.86));

            clip-path: polygon(100% 0%,
                    15% 0%,
                    18% 17%,
                    13% 50%,
                    2% 100%,
                    90% 100%,
                    98% 50%);

            margin-left: -45px;
        }

        .right-bmp-style-set-s-d .welcome-container {
            margin-left: 60px;
        }

        .welcome-container {
            padding: 12px 20px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .welcome-text {
            color: white;
            font-size: 14px;
            font-weight: 400;
            margin: 0;
        }

        .separator {
            color: white;
            margin: 0 4px;
        }

        .avatar {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            object-fit: cover;
            background-color: #ccc;
        }

        .overlay-style-set-d-s {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.342);
            z-index: 10;
            display: none;
            transition: 0.3s;
        }

        .offcanvas-main-sidebar-style-set-d {
            position: fixed;
            left: -300px;
            top: 0;
            min-height: 100vh;
            width: 300px;
            background-color: white;
            z-index: 11;
            /* display: none; */
            transition: 0.3s;
        }

        #sideBarCloseBtn {
            display: block;
            text-align: center;
        }

        .mobile-view-menu-style-set {
            display: none;
        }

        .bottom-icons-sidebar-fixed-style {
            width: 267px;
        }

        .nav-link-style-set-s {
            font-size: 20px;
            text-align: start;
        }

        .sidebar-list-height-set-style {
            height: 100vh;
        }

        .cart-count-style {
            position: absolute;
            right: -7px;
            top: -5px;
            background-color: #000;
            color: white;
            border-radius: 50%;
            width: 17px;
            height: 17px;
            font-size: 12px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media(max-width:550px) {
            .hideMobile {
                display: none !important;
            }
        }

        .nissan-header-main {
            max-width: 100vw;

        }

        .popup-menu {
            position: absolute !important;
            top: 60px;
            /* Adjust based on avatar size */
            right: 30px;
            background: white;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
            border-radius: 5px;
            padding: 10px;
            min-width: 150px;
            z-index: 9999;
            /* Ensure it's always above */
            text-align: left;
            display: none;

        }

        .popup-menu a {
            display: block;
            /* Ensure each link is on a new line */
            padding: 10px;
            text-decoration: none;
            color: black;
            font-size: 14px;
            transition: background 0.3s;
        }

        .popup-menu a:hover {
            background: #f1f1f1;
            border-radius: 3px;
        }

        .content-library .tab-content .card .more-edit {
            display: block !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="pricing-section py-5">
        <div class="container">

            <div class="wrap mb-4">
                <div class="">
                    <h1 class="main__heading mb-0 me-3 text-dark fw-bold">Pricing For</h1>
                </div>

                <div class="dropdown custom-dropdown">
                    <a class="btn btn-info dropdown-toggle fa" href="#" role="button" data-bs-toggle="dropdown"
                        aria-expanded="false">
                        <span id="selected">&#xf0ac; AI Ecommerce</span>
                    </a>

                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item fa" href="#">&#xf0f3; AI Ecommerce</a></li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li><a class="dropdown-item fa" href="#">&#xf0ac; AI Website</a></li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li><a class="dropdown-item fa" href="#"><i>&#xf0e0;</i> AI Mail</a></li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li><a class="dropdown-item fa" href="#">&#xf1ad; AI Social Media</a></li>
                    </ul>
                </div>
            </div>
            <span class="switch">
                <label class="h4 me-2 text-dark fw-bold">Monthly</label>
                <input type="checkbox" class="switch" id="switch-id" />
                <label class="h4 text-dark fw-bold" for="switch-id">Annually</label>
            </span>

            <div class="">
                <div class="main__cards cards">
                    <div class="cards__inner">

                        <?php if(!$packages->isEmpty()): ?>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="cards__card card monthly">
                                    <h2 class="card__heading"><?php echo e($package->name); ?></h2>
                                    <p class="card__price" data-monthly="<?php echo e($package->price); ?>"
                                        data-annual="<?php echo e($package->price * 12); ?>">
                                        <?php echo e(currency_symbol()); ?><?php echo e($package->price); ?>

                                    </p>
                                    <ul role="list" class="card__bullets flow">

                                        <?php
                                            $features = json_decode($package->features);
                                        ?>

                                        <?php if(!empty($features)): ?>
                                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <?php echo e($feature); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>


                                    </ul>
                                    <?php if($package->id == $activeSubscription): ?>
                                        <?php if($isExpired): ?>
                                            <p class="text-center text-danger fw-bold">
                                                Expired
                                            </p>
                                        <?php elseif($subscription->status == 'cancelled'): ?>
                                             <p class="text-center text-danger fw-bold">
                                                Cancelled
                                            </p>
                                        <?php else: ?>
                                            <p class="text-center text-danger fw-bold">
                                                
                                                Expires On <?php echo e(date('d F Y', strtotime($subscription->expires_on))); ?>

                                            </p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a href="javascript:void(0)" class="card__cta cta openPaymentModal"
                                        data-price="<?php echo e($package->price); ?>" data-id="<?php echo e($package->id); ?>">
                                        <?php if($package->id == $activeSubscription): ?>
                                            Renew
                                            <br>
                                        <?php else: ?>
                                            Upgrade
                                        <?php endif; ?>
                                    </a>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="overlay cards__inner"></div>
                </div>
            </div><!-- Monthly -->


            <div class="modal fade" id="subscriptionPaymentModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content modal-content-transparent transparent-bg">
                        <div class="modal-header border-0">
                            <h3 class="exo text-white fw-bold">Pay Now</h3>
                            <button type="button" class="btn-close red-x" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" id="subscription_type">
                            <input type="hidden" id="selectedPackage">
                            <ul class="nav nav-tabs mb-4" id="paymentTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="credit-tab" data-bs-toggle="tab"
                                        data-bs-target="#credit" type="button" role="tab" aria-controls="credit"
                                        aria-selected="true">
                                        Credit Card
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="wallet-tab" data-bs-toggle="tab" data-bs-target="#wallet"
                                        type="button" role="tab" aria-controls="wallet" aria-selected="false">
                                        Wallet
                                    </button>
                                </li>
                            </ul>
                            <div class="tab-content" id="paymentTabsContent">
                                <!-- Credit Card Tab -->
                                <div class="tab-pane fade show active" id="credit" role="tabpanel"
                                    aria-labelledby="credit-tab">
                                    <div class="row g-4">
                                        <div class="col-md-12">
                                            <form class="checkout-form">
                                                <div class="row g-4">
                                                    <div class="col-12">
                                                        <label class="form-label text-white">Name</label>
                                                        <input type="text" class="form-control" placeholder="Name"
                                                            value="" />
                                                    </div>
                                                    <div class="col-12">
                                                        <label class="form-label text-white">Card Number</label>
                                                        <div id="card-number-element" class="form-control"></div>
                                                    </div>
                                                    <div class="col-6">
                                                        <label class="form-label text-white">Exp. Date</label>
                                                        <div id="card-expiry-element" class="form-control"></div>
                                                    </div>
                                                    <div class="col-6">
                                                        <label class="form-label text-white">CVC</label>
                                                        <div id="card-cvc-element" class="form-control"></div>
                                                    </div>
                                                </div>
                                            </form>
                                            <div class="btn-flex mt-4">
                                                <a href="javascript:void(0)" id="submit-button" class="btn btn-dark">Pay
                                                    now</a>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="wallet" role="tabpanel" aria-labelledby="wallet-tab">
                                    <div class="text-white">
                                        <p class="mb-3">Use wallet balance to complete the payment.</p>
                                        <p class="fw-bold">Available Balance: AED <?php echo e(auth()->user()->walletbalance); ?> </p>
                                        <button class="btn btn-md btn-primary"id="payUsingWallet">Pay with Wallet</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div><!-- container -->
    </section><!-- pricing-section -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        $(document).ready(function() {
            const stripePublicKey = "<?php echo e(env('STRIPE_PUBLIC_KEY')); ?>";
            const stripe = Stripe(stripePublicKey);
            const elements = stripe.elements();

            const style = {
                base: {
                    color: '#000',
                    fontFamily: '"Exo", sans-serif',
                    fontSize: '16px',
                    '::placeholder': {
                        color: '#aab7c4',
                    },
                },
                invalid: {
                    color: '#fa755a',
                    iconColor: '#fa755a',
                },
            };

            const cardNumber = elements.create('cardNumber', {
                style
            });
            const cardExpiry = elements.create('cardExpiry', {
                style
            });
            const cardCvc = elements.create('cardCvc', {
                style
            });

            cardNumber.mount('#card-number-element');
            cardExpiry.mount('#card-expiry-element');
            cardCvc.mount('#card-cvc-element');


              $('#submit-button').on('click', async function(event) {
                var btn = $(this);
                var btn_html = btn.html();

				btn.html("<i class='fa fa-spinner fa-spin' style='padding:0px !important;'></i>");

                $("#error").addClass('hide');
                event.preventDefault();


                var subscriptionId = $("#selectedPackage").val();
                var type = $("#subscription_type").val();
                var route = "<?php echo e(route('ecommerce.renewSubscription')); ?>";
                var activeSubscription = "<?php echo e($activeSubscription); ?>";
                const url = "<?php echo e(route('ecommerce.renew.payment_intent')); ?>";
                const data = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    subscriptionId:subscriptionId,
                    type:type
                };

                try{

                    $.post(url, data, async function(response){
                        console.log(response);
                        if(!response.result)
                        {
                            generalError(response.msg);
							btn.html(btn_html)
                            return;
                        }

                        const {
                            clientSecret
                        } = response;

                        // Confirm the card payment
                        const {
                            error,
                            paymentIntent
                        } = await stripe.confirmCardPayment(clientSecret, {
                            payment_method: {
                                card: cardNumber,
                            },
                        });

                        if (error) {
                            console.error("Payment failed:", error.message);
                            generalError(error.message);
                            btn.html(btn_html);
                            generalError(error.message);
                        } else if (paymentIntent.status === 'succeeded') {
                            const charge = paymentIntent.charges?.data?.[0];
                            const transactionId = charge?.id ?? paymentIntent.id;
                            var transactionAmount = paymentIntent.amount / 100;
                            var transactionUrl = '<?= url('transactions/add') ?>';
                            var transactionData = {
                                transactionId: transactionId,
                                amount: transactionAmount,
                                payment_method: 'stripe',
                                status: 'completed',
                                _token: "<?php echo e(csrf_token()); ?>",
                                subscriptionId:subscriptionId,
                                type:type,
                                activeSubscription:"<?php echo e($subscription->id); ?>"
                            };

                            var url = "<?php echo e(route('ecommerce.renew.completeStripeCheckout')); ?>";
                            $.post(url, transactionData, function(data){
                                if(!data.result)
                                {
                                    var msg = "Some error occured";
                                    if(data.msg)
                                    {
                                        msg = data.msg;
                                    }   
                                    generalError(error);
                                    return;
                                }

                                 $.confirm({
                                    title: "Package Renewed",
                                    content: "Package Renewed Successfully",
                                    icon: "fa fa-check-circle",
                                    type: "green",
                                    buttons: {
                                        confirm: {
                                            text: 'OK',
                                            btnClass: 'btn-green',
                                            action: function() {
                                                location.href =
                                                    '<?= url('ecommerce/subscriptions') ?>'
                                            }
                                        }
                                    }
                                });

                            }).fail(function(){
                                generalError("some error occured");
                            })
                        }

                    }).fail(function(){
                        generalError("Some error occured");
                    });

                }catch (err) {
                    console.error("Error occurred:", err);
                    generalError("Some error occured");
					btn.html(btn_html)
                }


            });

        });
    </script>
    <script>
        $('.dropdown-menu a').click(function() {
            $('#selected').text($(this).text());
        });
    </script>

    <script>
        $('#switch-id').on('change', function() {
            var currencySymbol = "<?php echo e(currency_symbol()); ?>";

            $(".card__price").each(function() {
                var monthly = parseFloat($(this).data('monthly'));
                var annual = parseFloat($(this).data('annual'));

                if ($('#switch-id').is(':checked')) {

                    $(this).html(currencySymbol + " " + annual.toFixed(2));
                } else {
                    $(this).html(currencySymbol + " " + monthly.toFixed(2));
                }
            });
        });
    </script>
    <script>
        $(document).on('click', '.openPaymentModal', function() {
            var subscriptionType = "monthly";
            var subscriptionId = $(this).attr('data-id');
            $("#selectedPackage").val(subscriptionId);
          
            if ($('#switch-id').is(':checked')) {
                subscriptionType = "yearly";
            }
              $("#subscription_type").val(subscriptionType);
            $("#subscriptionPaymentModal").modal('show');
        });
    </script>
    <script>
        $("#payUsingWallet").on('click', function() {
            var subscriptionId = $("#selectedPackage").val();
            var type = $("#subscription_type").val();
            var route = "<?php echo e(route('ecommerce.renewSubscription')); ?>";
            var activeSubscription = "<?php echo e($activeSubscription); ?>";
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<span class='fa fa-spinner fa-spin' style='padding:0px !important;'></span>");
     
            $.post(route, {_token:"<?php echo e(csrf_token()); ?>", subscriptionId:subscriptionId, type:type, activeSubscription:"<?php echo e($subscription->id); ?>"}, function(data){
                var msg = "Some error occured";
                btn.html(btn_html);
                if(!data.result)
                {
                    if(data.msg)
                    {
                        msg = data.msg;
                    }   
                    generalError(msg);
                    return;   
                }
                $.confirm({
                    title: "Package Renewed",
                    content: "Package Renewed Successfully",
                    icon: "fa fa-check-circle",
                    type: "green",
                    buttons: {
                        confirm: {
                            text: 'OK',
                            btnClass: 'btn-green',
                            action: function() {
                                location.href =
                                    '<?= url('ecommerce/subscriptions') ?>'
                            }
                        }
                    }
                });

            }).fail(function(){
                btn.html(btn_html);
                generalError("Some error occured");
            })
        });


        
    function generalError(msg) {
        $.confirm({
            title: "Error",
            content: msg,
            icon: "fa fa-times-circle",
            type: "red",
            buttons: {
                confirm: {
                    text: 'OK',
                    btnClass: 'btn-red',
                    action: function() {}
                }
            }
        });
    }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ecommerce.purchase.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/ecommerce/renew_subscription.blade.php ENDPATH**/ ?>